/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.commandline;

import java.util.Collection;
import org.broadinstitute.gatk.utils.commandline.ArgumentDefinition;
import org.broadinstitute.gatk.utils.commandline.ArgumentException;

class MissingArgumentException
extends ArgumentException {
    public MissingArgumentException(Collection<ArgumentDefinition> missingArguments) {
        super(MissingArgumentException.formatArguments(missingArguments));
    }

    private static String formatArguments(Collection<ArgumentDefinition> missingArguments) {
        StringBuilder sb = new StringBuilder();
        for (ArgumentDefinition missingArgument : missingArguments) {
            if (missingArgument.shortName != null) {
                sb.append(String.format("%nArgument with name '--%s' (-%s) is missing.", missingArgument.fullName, missingArgument.shortName));
                continue;
            }
            sb.append(String.format("%nArgument with name '--%s' is missing.", missingArgument.fullName));
        }
        return sb.toString();
    }
}

