/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.io.File;
import net.sf.picard.PicardException;
import net.sf.picard.cmdline.CommandLineProgram;
import net.sf.picard.cmdline.Option;
import net.sf.picard.cmdline.Usage;
import net.sf.picard.io.IoUtil;
import net.sf.picard.util.Log;
import net.sf.picard.util.ProgressLogger;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMFileWriterFactory;
import net.sf.samtools.SAMRecord;

public class ReplaceSamHeader
extends CommandLineProgram {
    @Usage
    public String USAGE = this.getStandardUsagePreamble() + "Replace the SAMFileHeader in a SAM file with the given header. " + "Validation is minimal.  It is up to the user to ensure that all the elements referred to in the SAMRecords " + "are present in the new header.  Sort order of the two input files must be the same.";
    @Option(doc="SAM file from which SAMRecords will be read.", shortName="I")
    public File INPUT;
    @Option(doc="SAM file from which SAMFileHeader will be read.")
    public File HEADER;
    @Option(doc="SAMFileHeader from HEADER file will be written to this file, followed by SAMRecords from INPUT file", shortName="O")
    public File OUTPUT;

    public static void main(String[] argv) {
        new ReplaceSamHeader().instanceMainWithExit(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        SAMFileReader.ValidationStringency originalStringency = SAMFileReader.getDefaultValidationStringency();
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        try {
            IoUtil.assertFileIsReadable(this.INPUT);
            IoUtil.assertFileIsReadable(this.HEADER);
            IoUtil.assertFileIsWritable(this.OUTPUT);
            SAMFileReader headerReader = new SAMFileReader(this.HEADER);
            SAMFileHeader replacementHeader = headerReader.getFileHeader();
            SAMFileReader recordReader = new SAMFileReader(this.INPUT);
            if (replacementHeader.getSortOrder() != recordReader.getFileHeader().getSortOrder()) {
                throw new PicardException("Sort orders of INPUT (" + recordReader.getFileHeader().getSortOrder().name() + ") and HEADER (" + replacementHeader.getSortOrder().name() + ") do not agree.");
            }
            SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(replacementHeader, true, this.OUTPUT);
            ProgressLogger progress = new ProgressLogger(Log.getInstance(ReplaceSamHeader.class));
            for (SAMRecord rec : recordReader) {
                rec.setHeader(replacementHeader);
                writer.addAlignment(rec);
                progress.record(rec);
            }
            writer.close();
            headerReader.close();
            recordReader.close();
        }
        finally {
            SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)originalStringency);
        }
        return 0;
    }
}

