/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.variant.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypesContext;

public class LazyGenotypesContext
extends GenotypesContext {
    final LazyParser parser;
    Object unparsedGenotypeData;
    final int nUnparsedGenotypes;
    boolean loaded = false;
    private static final ArrayList<Genotype> EMPTY = new ArrayList(0);

    @Requires(value={"parser != null", "unparsedGenotypeData != null", "nUnparsedGenotypes >= 0"})
    public LazyGenotypesContext(LazyParser parser, Object unparsedGenotypeData, int nUnparsedGenotypes) {
        super(EMPTY);
        this.parser = parser;
        this.unparsedGenotypeData = unparsedGenotypeData;
        this.nUnparsedGenotypes = nUnparsedGenotypes;
    }

    @Override
    @Ensures(value={"result != null"})
    protected ArrayList<Genotype> getGenotypes() {
        this.decode();
        return this.notToBeDirectlyAccessedGenotypes;
    }

    public void decode() {
        if (!this.loaded) {
            LazyData parsed = this.parser.parse(this.unparsedGenotypeData);
            this.notToBeDirectlyAccessedGenotypes = parsed.genotypes;
            this.sampleNamesInOrder = parsed.sampleNamesInOrder;
            this.sampleNameToOffset = parsed.sampleNameToOffset;
            this.loaded = true;
            this.unparsedGenotypeData = null;
        }
    }

    @Override
    protected synchronized void ensureSampleNameMap() {
        if (!this.loaded) {
            this.decode();
        } else {
            super.ensureSampleNameMap();
        }
    }

    @Override
    protected synchronized void ensureSampleOrdering() {
        if (!this.loaded) {
            this.decode();
        } else {
            super.ensureSampleOrdering();
        }
    }

    @Override
    protected void invalidateSampleNameMap() {
        if (!this.loaded) {
            this.decode();
        }
        super.invalidateSampleNameMap();
    }

    @Override
    protected void invalidateSampleOrdering() {
        if (!this.loaded) {
            this.decode();
        }
        super.invalidateSampleOrdering();
    }

    @Override
    public boolean isEmpty() {
        return this.loaded ? super.isEmpty() : this.nUnparsedGenotypes == 0;
    }

    @Override
    public int size() {
        return this.loaded ? super.size() : this.nUnparsedGenotypes;
    }

    public Object getUnparsedGenotypeData() {
        return this.unparsedGenotypeData;
    }

    public static class LazyData {
        final ArrayList<Genotype> genotypes;
        final Map<String, Integer> sampleNameToOffset;
        final List<String> sampleNamesInOrder;

        @Requires(value={"genotypes != null", "sampleNamesInOrder != null", "sampleNameToOffset != null"})
        public LazyData(ArrayList<Genotype> genotypes, List<String> sampleNamesInOrder, Map<String, Integer> sampleNameToOffset) {
            this.genotypes = genotypes;
            this.sampleNamesInOrder = sampleNamesInOrder;
            this.sampleNameToOffset = sampleNameToOffset;
        }
    }

    public static interface LazyParser {
        @Requires(value={"data != null"})
        @Ensures(value={"result != null"})
        public LazyData parse(Object var1);
    }
}

