/*
 * cthd_cdev_rapl.h: thermal cooling class interface
 *	using RAPL
 * Copyright (C) 2012 Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 or later as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 *
 * Author Name <Srinivas.Pandruvada@linux.intel.com>
 *
 */

#ifndef THD_CDEV_RAPL_H_
#define THD_CDEV_RAPL_H_

#include "thd_cdev.h"
#include "thd_sys_fs.h"

class cthd_sysfs_cdev_rapl: public cthd_cdev {
protected:
	int phy_max;
	int package_id;
	int constraint_index;
	bool dynamic_phy_max_enable;
	int pl0_max_pwr;
	int pl0_min_pwr;
	int pl0_min_window;
	int pl0_step_pwr;
	bool bios_locked;

	virtual bool calculate_phy_max();
	virtual bool read_ppcc_power_limits();

public:
	static const int rapl_no_time_windows = 6;
	static const long def_rapl_time_window = 1000000; // micro seconds
	static const int rapl_min_default_step = 500000; //0.5W
	static const int rapl_max_sane_phy_max = 100000000; // Some sane very high value in uW

	static const int rapl_low_limit_percent = 25;
	static const int rapl_power_dec_percent = 5;

	cthd_sysfs_cdev_rapl(unsigned int _index, int package) :
			cthd_cdev(_index,
					"/sys/devices/virtual/powercap/intel-rapl/intel-rapl:0/"), phy_max(
					0), package_id(package), constraint_index(0), dynamic_phy_max_enable(
					false), pl0_max_pwr(0), pl0_min_pwr(0), pl0_min_window(0), pl0_step_pwr(
					0), bios_locked(false) {
	}
	virtual void set_curr_state(int state, int arg);
	virtual int get_curr_state();
	virtual int get_max_state();
	virtual int update();
	virtual void set_curr_state_raw(int state, int arg);
	int map_target_state(int target_valid, int target_state);
};

#endif /* THD_CDEV_RAPL_H_ */
