.TH scanimage 1 "10 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX scanimage
.SH NAME
scanimage \- scan an image
.SH SYNOPSIS
.B scanimage
.RB [ \-d
.IR dev ]
.RB [ \-\-format\fI=output-format ]
.RB [ \-i
.IR profile ]
.RB [ \-L ]
.RB [ \-f
.IR device-format ]
.RB [ \-b
.RI [ format ]]
.RB [ \-\-batch\-start\fI=start ]
.RB [ \-\-batch\-count\fI=count ]
.RB [ \-\-batch\-increment\fI=increment ]
.RB [ \-\-batch\-double ]
.RB [ \-\-accept\-md5\-only ]
.RB [ \-p]
.RB [ \-o
.IR path ]
.RB [ \-n ]
.RB [ \-T ]
.RB [ \-A ]
.RB [ \-h ]
.RB [ \-v ]
.RB [ \-B
.RI size ]
.RB [ \-V ]
.RI [ device\-specific\-options ]
.SH DESCRIPTION
.B scanimage
is a command-line interface to control image acquisition devices such
as flatbed scanners or cameras.  The device is controlled via
command-line options.  After command-line processing,
.B scanimage
normally proceeds to acquire an image.  The image data is written to
standard output in one of the PNM (portable aNyMaP) formats (PBM for
black-and-white images, PGM for grayscale images, and PPM for color
images), TIFF format (black-and-white, grayscale or color), PNG format,
or JPEG format (compression level 75).
.B scanimage
accesses image acquisition devices through the
.B SANE
(Scanner Access Now Easy) interface and can thus support any device for which
there exists a
.B SANE
backend (try
.B apropos
.I sane\-
to get a list of available backends).

.SH EXAMPLES
To get a list of devices:

  scanimage \-L

To scan with default settings to the file image.pnm:

  scanimage >image.pnm

To scan 100x100 mm to the file image.tiff (\-x and \-y may not be available with
all devices):

  scanimage \-x 100 \-y 100 \-\-format=tiff >image.tiff

To print all available options:

  scanimage \-h

.SH OPTIONS
There are two sets of options available when running
.BR scanimage .
.PP
The options that are provided by
.B scanimage
itself are listed below. In addition, each backend offers its own set of options and these
can also be specified. Note that the options available from the backend may vary depending on the
scanning device that is selected.
.PP
Often options that are similar in function may be implemented
differently across backends. An example of this difference is
.I \-\-mode Gray
and
.IR "\-\-mode Grayscale" .
This may be due to differing backend author preferences.
At other times, options are defined by the scanning device itself and therefore out of the
control of the backend code.

.PP
Parameters are separated by a blank from single-character options (e.g.
.BI "\-d " epson \fR)
and by a "=" from multi-character options (e.g.
.BR \-\-device\-name =\fIepson \fR).

.TP
.BR \-d "\fI dev\fR, " \-\-device\-name =\fIdev\fR
specifies the device to access and must be followed by a SANE device-name like
.RI ` epson:/dev/sg0 '
or
.RI ` hp:/dev/usbscanner0 '.
A (partial) list of available devices can be obtained with the
.B \-\-list\-devices
option (see below).  If no device-name is specified explicitly,
.B scanimage
reads a device-name from the environment variable
.BR SANE_DEFAULT_DEVICE .
If this variable is not set,
.B scanimage
will attempt to open the first available device.

.TP
.BR \-\-format =\fIoutput-format\fR
selects how image data is written to standard output or the file specified by
the
.B \-\-output\-file
option.
.I output-format
can be
.BR pnm ,
.BR tiff ,
.BR png ,
or
.BR jpeg .
If
.B \-\-format
is not specified, PNM is written by default.

.TP
.BR \-i "\fI profile\fR, " \-\-icc\-profile =\fIprofile\fR
is used to include an ICC profile into a TIFF file.

.TP
.BR \-L ", " \-\-list\-devices
requests a (partial) list of devices that are available.  The
list may not be complete since some devices may be available, but are not
listed in any of the configuration files (which are typically stored
in directory
.IR @CONFIGDIR@ ).
This is particularly the case when accessing scanners through the network.  If
a device is not listed in a configuration file, the only way to access it is
by its full device name.  You may need to consult your system administrator to
find out the names of such devices.

.TP
.BR \-f "\fI format\fR, " \-\-formatted\-device\-list =\fIdevice-format\fR
works similarly to
.BR \-\-list\-devices ,
but requires a format string.
.B scanimage
replaces the placeholders
.B %d %v %m %t %i %n
with the device name, vendor name, model name, scanner type, an index
number and newline respectively. The command
.LP
.RS
.B scanimage \-f
.I \*(lq scanner number %i device %d is a %t, model %m, produced by %v \*(rq
.LP

will produce something like:
.PP
.RS
scanner number 0  device sharp:/dev/sg1 is  a  flatbed scanner, model JX250
SCSI, produced by SHARP
.RE
.RE

.PP
The
.B \-\-batch*
options provide features for scanning documents using document
feeders.

.RS

.TP
.BR \-b " [\fIformat\fR], " \-\-batch =[\fIformat\fR]
is used to specify the format of the filename that each page will be written
to.  Each page is written out to a single file.  If
.I format
is not specified, the default of
.I out%d.pnm
(or
.I out%d.tif
for
.BR "\-\-format tiff" ,
.I out%d.png
for
.B "\-\-format png"
or
.I out%d.jpg
for
.BR "\-\-format jpeg" )
will be used.
This option is incompatible with the
.B \-\-output\-path
option.
.I format
is given as a printf style string with one integer parameter.


.TP
.BR \-\-batch\-start =\fIstart\fR
selects the page number to start naming files with. If this option is not
given, the counter will start at 1.

.TP
.BR \-\-batch\-count =\fIcount\fR
specifies the number of pages to attempt to scan.  If not given,
.B scanimage
will continue scanning until the scanner returns a state
other than OK.  Not all scanners with document feeders signal when the
ADF is empty. Use this option to work around them.

.TP
.BR \-\-batch\-increment =\fIincrement\fR
sets the amount that the number in the filename is incremented
by.  Generally this is used when you are scanning double-sided documents
on a single-sided document feeder.
.B \-\-batch\-double
is a specific command provided to aid this.

.TP
.B \-\-batch\-double
will automatically set the increment to 2.
Equivalent to
.BR \-\-batch\-increment =2.

.TP
.B \-\-batch\-prompt
will ask for pressing RETURN before scanning a page. This can be used for
scanning multiple pages without an automatic document feeder.
.RE

.TP
.B \-\-accept\-md5\-only
only accepts user authorization requests that support MD5 security. The
.B SANE
network daemon
.BR saned (8)
is capable of doing such requests.

.TP
.BR \-p ", " \-\-progress
requests that
.B scanimage
prints a progress counter. It shows how much image data of the current image has
already been received (in percent).

.TP
.BR \-o "\fI path\fR, " \-\-output\-file =\fIpath\fR
requests that
.B scanimage
saves the scanning output to the given
.IR path .
This option is incompatible with the
.B \-\-batch
option. The program will try to guess
.B \-\-format
from the file name. If that is not possible, it will print an error message and exit.

.TP
.BR \-n ", " \-\-dont\-scan
requests that
.B scanimage
only sets the options provided by the user but doesn't actually perform a
scan. This option can be used to e.g. turn off the scanner's lamp (if
supported by the backend).

.TP
.BR \-T ", " \-\-test
requests that
.B scanimage
performs a few simple sanity tests to make sure the backend works as
defined by the
.B SANE
API. In particular the
.BR sane_read ()
function is exercised by this test.

.TP
.BR \-A ", " \-\-all\-options
requests that
.B scanimage
lists all available options exposed by the backend, including button options.
The information is printed on standard output and no scan will be performed.

.TP
.BR \-h ", " \-\-help
requests help information.  The information is printed on
standard output and no scan will be performed.

.TP
.BR \-v ", " \-\-verbose
increases the verbosity of the output of
.BR scanimage .
The option may be specified repeatedly, each time increasing the verbosity
level.

.TP
.BR \-B " [\fIsize\fR], " \-\-buffer\-size =\fIsize
changes input buffer size from the default of 1MB to
.I size
KB.

.TP
.BR \-V ", " \-\-version
requests that
.B scanimage
prints the program and package name, the version number of
the
.B SANE
distribution that it came with and the version of the backend that it
loads. If more information about the version
numbers of the backends are necessary, the
.B DEBUG
variable for the dll layer can be used. Example:
.IR "SANE_DEBUG_DLL=3 scanimage \-L" .
.PP
As you might imagine, much of the power of
.B scanimage
comes from the fact that it can control any
.B SANE
backend.  Thus, the exact set of command-line options depends on the
capabilities of the selected device.  To see the options for a device named
.IR dev ,
invoke
.B scanimage
via a command-line of the form:
.PP
.RS
scanimage \-\-help \-\-device\-name
.I dev
.RE
.PP
The documentation for the device-specific options printed by
.B \-\-help
is best explained with a few examples:

.B \-l 0..218mm [0]
.RS
Top-left x position of scan area.
.PP
The description above shows that option
.B \-l
expects an option value in the range from 0 to 218 mm.  The
value in square brackets indicates that the current option value is 0
mm. Most backends provide similar geometry options for top-left y position
.RB ( \-t ),
width
.RB ( \-x )
and height of scan-area
.RB (\-y ).
.RE


.B \-\-brightness \-100..100% [0]
.RS
Controls the brightness of the acquired image.
.PP
The description above shows that option
.B \-\-brightness
expects an option value in the range from \-100 to 100 percent.  The
value in square brackets indicates that the current option value is 0
percent.
.RE

.B \-\-default\-enhancements
.RS
Set default values for enhancement controls.
.PP
The description above shows that option
.B \-\-default\-enhancements
has no option value.  It should be thought of as having an immediate
effect at the point of the command-line at which it appears.  For
example, since this option resets the
.B \-\-brightness
option, the option-pair
.B \-\-brightness 50 \-\-default\-enhancements
would effectively be a no-op.
.RE

.B \-\-mode Lineart|Gray|Color [Gray]
.RS
Selects the scan mode (e.g., lineart or color).
.PP
The description above shows that option
.B \-\-mode
accepts an argument that must be one of the strings
.BR Lineart ,
.BR Gray ,
or
.BR Color .
The value in the square bracket indicates that the option is currently
set to
.BR Gray .
For convenience, it is legal to abbreviate the string values as long as
they remain unique.  Also, the case of the spelling doesn't matter.  For
example, option setting
.B \-\-mode col
is identical to
.BR "\-\-mode Color" .
.RE

.B \-\-custom\-gamma[=(yes|no)] [inactive]
.RS
Determines whether a builtin or a custom gamma-table should be used.
.PP
The description above shows that option
.B \-\-custom\-gamma
expects either no option value, a "yes" string, or a "no" string.
Specifying the option with no value is equivalent to specifying "yes".
The value in square-brackets indicates that the option is not
currently active.  That is, attempting to set the option would result
in an error message.  The set of available options typically depends
on the settings of other options.  For example, the
.B \-\-custom\-gamma
table might be active only when a grayscale or color scan-mode has
been requested.

Note that the
.B \-\-help
option is processed only after all other options have been processed.
This makes it possible to see the option settings for a particular
mode by specifying the appropriate mode-options along
with the
.B \-\-help
option.  For example, the command-line:
.PP
.B  scanimage \-\-help \-\-mode
.I color
.PP
would print the option settings that are in effect when the color-mode
is selected.
.RE

.B \-\-gamma\-table 0..255,...
.RS
Gamma-correction table.  In color mode this option
equally affects the red, green, and blue channels
simultaneously (i.e., it is an intensity gamma table).
.PP
The description above shows that option
.B \-\-gamma\-table
expects zero or more values in the range 0 to 255.  For example, a
legal value for this option would be "3,4,5,6,7,8,9,10,11,12".  Since
it's cumbersome to specify long vectors in this form, the same can be
expressed by the abbreviated form "[0]3-[9]12".  What this means is
that the first vector element is set to 3, the 9-th element is set to
12 and the values in between are interpolated linearly.  Of course, it
is possible to specify multiple such linear segments.  For example,
"[0]3-[2]3-[6]7,[7]10-[9]6" is equivalent to "3,3,3,4,5,6,7,10,8,6".
The program
.B gamma4scanimage
can be used to generate such gamma tables (see
.BR gamma4scanimage (1)
for details).
.RE

.B \-\-filename <string> [/tmp/input.ppm]
.RS
The filename of the image to be loaded.
.PP
The description above is an example of an option that takes an
arbitrary string value (which happens to be a filename).  Again,
the value in brackets show that the option is current set to the
filename
.IR /tmp/input.ppm .
.RE

.SH ENVIRONMENT
.TP
.B SANE_DEFAULT_DEVICE
The default device-name.
.SH FILES
.TP
.I @CONFIGDIR@
This directory holds various configuration files.  For details, please
refer to the manual pages listed below.
.TP
.I ~/.sane/pass
This file contains lines of the form
.PP
.RS
user:password:resource
.PP
.B scanimage
uses this information to answer user authorization requests
automatically. The file must have 0600 permissions or stricter. You should
use this file in conjunction with the
.B \-\-accept\-md5\-only
option to avoid
server-side attacks. The resource may contain any character but is limited
to 127 characters.

.SH "SEE ALSO"
.BR sane (7),
.BR gamma4scanimage (1),
.BR xscanimage (1),
.BR xcam (1),
.BR xsane (1),
.BR scanadf (1),
.BR sane\-dll (5),
.BR sane\-net (5),
.BR sane\-"backendname" (5)

.SH AUTHOR
David Mosberger, Andreas Beck, Gordon Matzigkeit, Caskey Dickson, and many
others.  For questions and comments contact the sane\-devel mailinglist (see
.IR http://www.sane\-project.org/mailing\-lists.html ).

.SH BUGS
For vector options, the help output currently has no indication as to
how many elements a vector-value should have.
