/* concurrentlist.c generated by valac 0.21.2.4-6740f, the Vala compiler
 * generated from concurrentlist.vala, do not modify */

/* concurrentlist.vala
 *
 * Copyright (C) 2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_CONCURRENT_LIST (gee_concurrent_list_get_type ())
#define GEE_CONCURRENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_CONCURRENT_LIST, GeeConcurrentList))
#define GEE_CONCURRENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_CONCURRENT_LIST, GeeConcurrentListClass))
#define GEE_IS_CONCURRENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_CONCURRENT_LIST))
#define GEE_IS_CONCURRENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_CONCURRENT_LIST))
#define GEE_CONCURRENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_CONCURRENT_LIST, GeeConcurrentListClass))

typedef struct _GeeConcurrentList GeeConcurrentList;
typedef struct _GeeConcurrentListClass GeeConcurrentListClass;
typedef struct _GeeConcurrentListPrivate GeeConcurrentListPrivate;

#define GEE_CONCURRENT_LIST_TYPE_NODE (gee_concurrent_list_node_get_type ())
#define GEE_CONCURRENT_LIST_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_CONCURRENT_LIST_TYPE_NODE, GeeConcurrentListNode))
#define GEE_CONCURRENT_LIST_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_CONCURRENT_LIST_TYPE_NODE, GeeConcurrentListNodeClass))
#define GEE_CONCURRENT_LIST_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_CONCURRENT_LIST_TYPE_NODE))
#define GEE_CONCURRENT_LIST_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_CONCURRENT_LIST_TYPE_NODE))
#define GEE_CONCURRENT_LIST_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_CONCURRENT_LIST_TYPE_NODE, GeeConcurrentListNodeClass))

typedef struct _GeeConcurrentListNode GeeConcurrentListNode;
typedef struct _GeeConcurrentListNodeClass GeeConcurrentListNodeClass;
typedef struct _GeeHazardPointerContext GeeHazardPointerContext;

#define GEE_HAZARD_POINTER_TYPE_POLICY (gee_hazard_pointer_policy_get_type ())
#define _gee_concurrent_list_node_unref0(var) ((var == NULL) ? NULL : (var = (gee_concurrent_list_node_unref (var), NULL)))
#define _gee_hazard_pointer_context_free0(var) ((var == NULL) ? NULL : (var = (gee_hazard_pointer_context_free (var), NULL)))

#define GEE_CONCURRENT_LIST_TYPE_STATE (gee_concurrent_list_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_CONCURRENT_LIST_TYPE_ITERATOR (gee_concurrent_list_iterator_get_type ())
#define GEE_CONCURRENT_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_CONCURRENT_LIST_TYPE_ITERATOR, GeeConcurrentListIterator))
#define GEE_CONCURRENT_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_CONCURRENT_LIST_TYPE_ITERATOR, GeeConcurrentListIteratorClass))
#define GEE_CONCURRENT_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_CONCURRENT_LIST_TYPE_ITERATOR))
#define GEE_CONCURRENT_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_CONCURRENT_LIST_TYPE_ITERATOR))
#define GEE_CONCURRENT_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_CONCURRENT_LIST_TYPE_ITERATOR, GeeConcurrentListIteratorClass))

typedef struct _GeeConcurrentListIterator GeeConcurrentListIterator;
typedef struct _GeeConcurrentListIteratorClass GeeConcurrentListIteratorClass;
typedef struct _GeeConcurrentListIteratorPrivate GeeConcurrentListIteratorPrivate;
typedef struct _GeeConcurrentListNodePrivate GeeConcurrentListNodePrivate;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeConcurrentListParamSpecNode GeeConcurrentListParamSpecNode;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeList* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeList* self);
	GDestroyNotify (*get_g_destroy_func) (GeeList* self);
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	void (*reserved0) (GeeAbstractList* self);
	void (*reserved1) (GeeAbstractList* self);
	void (*reserved2) (GeeAbstractList* self);
	void (*reserved3) (GeeAbstractList* self);
	void (*reserved4) (GeeAbstractList* self);
	void (*reserved5) (GeeAbstractList* self);
	void (*reserved6) (GeeAbstractList* self);
	void (*reserved7) (GeeAbstractList* self);
	void (*reserved8) (GeeAbstractList* self);
	void (*reserved9) (GeeAbstractList* self);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeConcurrentList {
	GeeAbstractList parent_instance;
	GeeConcurrentListPrivate * priv;
};

struct _GeeConcurrentListClass {
	GeeAbstractListClass parent_class;
};

typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
struct _GeeConcurrentListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeEqualDataFunc _equal_func;
	gpointer _equal_func_target;
	GDestroyNotify _equal_func_target_destroy_notify;
	GeeConcurrentListNode* _head;
	GeeConcurrentListNode* _tail;
};

typedef enum  {
	GEE_HAZARD_POINTER_POLICY_DEFAULT,
	GEE_HAZARD_POINTER_POLICY_THREAD_EXIT,
	GEE_HAZARD_POINTER_POLICY_TRY_FREE,
	GEE_HAZARD_POINTER_POLICY_FREE,
	GEE_HAZARD_POINTER_POLICY_TRY_RELEASE,
	GEE_HAZARD_POINTER_POLICY_RELEASE
} GeeHazardPointerPolicy;

typedef enum  {
	GEE_CONCURRENT_LIST_STATE_NONE = 0,
	GEE_CONCURRENT_LIST_STATE_MARKED = 1,
	GEE_CONCURRENT_LIST_STATE_FLAGGED = 2
} GeeConcurrentListState;

struct _GeeConcurrentListIterator {
	GObject parent_instance;
	GeeConcurrentListIteratorPrivate * priv;
};

struct _GeeConcurrentListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeConcurrentListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gboolean _removed;
	gint _index;
	GeeConcurrentListNode* _prev;
	GeeConcurrentListNode* _curr;
};

struct _GeeConcurrentListNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeConcurrentListNodePrivate * priv;
	GeeConcurrentListNode* _succ;
	GeeConcurrentListNode* _backlink;
	gconstpointer* _data;
};

struct _GeeConcurrentListNodeClass {
	GTypeClass parent_class;
	void (*finalize) (GeeConcurrentListNode *self);
};

struct _GeeConcurrentListNodePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeConcurrentListParamSpecNode {
	GParamSpec parent_instance;
};


static gpointer gee_concurrent_list_parent_class = NULL;
static gpointer gee_concurrent_list_iterator_parent_class = NULL;
static GeeTraversableIface* gee_concurrent_list_iterator_gee_traversable_parent_iface = NULL;
static GeeIteratorIface* gee_concurrent_list_iterator_gee_iterator_parent_iface = NULL;
static GeeListIteratorIface* gee_concurrent_list_iterator_gee_list_iterator_parent_iface = NULL;
static gpointer gee_concurrent_list_node_parent_class = NULL;

GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_concurrent_list_get_type (void) G_GNUC_CONST;
static gpointer gee_concurrent_list_node_ref (gpointer instance);
static void gee_concurrent_list_node_unref (gpointer instance);
static GParamSpec* gee_concurrent_list_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void gee_concurrent_list_value_set_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void gee_concurrent_list_value_take_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer gee_concurrent_list_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType gee_concurrent_list_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define GEE_CONCURRENT_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_CONCURRENT_LIST, GeeConcurrentListPrivate))
enum  {
	GEE_CONCURRENT_LIST_DUMMY_PROPERTY,
	GEE_CONCURRENT_LIST_G_TYPE,
	GEE_CONCURRENT_LIST_G_DUP_FUNC,
	GEE_CONCURRENT_LIST_G_DESTROY_FUNC,
	GEE_CONCURRENT_LIST_READ_ONLY,
	GEE_CONCURRENT_LIST_SIZE,
	GEE_CONCURRENT_LIST_IS_EMPTY
};
void gee_hazard_pointer_context_free (GeeHazardPointerContext* self);
GType gee_hazard_pointer_policy_get_type (void) G_GNUC_CONST;
GeeHazardPointerContext* gee_hazard_pointer_context_new (GeeHazardPointerPolicy* policy);
GeeHazardPointerContext* gee_hazard_pointer_context_new (GeeHazardPointerPolicy* policy);
void gee_hazard_pointer_set_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gpointer new_ptr, gsize mask, gsize new_mask);
static GType gee_concurrent_list_state_get_type (void) G_GNUC_UNUSED;
GeeConcurrentList* gee_concurrent_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeConcurrentList* gee_concurrent_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeAbstractList* gee_abstract_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeEqualDataFunc gee_functions_get_equal_func_for (GType t, void** result_target, GDestroyNotify* result_target_destroy_notify);
static void gee_concurrent_list_set_equal_func (GeeConcurrentList* self, GeeEqualDataFunc value, gpointer value_target);
static GeeConcurrentListNode* gee_concurrent_list_node_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static GeeConcurrentListNode* gee_concurrent_list_node_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static gboolean gee_concurrent_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
GeeIterator* gee_abstract_collection_iterator (GeeAbstractCollection* self);
gboolean gee_iterator_next (GeeIterator* self);
GeeEqualDataFunc gee_concurrent_list_get_equal_func (GeeConcurrentList* self, gpointer* result_target);
gpointer gee_iterator_get (GeeIterator* self);
static gboolean gee_concurrent_list_real_add (GeeAbstractCollection* base, gconstpointer item);
static GeeConcurrentListNode* gee_concurrent_list_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static GeeConcurrentListNode* gee_concurrent_list_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data);
static inline void gee_concurrent_list_node_insert (GeeConcurrentListNode* self, GeeConcurrentListNode* prev, GeeConcurrentListNode* next);
static inline GeeConcurrentListNode* gee_concurrent_list_get_tail (GeeConcurrentList* self);
static gboolean gee_concurrent_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
void gee_iterator_remove (GeeIterator* self);
static void gee_concurrent_list_real_clear (GeeAbstractCollection* base);
static GeeIterator* gee_concurrent_list_real_iterator (GeeAbstractCollection* base);
static GeeConcurrentListIterator* gee_concurrent_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode* head);
static GeeConcurrentListIterator* gee_concurrent_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode* head);
static GType gee_concurrent_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeListIterator* gee_concurrent_list_real_list_iterator (GeeAbstractList* base);
static gpointer gee_concurrent_list_real_get (GeeAbstractList* base, gint index);
static void gee_concurrent_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
GeeListIterator* gee_abstract_list_list_iterator (GeeAbstractList* self);
void gee_list_iterator_set (GeeListIterator* self, gconstpointer item);
static gint gee_concurrent_list_real_index_of (GeeAbstractList* base, gconstpointer item);
static void gee_concurrent_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
static inline GeeConcurrentListNode* gee_concurrent_list_node_get_next (GeeConcurrentListNode* self);
void gee_list_iterator_add (GeeListIterator* self, gconstpointer item);
static gpointer gee_concurrent_list_real_remove_at (GeeAbstractList* base, gint index);
static GeeList* gee_concurrent_list_real_slice (GeeAbstractList* base, gint start, gint end);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
static inline GeeConcurrentListNode* gee_concurrent_list_update_tail (GeeConcurrentList* self);
gpointer gee_hazard_pointer_get_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gsize mask, gsize* mask_out);
static inline void gee_concurrent_list_node_backtrace (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode** curr);
static inline gboolean gee_concurrent_list_node_search_for (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode* goal, GeeConcurrentListNode** prev);
gboolean gee_concurrent_list_get_is_empty (GeeConcurrentList* self);
#define GEE_CONCURRENT_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_CONCURRENT_LIST_TYPE_ITERATOR, GeeConcurrentListIteratorPrivate))
enum  {
	GEE_CONCURRENT_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_CONCURRENT_LIST_ITERATOR_G_TYPE,
	GEE_CONCURRENT_LIST_ITERATOR_G_DUP_FUNC,
	GEE_CONCURRENT_LIST_ITERATOR_G_DESTROY_FUNC,
	GEE_CONCURRENT_LIST_ITERATOR_VALID,
	GEE_CONCURRENT_LIST_ITERATOR_READ_ONLY
};
static gboolean gee_concurrent_list_iterator_real_next (GeeIterator* base);
static inline gboolean gee_concurrent_list_node_proceed (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode** prev, GeeConcurrentListNode** curr, gboolean force);
static gboolean gee_concurrent_list_iterator_real_has_next (GeeIterator* base);
static gpointer gee_concurrent_list_iterator_real_get (GeeIterator* base);
gboolean gee_iterator_get_valid (GeeIterator* self);
static void gee_concurrent_list_iterator_real_set (GeeListIterator* base, gconstpointer item);
static void gee_concurrent_list_iterator_real_remove (GeeIterator* base);
static inline gboolean gee_concurrent_list_node_remove (GeeConcurrentListNode* self, GeeConcurrentListNode* prev_node);
static gint gee_concurrent_list_iterator_real_index (GeeListIterator* base);
static void gee_concurrent_list_iterator_real_add (GeeListIterator* base, gconstpointer item);
static gboolean gee_concurrent_list_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target);
static void gee_concurrent_list_iterator_finalize (GObject* obj);
gboolean gee_iterator_get_read_only (GeeIterator* self);
static void _vala_gee_concurrent_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_concurrent_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define GEE_CONCURRENT_LIST_NODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_CONCURRENT_LIST_TYPE_NODE, GeeConcurrentListNodePrivate))
enum  {
	GEE_CONCURRENT_LIST_NODE_DUMMY_PROPERTY
};
static inline GeeConcurrentListState gee_concurrent_list_node_get_state (GeeConcurrentListNode* self);
static inline GeeConcurrentListNode* gee_concurrent_list_node_get_succ (GeeConcurrentListNode* self, GeeConcurrentListState* state);
static inline void gee_concurrent_list_node_help_marked (GeeConcurrentListNode* self, GeeConcurrentListNode* prev_node);
static inline gboolean gee_concurrent_list_node_try_flag (GeeConcurrentListNode* self, GeeConcurrentListNode** prev_node);
static inline void gee_concurrent_list_node_help_flagged (GeeConcurrentListNode* self, GeeConcurrentListNode* prev);
static inline void gee_concurrent_list_node_set_succ (GeeConcurrentListNode* self, GeeConcurrentListNode* next, GeeConcurrentListState state);
static inline gboolean gee_concurrent_list_node_compare_and_exchange (GeeConcurrentListNode* self, GeeConcurrentListNode* old_node, GeeConcurrentListState old_state, GeeConcurrentListNode* new_node, GeeConcurrentListState new_state);
static inline void gee_concurrent_list_node_set_backlink (GeeConcurrentListNode* self, GeeConcurrentListNode* backlink);
static inline void gee_concurrent_list_node_try_mark (GeeConcurrentListNode* self);
static inline gboolean gee_concurrent_list_node_compare_succ (GeeConcurrentListNode* self, GeeConcurrentListNode* next, GeeConcurrentListState state);
static inline GeeConcurrentListNode* gee_concurrent_list_node_get_backlink (GeeConcurrentListNode* self);
gboolean gee_hazard_pointer_compare_and_exchange_pointer (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer** aptr, gconstpointer old_ptr, gpointer _new_ptr, gsize mask, gsize old_mask, gsize new_mask);
static void gee_concurrent_list_node_finalize (GeeConcurrentListNode* obj);
static void gee_concurrent_list_finalize (GObject* obj);
gboolean gee_abstract_collection_get_read_only (GeeAbstractCollection* self);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static void _vala_gee_concurrent_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_concurrent_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static GType gee_concurrent_list_state_get_type (void) {
	static volatile gsize gee_concurrent_list_state_type_id__volatile = 0;
	if (g_once_init_enter (&gee_concurrent_list_state_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_CONCURRENT_LIST_STATE_NONE, "GEE_CONCURRENT_LIST_STATE_NONE", "none"}, {GEE_CONCURRENT_LIST_STATE_MARKED, "GEE_CONCURRENT_LIST_STATE_MARKED", "marked"}, {GEE_CONCURRENT_LIST_STATE_FLAGGED, "GEE_CONCURRENT_LIST_STATE_FLAGGED", "flagged"}, {0, NULL, NULL}};
		GType gee_concurrent_list_state_type_id;
		gee_concurrent_list_state_type_id = g_enum_register_static ("GeeConcurrentListState", values);
		g_once_init_leave (&gee_concurrent_list_state_type_id__volatile, gee_concurrent_list_state_type_id);
	}
	return gee_concurrent_list_state_type_id__volatile;
}


/**
 * Construct new, empty single linked list
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
static gpointer _gee_concurrent_list_node_ref0 (gpointer self) {
	return self ? gee_concurrent_list_node_ref (self) : NULL;
}


GeeConcurrentList* gee_concurrent_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	GeeConcurrentList * self = NULL;
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	GDestroyNotify _tmp4__target_destroy_notify = NULL;
	GeeEqualDataFunc _tmp5_ = NULL;
	void* _tmp5__target = NULL;
	GDestroyNotify _tmp5__target_destroy_notify = NULL;
	GeeConcurrentListNode* _tmp6_ = NULL;
	GeeConcurrentListNode* _tmp7_ = NULL;
	GeeConcurrentListNode* _tmp8_ = NULL;
	self = (GeeConcurrentList*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = equal_func;
	_tmp0__target = equal_func_target;
	if (_tmp0_ == NULL) {
		void* _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeEqualDataFunc _tmp3_ = NULL;
		_tmp3_ = gee_functions_get_equal_func_for (g_type, &_tmp1_, &_tmp2_);
		(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		equal_func = _tmp3_;
		equal_func_target = _tmp1_;
		equal_func_target_destroy_notify = _tmp2_;
	}
	_tmp4_ = equal_func;
	_tmp4__target = equal_func_target;
	_tmp4__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func_target_destroy_notify = NULL;
	_tmp5_ = _tmp4_;
	_tmp5__target = _tmp4__target;
	_tmp5__target_destroy_notify = _tmp4__target_destroy_notify;
	gee_concurrent_list_set_equal_func (self, _tmp5_, _tmp4__target);
	(_tmp5__target_destroy_notify == NULL) ? NULL : (_tmp5__target_destroy_notify (_tmp5__target), NULL);
	_tmp5_ = NULL;
	_tmp5__target = NULL;
	_tmp5__target_destroy_notify = NULL;
	_tmp6_ = gee_concurrent_list_node_new_head (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	_gee_concurrent_list_node_unref0 (self->priv->_head);
	self->priv->_head = _tmp6_;
	_tmp7_ = self->priv->_head;
	_tmp8_ = _gee_concurrent_list_node_ref0 (_tmp7_);
	gee_hazard_pointer_set_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->priv->_tail, _tmp8_, (gsize) 0, (gsize) 0);
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}


GeeConcurrentList* gee_concurrent_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify) {
	return gee_concurrent_list_construct (GEE_TYPE_CONCURRENT_LIST, g_type, g_dup_func, g_destroy_func, equal_func, equal_func_target, equal_func_target_destroy_notify);
}


/**
 * {@inheritDoc}
 */
static gboolean gee_concurrent_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeConcurrentList * self;
	gboolean result = FALSE;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	{
		GeeIterator* iter = NULL;
		GeeIterator* _tmp1_ = NULL;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
		iter = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				GeeIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				GeeEqualDataFunc _tmp6_ = NULL;
				void* _tmp6__target = NULL;
				GeeEqualDataFunc _tmp7_ = NULL;
				void* _tmp7__target = NULL;
				gconstpointer _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				gpointer _tmp10_ = NULL;
				gpointer _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
				}
				_tmp2_ = FALSE;
				_tmp4_ = iter;
				_tmp5_ = gee_iterator_next (_tmp4_);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = gee_concurrent_list_get_equal_func (self, &_tmp6__target);
				_tmp7_ = _tmp6_;
				_tmp7__target = _tmp6__target;
				_tmp8_ = item;
				_tmp9_ = iter;
				_tmp10_ = gee_iterator_get (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp7_ (_tmp8_, _tmp11_, _tmp7__target);
				_tmp13_ = _tmp12_;
				((_tmp11_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp11_ = (self->priv->g_destroy_func (_tmp11_), NULL));
				if (_tmp13_) {
					result = TRUE;
					_g_object_unref0 (iter);
					_gee_hazard_pointer_context_free0 (ctx);
					return result;
				}
			}
		}
		_g_object_unref0 (iter);
	}
	result = FALSE;
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_concurrent_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeConcurrentList * self;
	gboolean result = FALSE;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	GeeConcurrentListNode* node = NULL;
	gconstpointer _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp2_ = NULL;
	GeeConcurrentListNode* _tmp3_ = NULL;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = gee_concurrent_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp1_);
	node = _tmp2_;
	_tmp3_ = gee_concurrent_list_get_tail (self);
	gee_concurrent_list_node_insert (node, _tmp3_, NULL);
	result = TRUE;
	_gee_concurrent_list_node_unref0 (node);
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


/**
 * {@inheritDoc}
 */
static gboolean gee_concurrent_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeConcurrentList * self;
	gboolean result = FALSE;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	GeeIterator* iter = NULL;
	GeeIterator* _tmp1_ = NULL;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeEqualDataFunc _tmp4_ = NULL;
		void* _tmp4__target = NULL;
		GeeEqualDataFunc _tmp5_ = NULL;
		void* _tmp5__target = NULL;
		gconstpointer _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		gpointer _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = gee_concurrent_list_get_equal_func (self, &_tmp4__target);
		_tmp5_ = _tmp4_;
		_tmp5__target = _tmp4__target;
		_tmp6_ = item;
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp5_ (_tmp6_, _tmp9_, _tmp5__target);
		_tmp11_ = _tmp10_;
		((_tmp9_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp9_ = (self->priv->g_destroy_func (_tmp9_), NULL));
		if (_tmp11_) {
			GeeIterator* _tmp12_ = NULL;
			_tmp12_ = iter;
			gee_iterator_remove (_tmp12_);
			result = TRUE;
			_g_object_unref0 (iter);
			_gee_hazard_pointer_context_free0 (ctx);
			return result;
		}
	}
	result = FALSE;
	_g_object_unref0 (iter);
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_concurrent_list_real_clear (GeeAbstractCollection* base) {
	GeeConcurrentList * self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	GeeIterator* iter = NULL;
	GeeIterator* _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp5_ = NULL;
	GeeConcurrentListNode* _tmp6_ = NULL;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeIterator* _tmp4_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		gee_iterator_remove (_tmp4_);
	}
	_tmp5_ = self->priv->_head;
	_tmp6_ = _gee_concurrent_list_node_ref0 (_tmp5_);
	gee_hazard_pointer_set_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->priv->_tail, _tmp6_, (gsize) 0, (gsize) 0);
	_g_object_unref0 (iter);
	_gee_hazard_pointer_context_free0 (ctx);
}


/**
 * {@inheritDoc}
 */
static GeeIterator* gee_concurrent_list_real_iterator (GeeAbstractCollection* base) {
	GeeConcurrentList * self;
	GeeIterator* result = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListIterator* _tmp1_ = NULL;
	self = (GeeConcurrentList*) base;
	_tmp0_ = self->priv->_head;
	_tmp1_ = gee_concurrent_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp0_);
	result = (GeeIterator*) _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static GeeListIterator* gee_concurrent_list_real_list_iterator (GeeAbstractList* base) {
	GeeConcurrentList * self;
	GeeListIterator* result = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListIterator* _tmp1_ = NULL;
	self = (GeeConcurrentList*) base;
	_tmp0_ = self->priv->_head;
	_tmp1_ = gee_concurrent_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp0_);
	result = (GeeListIterator*) _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static gpointer gee_concurrent_list_real_get (GeeAbstractList* base, gint index) {
	GeeConcurrentList * self;
	gpointer result = NULL;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = index;
	_vala_assert (_tmp1_ >= 0, "index >= 0");
	{
		GeeIterator* iterator = NULL;
		GeeIterator* _tmp2_ = NULL;
		_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
		iterator = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GeeIterator* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				gint _tmp7_ = 0;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
				}
				_tmp3_ = FALSE;
				_tmp5_ = iterator;
				_tmp6_ = gee_iterator_next (_tmp5_);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = index;
				index = _tmp7_ - 1;
				if (_tmp7_ == 0) {
					GeeIterator* _tmp8_ = NULL;
					gpointer _tmp9_ = NULL;
					_tmp8_ = iterator;
					_tmp9_ = gee_iterator_get (_tmp8_);
					result = _tmp9_;
					_g_object_unref0 (iterator);
					_gee_hazard_pointer_context_free0 (ctx);
					return result;
				}
			}
		}
		_g_object_unref0 (iterator);
	}
	g_assert_not_reached ();
	_gee_hazard_pointer_context_free0 (ctx);
}


/**
 * {@inheritDoc}
 */
static void gee_concurrent_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeConcurrentList * self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = index;
	_vala_assert (_tmp1_ >= 0, "index >= 0");
	{
		GeeListIterator* iterator = NULL;
		GeeListIterator* _tmp2_ = NULL;
		_tmp2_ = gee_abstract_list_list_iterator ((GeeAbstractList*) self);
		iterator = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GeeListIterator* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				gint _tmp7_ = 0;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
				}
				_tmp3_ = FALSE;
				_tmp5_ = iterator;
				_tmp6_ = gee_iterator_next ((GeeIterator*) _tmp5_);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = index;
				index = _tmp7_ - 1;
				if (_tmp7_ == 0) {
					GeeListIterator* _tmp8_ = NULL;
					gconstpointer _tmp9_ = NULL;
					_tmp8_ = iterator;
					_tmp9_ = item;
					gee_list_iterator_set (_tmp8_, _tmp9_);
					_g_object_unref0 (iterator);
					_gee_hazard_pointer_context_free0 (ctx);
					return;
				}
			}
		}
		_g_object_unref0 (iterator);
	}
	g_assert_not_reached ();
	_gee_hazard_pointer_context_free0 (ctx);
}


/**
 * {@inheritDoc}
 */
static gint gee_concurrent_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
	GeeConcurrentList * self;
	gint result = 0;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gint index = 0;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	index = 0;
	{
		GeeListIterator* iterator = NULL;
		GeeListIterator* _tmp1_ = NULL;
		_tmp1_ = gee_abstract_list_list_iterator ((GeeAbstractList*) self);
		iterator = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				GeeListIterator* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				GeeEqualDataFunc _tmp7_ = NULL;
				void* _tmp7__target = NULL;
				GeeEqualDataFunc _tmp8_ = NULL;
				void* _tmp8__target = NULL;
				gconstpointer _tmp9_ = NULL;
				GeeListIterator* _tmp10_ = NULL;
				gpointer _tmp11_ = NULL;
				gpointer _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = index;
					index = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = iterator;
				_tmp6_ = gee_iterator_next ((GeeIterator*) _tmp5_);
				if (!_tmp6_) {
					break;
				}
				_tmp7_ = gee_concurrent_list_get_equal_func (self, &_tmp7__target);
				_tmp8_ = _tmp7_;
				_tmp8__target = _tmp7__target;
				_tmp9_ = item;
				_tmp10_ = iterator;
				_tmp11_ = gee_iterator_get ((GeeIterator*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp8_ (_tmp9_, _tmp12_, _tmp8__target);
				_tmp14_ = _tmp13_;
				((_tmp12_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp12_ = (self->priv->g_destroy_func (_tmp12_), NULL));
				if (_tmp14_) {
					result = index;
					_g_object_unref0 (iterator);
					_gee_hazard_pointer_context_free0 (ctx);
					return result;
				}
			}
		}
		_g_object_unref0 (iterator);
	}
	result = -1;
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


/**
 * {@inheritDoc}
 */
static void gee_concurrent_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
	GeeConcurrentList * self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = index;
	_vala_assert (_tmp1_ >= 0, "index >= 0");
	_tmp2_ = index;
	if (_tmp2_ == 0) {
		GeeConcurrentListNode* prev = NULL;
		GeeConcurrentListNode* _tmp3_ = NULL;
		GeeConcurrentListNode* _tmp4_ = NULL;
		GeeConcurrentListNode* next = NULL;
		GeeConcurrentListNode* _tmp5_ = NULL;
		GeeConcurrentListNode* _tmp6_ = NULL;
		GeeConcurrentListNode* new_node = NULL;
		gconstpointer _tmp7_ = NULL;
		GeeConcurrentListNode* _tmp8_ = NULL;
		GeeConcurrentListNode* _tmp9_ = NULL;
		GeeConcurrentListNode* _tmp10_ = NULL;
		GeeConcurrentListNode* _tmp11_ = NULL;
		GeeConcurrentListNode* _tmp12_ = NULL;
		_tmp3_ = self->priv->_head;
		_tmp4_ = _gee_concurrent_list_node_ref0 (_tmp3_);
		prev = _tmp4_;
		_tmp5_ = self->priv->_head;
		_tmp6_ = gee_concurrent_list_node_get_next (_tmp5_);
		next = _tmp6_;
		_tmp7_ = item;
		_tmp8_ = gee_concurrent_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp7_);
		new_node = _tmp8_;
		_tmp9_ = new_node;
		_tmp10_ = prev;
		_tmp11_ = _gee_concurrent_list_node_ref0 (_tmp10_);
		_tmp12_ = next;
		gee_concurrent_list_node_insert (_tmp9_, _tmp11_, _tmp12_);
		_gee_concurrent_list_node_unref0 (new_node);
		_gee_concurrent_list_node_unref0 (next);
		_gee_concurrent_list_node_unref0 (prev);
	} else {
		{
			GeeListIterator* iterator = NULL;
			GeeListIterator* _tmp13_ = NULL;
			_tmp13_ = gee_abstract_list_list_iterator ((GeeAbstractList*) self);
			iterator = _tmp13_;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					gboolean _tmp15_ = FALSE;
					GeeListIterator* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					_tmp15_ = _tmp14_;
					if (!_tmp15_) {
					}
					_tmp14_ = FALSE;
					_tmp16_ = iterator;
					_tmp17_ = gee_iterator_next ((GeeIterator*) _tmp16_);
					if (!_tmp17_) {
						break;
					}
					_tmp18_ = index;
					index = _tmp18_ - 1;
					_tmp19_ = index;
					if (_tmp19_ == 0) {
						GeeListIterator* _tmp20_ = NULL;
						gconstpointer _tmp21_ = NULL;
						_tmp20_ = iterator;
						_tmp21_ = item;
						gee_list_iterator_add (_tmp20_, _tmp21_);
						_g_object_unref0 (iterator);
						_gee_hazard_pointer_context_free0 (ctx);
						return;
					}
				}
			}
			_g_object_unref0 (iterator);
		}
		g_assert_not_reached ();
	}
	_gee_hazard_pointer_context_free0 (ctx);
}


/**
 * {@inheritDoc}
 */
static gpointer gee_concurrent_list_real_remove_at (GeeAbstractList* base, gint index) {
	GeeConcurrentList * self;
	gpointer result = NULL;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	{
		GeeListIterator* iterator = NULL;
		GeeListIterator* _tmp1_ = NULL;
		_tmp1_ = gee_abstract_list_list_iterator ((GeeAbstractList*) self);
		iterator = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				GeeListIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gint _tmp6_ = 0;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
				}
				_tmp2_ = FALSE;
				_tmp4_ = iterator;
				_tmp5_ = gee_iterator_next ((GeeIterator*) _tmp4_);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = index;
				index = _tmp6_ - 1;
				if (_tmp6_ == 0) {
					gpointer data = NULL;
					GeeListIterator* _tmp7_ = NULL;
					gpointer _tmp8_ = NULL;
					GeeListIterator* _tmp9_ = NULL;
					_tmp7_ = iterator;
					_tmp8_ = gee_iterator_get ((GeeIterator*) _tmp7_);
					data = _tmp8_;
					_tmp9_ = iterator;
					gee_iterator_remove ((GeeIterator*) _tmp9_);
					result = data;
					_g_object_unref0 (iterator);
					_gee_hazard_pointer_context_free0 (ctx);
					return result;
				}
			}
		}
		_g_object_unref0 (iterator);
	}
	g_assert_not_reached ();
	_gee_hazard_pointer_context_free0 (ctx);
}


/**
 * {@inheritDoc}
 */
static GeeList* gee_concurrent_list_real_slice (GeeAbstractList* base, gint start, gint end) {
	GeeConcurrentList * self;
	GeeList* result = NULL;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeConcurrentList* list = NULL;
	GeeEqualDataFunc _tmp4_ = NULL;
	void* _tmp4__target = NULL;
	GeeEqualDataFunc _tmp5_ = NULL;
	void* _tmp5__target = NULL;
	GeeConcurrentList* _tmp6_ = NULL;
	GeeIterator* iterator = NULL;
	GeeIterator* _tmp7_ = NULL;
	gint idx = 0;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = start;
	_vala_assert (0 <= _tmp1_, "0 <= start");
	_tmp2_ = start;
	_tmp3_ = end;
	_vala_assert (_tmp2_ <= _tmp3_, "start <= end");
	_tmp4_ = gee_concurrent_list_get_equal_func (self, &_tmp4__target);
	_tmp5_ = _tmp4_;
	_tmp5__target = _tmp4__target;
	_tmp6_ = gee_concurrent_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp5_, _tmp5__target, NULL);
	list = _tmp6_;
	_tmp7_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	iterator = _tmp7_;
	idx = 0;
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp11_ = NULL;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gboolean _tmp18_ = FALSE;
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				gint _tmp10_ = 0;
				_tmp10_ = idx;
				idx = _tmp10_ + 1;
			}
			_tmp8_ = FALSE;
			_tmp11_ = iterator;
			_tmp12_ = gee_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp14_ = idx;
			_tmp15_ = start;
			if (_tmp14_ >= _tmp15_) {
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				_tmp16_ = idx;
				_tmp17_ = end;
				_tmp13_ = _tmp16_ < _tmp17_;
			} else {
				_tmp13_ = FALSE;
			}
			_tmp18_ = _tmp13_;
			if (_tmp18_) {
				GeeConcurrentList* _tmp19_ = NULL;
				GeeIterator* _tmp20_ = NULL;
				gpointer _tmp21_ = NULL;
				gpointer _tmp22_ = NULL;
				_tmp19_ = list;
				_tmp20_ = iterator;
				_tmp21_ = gee_iterator_get (_tmp20_);
				_tmp22_ = _tmp21_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp22_);
				((_tmp22_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp22_ = (self->priv->g_destroy_func (_tmp22_), NULL));
			} else {
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				_tmp23_ = idx;
				_tmp24_ = end;
				if (_tmp23_ >= _tmp24_) {
					break;
				}
			}
		}
	}
	_tmp25_ = idx;
	_tmp26_ = end;
	_vala_assert (_tmp25_ >= _tmp26_, "idx >= end");
	result = (GeeList*) list;
	_g_object_unref0 (iterator);
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


static inline GeeConcurrentListNode* gee_concurrent_list_update_tail (GeeConcurrentList* self) {
	GeeConcurrentListNode* result = NULL;
	GeeConcurrentListNode* tail = NULL;
	gpointer _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hazard_pointer_get_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->priv->_tail, (gsize) 0, NULL);
	tail = (GeeConcurrentListNode*) _tmp0_;
	gee_concurrent_list_node_backtrace (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &tail);
	gee_concurrent_list_node_search_for (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, NULL, &tail);
	_tmp1_ = tail;
	_tmp2_ = _gee_concurrent_list_node_ref0 (_tmp1_);
	gee_hazard_pointer_set_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->priv->_tail, _tmp2_, (gsize) 0, (gsize) 0);
	result = tail;
	return result;
}


static inline GeeConcurrentListNode* gee_concurrent_list_get_tail (GeeConcurrentList* self) {
	GeeConcurrentListNode* result = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_concurrent_list_update_tail (self);
	result = _tmp0_;
	return result;
}


GeeEqualDataFunc gee_concurrent_list_get_equal_func (GeeConcurrentList* self, gpointer* result_target) {
	GeeEqualDataFunc result;
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GeeEqualDataFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equal_func;
	_tmp0__target = self->priv->_equal_func_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


static void gee_concurrent_list_set_equal_func (GeeConcurrentList* self, GeeEqualDataFunc value, gpointer value_target) {
	GeeEqualDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__target = value_target;
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	self->priv->_equal_func = _tmp0_;
	self->priv->_equal_func_target = _tmp0__target;
	self->priv->_equal_func_target_destroy_notify = NULL;
}


static gboolean gee_concurrent_list_real_get_read_only (GeeAbstractCollection* base) {
	gboolean result;
	GeeConcurrentList* self;
	self = (GeeConcurrentList*) base;
	result = FALSE;
	return result;
}


static gint gee_concurrent_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeConcurrentList* self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gint _result_ = 0;
	gint _tmp7_ = 0;
	self = (GeeConcurrentList*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_result_ = 0;
	{
		GeeIterator* iter = NULL;
		GeeIterator* _tmp1_ = NULL;
		_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
		iter = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				GeeIterator* _tmp4_ = NULL;
				gboolean _tmp5_ = FALSE;
				gint _tmp6_ = 0;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
				}
				_tmp2_ = FALSE;
				_tmp4_ = iter;
				_tmp5_ = gee_iterator_next (_tmp4_);
				if (!_tmp5_) {
					break;
				}
				_tmp6_ = _result_;
				_result_ = _tmp6_ + 1;
			}
		}
		_g_object_unref0 (iter);
	}
	_tmp7_ = _result_;
	result = _tmp7_;
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


gboolean gee_concurrent_list_get_is_empty (GeeConcurrentList* self) {
	gboolean result;
	GeeIterator* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_iterator_next (_tmp1_);
	_tmp3_ = !_tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static GeeConcurrentListIterator* gee_concurrent_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode* head) {
	GeeConcurrentListIterator * self = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	g_return_val_if_fail (head != NULL, NULL);
	self = (GeeConcurrentListIterator*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->_removed = FALSE;
	self->priv->_index = -1;
	_gee_concurrent_list_node_unref0 (self->priv->_prev);
	self->priv->_prev = NULL;
	_tmp0_ = head;
	_tmp1_ = _gee_concurrent_list_node_ref0 (_tmp0_);
	_gee_concurrent_list_node_unref0 (self->priv->_curr);
	self->priv->_curr = _tmp1_;
	return self;
}


static GeeConcurrentListIterator* gee_concurrent_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode* head) {
	return gee_concurrent_list_iterator_construct (GEE_CONCURRENT_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, head);
}


static gboolean gee_concurrent_list_iterator_real_next (GeeIterator* base) {
	GeeConcurrentListIterator * self;
	gboolean result = FALSE;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GeeConcurrentListNode* _old_prev = NULL;
	GeeConcurrentListNode* _tmp4_ = NULL;
	GeeConcurrentListNode* _tmp5_ = NULL;
	gboolean success = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp2_ = self->priv->_removed;
	if (_tmp2_) {
		GeeConcurrentListNode* _tmp3_ = NULL;
		_tmp3_ = self->priv->_prev;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = NULL;
	}
	_tmp4_ = _tmp1_;
	_tmp5_ = _gee_concurrent_list_node_ref0 (_tmp4_);
	_old_prev = _tmp5_;
	_tmp6_ = gee_concurrent_list_node_proceed (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &self->priv->_prev, &self->priv->_curr, FALSE);
	success = _tmp6_;
	_tmp7_ = success;
	if (_tmp7_) {
		gboolean _tmp8_ = FALSE;
		gint _tmp10_ = 0;
		_tmp8_ = self->priv->_removed;
		if (_tmp8_) {
			GeeConcurrentListNode* _tmp9_ = NULL;
			_tmp9_ = _old_prev;
			_old_prev = NULL;
			_gee_concurrent_list_node_unref0 (self->priv->_prev);
			self->priv->_prev = _tmp9_;
		}
		self->priv->_removed = FALSE;
		_tmp10_ = self->priv->_index;
		self->priv->_index = _tmp10_ + 1;
	}
	result = success;
	_gee_concurrent_list_node_unref0 (_old_prev);
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


static gboolean gee_concurrent_list_iterator_real_has_next (GeeIterator* base) {
	GeeConcurrentListIterator * self;
	gboolean result = FALSE;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	GeeConcurrentListNode* prev = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp2_ = NULL;
	GeeConcurrentListNode* curr = NULL;
	GeeConcurrentListNode* _tmp3_ = NULL;
	GeeConcurrentListNode* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = self->priv->_prev;
	_tmp2_ = _gee_concurrent_list_node_ref0 (_tmp1_);
	prev = _tmp2_;
	_tmp3_ = self->priv->_curr;
	_tmp4_ = _gee_concurrent_list_node_ref0 (_tmp3_);
	curr = _tmp4_;
	_tmp5_ = gee_concurrent_list_node_proceed (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &prev, &curr, FALSE);
	result = _tmp5_;
	_gee_concurrent_list_node_unref0 (curr);
	_gee_concurrent_list_node_unref0 (prev);
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


static gpointer gee_concurrent_list_iterator_real_get (GeeIterator* base) {
	GeeConcurrentListIterator * self;
	gpointer result = NULL;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeConcurrentListNode* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = gee_iterator_get_valid ((GeeIterator*) self);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_, "valid");
	_tmp3_ = self->priv->_curr;
	_tmp4_ = gee_hazard_pointer_get_pointer (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &_tmp3_->_data, (gsize) 0, NULL);
	result = _tmp4_;
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


static void gee_concurrent_list_iterator_real_set (GeeListIterator* base, gconstpointer item) {
	GeeConcurrentListIterator * self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeConcurrentListNode* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = gee_iterator_get_valid ((GeeIterator*) self);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_, "valid");
	_tmp3_ = self->priv->_curr;
	_tmp4_ = item;
	_tmp5_ = ((_tmp4_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp4_) : ((gpointer) _tmp4_);
	gee_hazard_pointer_set_pointer (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &_tmp3_->_data, _tmp5_, (gsize) 0, (gsize) 0);
	_gee_hazard_pointer_context_free0 (ctx);
}


static void gee_concurrent_list_iterator_real_remove (GeeIterator* base) {
	GeeConcurrentListIterator * self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeConcurrentListNode* _tmp3_ = NULL;
	GeeConcurrentListNode* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = gee_iterator_get_valid ((GeeIterator*) self);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_, "valid");
	_tmp3_ = self->priv->_curr;
	_tmp4_ = self->priv->_prev;
	gee_concurrent_list_node_remove (_tmp3_, _tmp4_);
	self->priv->_removed = TRUE;
	_tmp5_ = self->priv->_index;
	self->priv->_index = _tmp5_ - 1;
	_gee_hazard_pointer_context_free0 (ctx);
}


static gint gee_concurrent_list_iterator_real_index (GeeListIterator* base) {
	GeeConcurrentListIterator * self;
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_iterator_get_valid ((GeeIterator*) self);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "valid");
	_tmp2_ = self->priv->_index;
	result = _tmp2_;
	return result;
}


static void gee_concurrent_list_iterator_real_add (GeeListIterator* base, gconstpointer item) {
	GeeConcurrentListIterator * self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GeeConcurrentListNode* new_node = NULL;
	gconstpointer _tmp5_ = NULL;
	GeeConcurrentListNode* _tmp6_ = NULL;
	GeeConcurrentListNode* _tmp7_ = NULL;
	GeeConcurrentListNode* _tmp8_ = NULL;
	GeeConcurrentListNode* _tmp9_ = NULL;
	GeeConcurrentListNode* _tmp10_ = NULL;
	GeeConcurrentListNode* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp1_ = gee_iterator_get_valid ((GeeIterator*) self);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_, "valid");
	_tmp3_ = gee_concurrent_list_node_proceed (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &self->priv->_prev, &self->priv->_curr, FALSE);
	if (!_tmp3_) {
		GeeConcurrentListNode* _tmp4_ = NULL;
		_tmp4_ = self->priv->_curr;
		self->priv->_curr = NULL;
		_gee_concurrent_list_node_unref0 (self->priv->_prev);
		self->priv->_prev = _tmp4_;
		_gee_concurrent_list_node_unref0 (self->priv->_curr);
		self->priv->_curr = NULL;
	}
	_tmp5_ = item;
	_tmp6_ = gee_concurrent_list_node_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp5_);
	new_node = _tmp6_;
	_tmp7_ = new_node;
	_tmp8_ = self->priv->_prev;
	_tmp9_ = _gee_concurrent_list_node_ref0 (_tmp8_);
	_tmp10_ = self->priv->_curr;
	gee_concurrent_list_node_insert (_tmp7_, _tmp9_, _tmp10_);
	_tmp11_ = new_node;
	new_node = NULL;
	_gee_concurrent_list_node_unref0 (self->priv->_curr);
	self->priv->_curr = _tmp11_;
	_tmp12_ = self->priv->_index;
	self->priv->_index = _tmp12_ + 1;
	_gee_concurrent_list_node_unref0 (new_node);
	_gee_hazard_pointer_context_free0 (ctx);
}


static gboolean gee_concurrent_list_iterator_real_foreach (GeeTraversable* base, GeeForallFunc f, void* f_target) {
	GeeConcurrentListIterator * self;
	gboolean result = FALSE;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeConcurrentListNode* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	GeeConcurrentListNode* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GeeConcurrentListNode* _old_prev = NULL;
	GeeConcurrentListNode* _tmp12_ = NULL;
	GeeConcurrentListNode* _tmp13_ = NULL;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_tmp2_ = self->priv->_prev;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->_removed;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		GeeForallFunc _tmp5_ = NULL;
		void* _tmp5__target = NULL;
		GeeConcurrentListNode* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = f;
		_tmp5__target = f_target;
		_tmp6_ = self->priv->_curr;
		_tmp7_ = gee_hazard_pointer_get_pointer (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &_tmp6_->_data, (gsize) 0, NULL);
		_tmp8_ = _tmp5_ (_tmp7_, _tmp5__target);
		if (!_tmp8_) {
			result = FALSE;
			_gee_hazard_pointer_context_free0 (ctx);
			return result;
		}
	}
	_tmp10_ = self->priv->_removed;
	if (_tmp10_) {
		GeeConcurrentListNode* _tmp11_ = NULL;
		_tmp11_ = self->priv->_prev;
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = NULL;
	}
	_tmp12_ = _tmp9_;
	_tmp13_ = _gee_concurrent_list_node_ref0 (_tmp12_);
	_old_prev = _tmp13_;
	while (TRUE) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gint _tmp17_ = 0;
		GeeForallFunc _tmp18_ = NULL;
		void* _tmp18__target = NULL;
		GeeConcurrentListNode* _tmp19_ = NULL;
		gpointer _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		_tmp14_ = gee_concurrent_list_node_proceed (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &self->priv->_prev, &self->priv->_curr, FALSE);
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = self->priv->_removed;
		if (_tmp15_) {
			GeeConcurrentListNode* _tmp16_ = NULL;
			_tmp16_ = _old_prev;
			_old_prev = NULL;
			_gee_concurrent_list_node_unref0 (self->priv->_prev);
			self->priv->_prev = _tmp16_;
		}
		self->priv->_removed = FALSE;
		_tmp17_ = self->priv->_index;
		self->priv->_index = _tmp17_ + 1;
		_tmp18_ = f;
		_tmp18__target = f_target;
		_tmp19_ = self->priv->_curr;
		_tmp20_ = gee_hazard_pointer_get_pointer (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &_tmp19_->_data, (gsize) 0, NULL);
		_tmp21_ = _tmp18_ (_tmp20_, _tmp18__target);
		if (!_tmp21_) {
			result = FALSE;
			_gee_concurrent_list_node_unref0 (_old_prev);
			_gee_hazard_pointer_context_free0 (ctx);
			return result;
		}
	}
	result = TRUE;
	_gee_concurrent_list_node_unref0 (_old_prev);
	_gee_hazard_pointer_context_free0 (ctx);
	return result;
}


static gboolean gee_concurrent_list_iterator_real_get_valid (GeeIterator* base) {
	gboolean result;
	GeeConcurrentListIterator* self;
	GeeConcurrentListNode* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GeeConcurrentListNode* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (GeeConcurrentListIterator*) base;
	_tmp0_ = self->priv->_curr;
	_vala_assert (_tmp0_ != NULL, "_curr != null");
	_tmp2_ = self->priv->_prev;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->_removed;
		_tmp1_ = !_tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	result = _tmp4_;
	return result;
}


static gboolean gee_concurrent_list_iterator_real_get_read_only (GeeIterator* base) {
	gboolean result;
	GeeConcurrentListIterator* self;
	self = (GeeConcurrentListIterator*) base;
	result = FALSE;
	return result;
}


static void gee_concurrent_list_iterator_class_init (GeeConcurrentListIteratorClass * klass) {
	gee_concurrent_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeConcurrentListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_concurrent_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_concurrent_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_concurrent_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_ITERATOR_VALID, g_param_spec_boolean ("valid", "valid", "valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_ITERATOR_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static GType gee_concurrent_list_iterator_gee_traversable_get_g_type (GeeConcurrentListIterator* self) {
	return self->priv->g_type;
}


static GBoxedCopyFunc gee_concurrent_list_iterator_gee_traversable_get_g_dup_func (GeeConcurrentListIterator* self) {
	return self->priv->g_dup_func;
}


static GDestroyNotify gee_concurrent_list_iterator_gee_traversable_get_g_destroy_func (GeeConcurrentListIterator* self) {
	return self->priv->g_destroy_func;
}


static void gee_concurrent_list_iterator_gee_traversable_interface_init (GeeTraversableIface * iface) {
	gee_concurrent_list_iterator_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*)(GeeTraversable*, GeeForallFunc, void*)) gee_concurrent_list_iterator_real_foreach;
	iface->get_g_type = (GType(*)(GeeTraversable*)) gee_concurrent_list_iterator_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc(*)(GeeTraversable*)) gee_concurrent_list_iterator_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify(*)(GeeTraversable*)) gee_concurrent_list_iterator_gee_traversable_get_g_destroy_func;
}


static void gee_concurrent_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_concurrent_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (gboolean (*)(GeeIterator*)) gee_concurrent_list_iterator_real_next;
	iface->has_next = (gboolean (*)(GeeIterator*)) gee_concurrent_list_iterator_real_has_next;
	iface->get = (gpointer (*)(GeeIterator*)) gee_concurrent_list_iterator_real_get;
	iface->remove = (void (*)(GeeIterator*)) gee_concurrent_list_iterator_real_remove;
	iface->get_valid = gee_concurrent_list_iterator_real_get_valid;
	iface->get_read_only = gee_concurrent_list_iterator_real_get_read_only;
}


static void gee_concurrent_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface) {
	gee_concurrent_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = (void (*)(GeeListIterator*, gconstpointer)) gee_concurrent_list_iterator_real_set;
	iface->index = (gint (*)(GeeListIterator*)) gee_concurrent_list_iterator_real_index;
	iface->add = (void (*)(GeeListIterator*, gconstpointer)) gee_concurrent_list_iterator_real_add;
}


static void gee_concurrent_list_iterator_instance_init (GeeConcurrentListIterator * self) {
	self->priv = GEE_CONCURRENT_LIST_ITERATOR_GET_PRIVATE (self);
}


static void gee_concurrent_list_iterator_finalize (GObject* obj) {
	GeeConcurrentListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_CONCURRENT_LIST_TYPE_ITERATOR, GeeConcurrentListIterator);
	_gee_concurrent_list_node_unref0 (self->priv->_prev);
	_gee_concurrent_list_node_unref0 (self->priv->_curr);
	G_OBJECT_CLASS (gee_concurrent_list_iterator_parent_class)->finalize (obj);
}


static GType gee_concurrent_list_iterator_get_type (void) {
	static volatile gsize gee_concurrent_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_concurrent_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeConcurrentListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_concurrent_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeConcurrentListIterator), 0, (GInstanceInitFunc) gee_concurrent_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) gee_concurrent_list_iterator_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_concurrent_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_concurrent_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_concurrent_list_iterator_type_id;
		gee_concurrent_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeConcurrentListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_concurrent_list_iterator_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
		g_type_add_interface_static (gee_concurrent_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_concurrent_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_once_init_leave (&gee_concurrent_list_iterator_type_id__volatile, gee_concurrent_list_iterator_type_id);
	}
	return gee_concurrent_list_iterator_type_id__volatile;
}


static void _vala_gee_concurrent_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeConcurrentListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_CONCURRENT_LIST_TYPE_ITERATOR, GeeConcurrentListIterator);
	switch (property_id) {
		case GEE_CONCURRENT_LIST_ITERATOR_VALID:
		g_value_set_boolean (value, gee_iterator_get_valid ((GeeIterator*) self));
		break;
		case GEE_CONCURRENT_LIST_ITERATOR_READ_ONLY:
		g_value_set_boolean (value, gee_iterator_get_read_only ((GeeIterator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_concurrent_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeConcurrentListIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_CONCURRENT_LIST_TYPE_ITERATOR, GeeConcurrentListIterator);
	switch (property_id) {
		case GEE_CONCURRENT_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_CONCURRENT_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_CONCURRENT_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GeeConcurrentListNode* gee_concurrent_list_node_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	GeeConcurrentListNode* self = NULL;
	gpointer data_copy = NULL;
	gconstpointer _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	gconstpointer* data_ptr = NULL;
	gpointer _tmp2_ = NULL;
	gconstpointer* _tmp3_ = NULL;
	self = (GeeConcurrentListNode*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	g_atomic_pointer_set ((volatile gpointer *) (&self->_succ), NULL);
	g_atomic_pointer_set ((volatile gpointer *) (&self->_backlink), NULL);
	_tmp0_ = data;
	_tmp1_ = ((_tmp0_ != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) _tmp0_) : ((gpointer) _tmp0_);
	data_copy = _tmp1_;
	_tmp2_ = data_copy;
	data_copy = NULL;
	data_ptr = _tmp2_;
	_tmp3_ = data_ptr;
	data_ptr = NULL;
	g_atomic_pointer_set ((volatile gpointer *) (&self->_data), _tmp3_);
	_g_destroy_func0 (data_copy);
	return self;
}


static GeeConcurrentListNode* gee_concurrent_list_node_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer data) {
	return gee_concurrent_list_node_construct (GEE_CONCURRENT_LIST_TYPE_NODE, g_type, g_dup_func, g_destroy_func, data);
}


static GeeConcurrentListNode* gee_concurrent_list_node_construct_head (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeConcurrentListNode* self = NULL;
	self = (GeeConcurrentListNode*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	g_atomic_pointer_set ((volatile gpointer *) (&self->_succ), NULL);
	g_atomic_pointer_set ((volatile gpointer *) (&self->_backlink), NULL);
	g_atomic_pointer_set ((volatile gpointer *) (&self->_data), NULL);
	return self;
}


static GeeConcurrentListNode* gee_concurrent_list_node_new_head (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_concurrent_list_node_construct_head (GEE_CONCURRENT_LIST_TYPE_NODE, g_type, g_dup_func, g_destroy_func);
}


static inline gboolean gee_concurrent_list_node_proceed (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode** prev, GeeConcurrentListNode** curr, gboolean force) {
	gboolean result = FALSE;
	GeeConcurrentListNode* next = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	gboolean success = FALSE;
	GeeConcurrentListNode* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp26_ = FALSE;
	g_return_val_if_fail (*curr != NULL, FALSE);
	_tmp0_ = *curr;
	_tmp1_ = gee_concurrent_list_node_get_next (_tmp0_);
	next = _tmp1_;
	while (TRUE) {
		GeeConcurrentListNode* _tmp2_ = NULL;
		GeeConcurrentListState next_state = 0;
		GeeConcurrentListNode* _tmp3_ = NULL;
		GeeConcurrentListState _tmp4_ = 0;
		GeeConcurrentListState curr_state = 0;
		GeeConcurrentListNode* curr_next = NULL;
		GeeConcurrentListNode* _tmp5_ = NULL;
		GeeConcurrentListState _tmp6_ = 0;
		GeeConcurrentListNode* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		GeeConcurrentListState _tmp9_ = 0;
		gboolean _tmp15_ = FALSE;
		GeeConcurrentListNode* _tmp16_ = NULL;
		GeeConcurrentListNode* _tmp17_ = NULL;
		GeeConcurrentListNode* _tmp20_ = NULL;
		GeeConcurrentListNode* _tmp21_ = NULL;
		_tmp2_ = next;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = next;
		_tmp4_ = gee_concurrent_list_node_get_state (_tmp3_);
		next_state = _tmp4_;
		_tmp5_ = *curr;
		_tmp7_ = gee_concurrent_list_node_get_succ (_tmp5_, &_tmp6_);
		curr_state = _tmp6_;
		curr_next = _tmp7_;
		_tmp9_ = next_state;
		if (_tmp9_ != GEE_CONCURRENT_LIST_STATE_MARKED) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp10_ = FALSE;
			GeeConcurrentListState _tmp11_ = 0;
			gboolean _tmp14_ = FALSE;
			_tmp11_ = curr_state;
			if (_tmp11_ == GEE_CONCURRENT_LIST_STATE_MARKED) {
				GeeConcurrentListNode* _tmp12_ = NULL;
				GeeConcurrentListNode* _tmp13_ = NULL;
				_tmp12_ = curr_next;
				_tmp13_ = next;
				_tmp10_ = _tmp12_ == _tmp13_;
			} else {
				_tmp10_ = FALSE;
			}
			_tmp14_ = _tmp10_;
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		if (_tmp15_) {
			_gee_concurrent_list_node_unref0 (curr_next);
			break;
		}
		_tmp16_ = curr_next;
		_tmp17_ = next;
		if (_tmp16_ == _tmp17_) {
			GeeConcurrentListNode* _tmp18_ = NULL;
			GeeConcurrentListNode* _tmp19_ = NULL;
			_tmp18_ = next;
			_tmp19_ = *curr;
			gee_concurrent_list_node_help_marked (_tmp18_, _tmp19_);
		}
		_tmp20_ = curr_next;
		_tmp21_ = _gee_concurrent_list_node_ref0 (_tmp20_);
		_gee_concurrent_list_node_unref0 (next);
		next = _tmp21_;
		_gee_concurrent_list_node_unref0 (curr_next);
	}
	_tmp22_ = next;
	success = _tmp22_ != NULL;
	_tmp24_ = success;
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		gboolean _tmp25_ = FALSE;
		_tmp25_ = force;
		_tmp23_ = _tmp25_;
	}
	_tmp26_ = _tmp23_;
	if (_tmp26_) {
		GeeConcurrentListNode* _tmp27_ = NULL;
		GeeConcurrentListNode* _tmp28_ = NULL;
		_tmp27_ = *curr;
		*curr = NULL;
		_gee_concurrent_list_node_unref0 (*prev);
		*prev = _tmp27_;
		_tmp28_ = next;
		next = NULL;
		_gee_concurrent_list_node_unref0 (*curr);
		*curr = _tmp28_;
	}
	result = success;
	_gee_concurrent_list_node_unref0 (next);
	return result;
}


static inline gboolean gee_concurrent_list_node_search_for (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode* goal, GeeConcurrentListNode** prev) {
	gboolean result = FALSE;
	GeeConcurrentListNode* curr = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp10_ = NULL;
	GeeConcurrentListNode* _tmp11_ = NULL;
	_tmp0_ = *prev;
	_tmp1_ = gee_concurrent_list_node_get_next (_tmp0_);
	curr = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		GeeConcurrentListNode* _tmp4_ = NULL;
		GeeConcurrentListNode* _tmp5_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp4_ = curr;
		_tmp5_ = goal;
		if (_tmp4_ != _tmp5_) {
			_tmp3_ = TRUE;
		} else {
			GeeConcurrentListNode* _tmp6_ = NULL;
			_tmp6_ = curr;
			_tmp3_ = _tmp6_ != NULL;
		}
		_tmp7_ = _tmp3_;
		if (_tmp7_) {
			gboolean _tmp8_ = FALSE;
			_tmp8_ = gee_concurrent_list_node_proceed (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, prev, &curr, TRUE);
			_tmp2_ = _tmp8_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp9_ = _tmp2_;
		if (!_tmp9_) {
			break;
		}
	}
	_tmp10_ = curr;
	_tmp11_ = goal;
	result = _tmp10_ == _tmp11_;
	_gee_concurrent_list_node_unref0 (curr);
	return result;
}


static inline gboolean gee_concurrent_list_node_remove (GeeConcurrentListNode* self, GeeConcurrentListNode* prev_node) {
	gboolean result = FALSE;
	GeeConcurrentListNode* prev = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	gboolean _result_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeConcurrentListNode* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prev_node != NULL, FALSE);
	_tmp0_ = prev_node;
	_tmp1_ = _gee_concurrent_list_node_ref0 (_tmp0_);
	prev = _tmp1_;
	_tmp2_ = gee_concurrent_list_node_try_flag (self, &prev);
	_result_ = _tmp2_;
	_tmp3_ = prev;
	if (_tmp3_ != NULL) {
		GeeConcurrentListNode* _tmp4_ = NULL;
		_tmp4_ = prev;
		gee_concurrent_list_node_help_flagged (self, _tmp4_);
	}
	result = _result_;
	_gee_concurrent_list_node_unref0 (prev);
	return result;
}


static inline void gee_concurrent_list_node_insert (GeeConcurrentListNode* self, GeeConcurrentListNode* prev, GeeConcurrentListNode* next) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev != NULL);
	while (TRUE) {
		GeeConcurrentListState prev_state = 0;
		GeeConcurrentListNode* prev_next = NULL;
		GeeConcurrentListState _tmp0_ = 0;
		GeeConcurrentListNode* _tmp1_ = NULL;
		GeeConcurrentListState _tmp2_ = 0;
		GeeConcurrentListNode* _tmp15_ = NULL;
		_tmp1_ = gee_concurrent_list_node_get_succ (self, &_tmp0_);
		prev_state = _tmp0_;
		prev_next = _tmp1_;
		_tmp2_ = prev_state;
		if (_tmp2_ == GEE_CONCURRENT_LIST_STATE_FLAGGED) {
			GeeConcurrentListNode* _tmp3_ = NULL;
			GeeConcurrentListNode* _tmp4_ = NULL;
			_tmp3_ = prev_next;
			_tmp4_ = prev;
			gee_concurrent_list_node_help_flagged (_tmp3_, _tmp4_);
		} else {
			GeeConcurrentListNode* _tmp5_ = NULL;
			gboolean _result_ = FALSE;
			GeeConcurrentListNode* _tmp6_ = NULL;
			GeeConcurrentListNode* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			GeeConcurrentListState _tmp10_ = 0;
			GeeConcurrentListNode* _tmp11_ = NULL;
			GeeConcurrentListState _tmp12_ = 0;
			_tmp5_ = next;
			gee_concurrent_list_node_set_succ (self, _tmp5_, GEE_CONCURRENT_LIST_STATE_NONE);
			_tmp6_ = prev;
			_tmp7_ = next;
			_tmp8_ = gee_concurrent_list_node_compare_and_exchange (_tmp6_, _tmp7_, GEE_CONCURRENT_LIST_STATE_NONE, self, GEE_CONCURRENT_LIST_STATE_NONE);
			_result_ = _tmp8_;
			_tmp9_ = _result_;
			if (_tmp9_) {
				_gee_concurrent_list_node_unref0 (prev_next);
				_gee_concurrent_list_node_unref0 (prev);
				return;
			}
			_tmp11_ = gee_concurrent_list_node_get_succ (self, &_tmp10_);
			prev_state = _tmp10_;
			_gee_concurrent_list_node_unref0 (prev_next);
			prev_next = _tmp11_;
			_tmp12_ = prev_state;
			if (_tmp12_ == GEE_CONCURRENT_LIST_STATE_FLAGGED) {
				GeeConcurrentListNode* _tmp13_ = NULL;
				GeeConcurrentListNode* _tmp14_ = NULL;
				_tmp13_ = prev_next;
				_tmp14_ = prev;
				gee_concurrent_list_node_help_flagged (_tmp13_, _tmp14_);
			}
			gee_concurrent_list_node_backtrace (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &prev);
		}
		_tmp15_ = next;
		gee_concurrent_list_node_search_for (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, _tmp15_, &prev);
		_gee_concurrent_list_node_unref0 (prev_next);
	}
	_gee_concurrent_list_node_unref0 (prev);
}


static inline void gee_concurrent_list_node_help_flagged (GeeConcurrentListNode* self, GeeConcurrentListNode* prev) {
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListState _tmp1_ = 0;
	GeeConcurrentListNode* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev != NULL);
	_tmp0_ = prev;
	gee_concurrent_list_node_set_backlink (self, _tmp0_);
	_tmp1_ = gee_concurrent_list_node_get_state (self);
	if (_tmp1_ != GEE_CONCURRENT_LIST_STATE_MARKED) {
		gee_concurrent_list_node_try_mark (self);
	}
	_tmp2_ = prev;
	gee_concurrent_list_node_help_marked (self, _tmp2_);
}


static inline void gee_concurrent_list_node_try_mark (GeeConcurrentListNode* self) {
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			GeeConcurrentListNode* next_node = NULL;
			GeeConcurrentListNode* _tmp3_ = NULL;
			gboolean _result_ = FALSE;
			GeeConcurrentListNode* _tmp4_ = NULL;
			GeeConcurrentListNode* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				GeeConcurrentListState _tmp2_ = 0;
				_tmp2_ = gee_concurrent_list_node_get_state (self);
				if (!(_tmp2_ != GEE_CONCURRENT_LIST_STATE_MARKED)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp3_ = gee_concurrent_list_node_get_next (self);
			next_node = _tmp3_;
			_tmp4_ = next_node;
			_tmp5_ = next_node;
			_tmp6_ = gee_concurrent_list_node_compare_and_exchange (self, _tmp4_, GEE_CONCURRENT_LIST_STATE_NONE, _tmp5_, GEE_CONCURRENT_LIST_STATE_MARKED);
			_result_ = _tmp6_;
			_tmp7_ = _result_;
			if (!_tmp7_) {
				GeeConcurrentListState state = 0;
				GeeConcurrentListState _tmp8_ = 0;
				GeeConcurrentListNode* _tmp9_ = NULL;
				GeeConcurrentListState _tmp10_ = 0;
				_tmp9_ = gee_concurrent_list_node_get_succ (self, &_tmp8_);
				state = _tmp8_;
				_gee_concurrent_list_node_unref0 (next_node);
				next_node = _tmp9_;
				_tmp10_ = state;
				if (_tmp10_ == GEE_CONCURRENT_LIST_STATE_FLAGGED) {
					GeeConcurrentListNode* _tmp11_ = NULL;
					_tmp11_ = next_node;
					gee_concurrent_list_node_help_flagged (self, _tmp11_);
				}
			}
			_gee_concurrent_list_node_unref0 (next_node);
		}
	}
}


static inline void gee_concurrent_list_node_help_marked (GeeConcurrentListNode* self, GeeConcurrentListNode* prev_node) {
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prev_node != NULL);
	_tmp0_ = prev_node;
	_tmp1_ = gee_concurrent_list_node_get_next (self);
	_tmp2_ = _tmp1_;
	gee_concurrent_list_node_compare_and_exchange (_tmp0_, self, GEE_CONCURRENT_LIST_STATE_FLAGGED, _tmp2_, GEE_CONCURRENT_LIST_STATE_NONE);
	_gee_concurrent_list_node_unref0 (_tmp2_);
}


static inline gboolean gee_concurrent_list_node_try_flag (GeeConcurrentListNode* self, GeeConcurrentListNode** prev_node) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		GeeConcurrentListNode* _tmp0_ = NULL;
		gboolean _tmp1_ = FALSE;
		gboolean _result_ = FALSE;
		GeeConcurrentListNode* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		GeeConcurrentListState result_state = 0;
		GeeConcurrentListNode* result_node = NULL;
		GeeConcurrentListNode* _tmp5_ = NULL;
		GeeConcurrentListState _tmp6_ = 0;
		GeeConcurrentListNode* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		GeeConcurrentListNode* _tmp9_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp0_ = *prev_node;
		_tmp1_ = gee_concurrent_list_node_compare_succ (_tmp0_, self, GEE_CONCURRENT_LIST_STATE_FLAGGED);
		if (_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = *prev_node;
		_tmp3_ = gee_concurrent_list_node_compare_and_exchange (_tmp2_, self, GEE_CONCURRENT_LIST_STATE_NONE, self, GEE_CONCURRENT_LIST_STATE_FLAGGED);
		_result_ = _tmp3_;
		_tmp4_ = _result_;
		if (_tmp4_) {
			result = TRUE;
			return result;
		}
		_tmp5_ = *prev_node;
		_tmp7_ = gee_concurrent_list_node_get_succ (_tmp5_, &_tmp6_);
		result_state = _tmp6_;
		result_node = _tmp7_;
		_tmp9_ = result_node;
		if (_tmp9_ == self) {
			GeeConcurrentListState _tmp10_ = 0;
			_tmp10_ = result_state;
			_tmp8_ = _tmp10_ == GEE_CONCURRENT_LIST_STATE_FLAGGED;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp11_ = _tmp8_;
		if (_tmp11_) {
			result = FALSE;
			_gee_concurrent_list_node_unref0 (result_node);
			return result;
		}
		gee_concurrent_list_node_backtrace (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, prev_node);
		_tmp12_ = gee_concurrent_list_node_search_for (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self, prev_node);
		if (!_tmp12_) {
			_gee_concurrent_list_node_unref0 (*prev_node);
			*prev_node = NULL;
			result = FALSE;
			_gee_concurrent_list_node_unref0 (result_node);
			return result;
		}
		_gee_concurrent_list_node_unref0 (result_node);
	}
}


static inline void gee_concurrent_list_node_backtrace (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeConcurrentListNode** curr) {
	while (TRUE) {
		GeeConcurrentListNode* _tmp0_ = NULL;
		GeeConcurrentListState _tmp1_ = 0;
		GeeConcurrentListNode* _tmp2_ = NULL;
		GeeConcurrentListNode* _tmp3_ = NULL;
		_tmp0_ = *curr;
		_tmp1_ = gee_concurrent_list_node_get_state (_tmp0_);
		if (!(_tmp1_ == GEE_CONCURRENT_LIST_STATE_MARKED)) {
			break;
		}
		_tmp2_ = *curr;
		_tmp3_ = gee_concurrent_list_node_get_backlink (_tmp2_);
		_gee_concurrent_list_node_unref0 (*curr);
		*curr = _tmp3_;
	}
}


static inline gboolean gee_concurrent_list_node_compare_and_exchange (GeeConcurrentListNode* self, GeeConcurrentListNode* old_node, GeeConcurrentListState old_state, GeeConcurrentListNode* new_node, GeeConcurrentListState new_state) {
	gboolean result = FALSE;
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp2_ = NULL;
	GeeConcurrentListState _tmp3_ = 0;
	GeeConcurrentListState _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = old_node;
	_tmp1_ = new_node;
	_tmp2_ = _gee_concurrent_list_node_ref0 (_tmp1_);
	_tmp3_ = old_state;
	_tmp4_ = new_state;
	_tmp5_ = gee_hazard_pointer_compare_and_exchange_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->_succ, _tmp0_, _tmp2_, (gsize) 3, (gsize) _tmp3_, (gsize) _tmp4_);
	result = _tmp5_;
	return result;
}


static inline gboolean gee_concurrent_list_node_compare_succ (GeeConcurrentListNode* self, GeeConcurrentListNode* next, GeeConcurrentListState state) {
	gboolean result = FALSE;
	gsize cur = 0UL;
	void* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	GeeConcurrentListState _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_atomic_pointer_get ((volatile gpointer *) (&self->_succ));
	cur = (gsize) _tmp0_;
	_tmp1_ = next;
	_tmp2_ = state;
	result = cur == (((gsize) _tmp1_) | ((gsize) _tmp2_));
	return result;
}


static inline GeeConcurrentListNode* gee_concurrent_list_node_get_next (GeeConcurrentListNode* self) {
	GeeConcurrentListNode* result = NULL;
	GeeConcurrentListNode* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_concurrent_list_node_get_succ (self, NULL);
	result = _tmp0_;
	return result;
}


static inline GeeConcurrentListState gee_concurrent_list_node_get_state (GeeConcurrentListNode* self) {
	GeeConcurrentListState result = 0;
	void* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_atomic_pointer_get ((volatile gpointer *) (&self->_succ));
	result = (GeeConcurrentListState) (((gsize) _tmp0_) & 3);
	return result;
}


static inline GeeConcurrentListNode* gee_concurrent_list_node_get_succ (GeeConcurrentListNode* self, GeeConcurrentListState* state) {
	GeeConcurrentListState _vala_state = 0;
	GeeConcurrentListNode* result = NULL;
	gsize rstate = 0UL;
	GeeConcurrentListNode* succ = NULL;
	gsize _tmp0_ = 0UL;
	gpointer _tmp1_ = NULL;
	GeeConcurrentListNode* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gee_hazard_pointer_get_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->_succ, (gsize) 3, &_tmp0_);
	rstate = _tmp0_;
	succ = (GeeConcurrentListNode*) _tmp1_;
	_vala_state = (GeeConcurrentListState) rstate;
	_tmp2_ = succ;
	succ = NULL;
	result = _tmp2_;
	_gee_concurrent_list_node_unref0 (succ);
	if (state) {
		*state = _vala_state;
	}
	return result;
}


static inline void gee_concurrent_list_node_set_succ (GeeConcurrentListNode* self, GeeConcurrentListNode* next, GeeConcurrentListState state) {
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	GeeConcurrentListState _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = next;
	_tmp1_ = _gee_concurrent_list_node_ref0 (_tmp0_);
	_tmp2_ = state;
	gee_hazard_pointer_set_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->_succ, _tmp1_, (gsize) 3, (gsize) _tmp2_);
}


static inline GeeConcurrentListNode* gee_concurrent_list_node_get_backlink (GeeConcurrentListNode* self) {
	GeeConcurrentListNode* result = NULL;
	gpointer _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hazard_pointer_get_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->_backlink, (gsize) 0, NULL);
	result = (GeeConcurrentListNode*) _tmp0_;
	return result;
}


static inline void gee_concurrent_list_node_set_backlink (GeeConcurrentListNode* self, GeeConcurrentListNode* backlink) {
	GeeConcurrentListNode* _tmp0_ = NULL;
	GeeConcurrentListNode* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = backlink;
	_tmp1_ = _gee_concurrent_list_node_ref0 (_tmp0_);
	gee_hazard_pointer_compare_and_exchange_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->_backlink, NULL, _tmp1_, (gsize) 0, (gsize) 0, (gsize) 0);
}


static void gee_concurrent_list_value_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gee_concurrent_list_value_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gee_concurrent_list_node_unref (value->data[0].v_pointer);
	}
}


static void gee_concurrent_list_value_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_concurrent_list_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gee_concurrent_list_value_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gee_concurrent_list_value_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GeeConcurrentListNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_concurrent_list_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gee_concurrent_list_value_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GeeConcurrentListNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_concurrent_list_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* gee_concurrent_list_param_spec_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GeeConcurrentListParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_CONCURRENT_LIST_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer gee_concurrent_list_value_get_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_CONCURRENT_LIST_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


static void gee_concurrent_list_value_set_node (GValue* value, gpointer v_object) {
	GeeConcurrentListNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_CONCURRENT_LIST_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_CONCURRENT_LIST_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_concurrent_list_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_concurrent_list_node_unref (old);
	}
}


static void gee_concurrent_list_value_take_node (GValue* value, gpointer v_object) {
	GeeConcurrentListNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_CONCURRENT_LIST_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_CONCURRENT_LIST_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_concurrent_list_node_unref (old);
	}
}


static void gee_concurrent_list_node_class_init (GeeConcurrentListNodeClass * klass) {
	gee_concurrent_list_node_parent_class = g_type_class_peek_parent (klass);
	GEE_CONCURRENT_LIST_NODE_CLASS (klass)->finalize = gee_concurrent_list_node_finalize;
	g_type_class_add_private (klass, sizeof (GeeConcurrentListNodePrivate));
}


static void gee_concurrent_list_node_instance_init (GeeConcurrentListNode * self) {
	self->priv = GEE_CONCURRENT_LIST_NODE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void gee_concurrent_list_node_finalize (GeeConcurrentListNode* obj) {
	GeeConcurrentListNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_CONCURRENT_LIST_TYPE_NODE, GeeConcurrentListNode);
	gee_hazard_pointer_set_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->_succ, NULL, (gsize) 3, (gsize) 0);
	gee_hazard_pointer_set_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->_backlink, NULL, (gsize) 0, (gsize) 0);
	gee_hazard_pointer_set_pointer (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, &self->_data, NULL, (gsize) 0, (gsize) 0);
}


static GType gee_concurrent_list_node_get_type (void) {
	static volatile gsize gee_concurrent_list_node_type_id__volatile = 0;
	if (g_once_init_enter (&gee_concurrent_list_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_concurrent_list_value_node_init, gee_concurrent_list_value_node_free_value, gee_concurrent_list_value_node_copy_value, gee_concurrent_list_value_node_peek_pointer, "p", gee_concurrent_list_value_node_collect_value, "p", gee_concurrent_list_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeConcurrentListNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_concurrent_list_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeConcurrentListNode), 0, (GInstanceInitFunc) gee_concurrent_list_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_concurrent_list_node_type_id;
		gee_concurrent_list_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeConcurrentListNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gee_concurrent_list_node_type_id__volatile, gee_concurrent_list_node_type_id);
	}
	return gee_concurrent_list_node_type_id__volatile;
}


static gpointer gee_concurrent_list_node_ref (gpointer instance) {
	GeeConcurrentListNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void gee_concurrent_list_node_unref (gpointer instance) {
	GeeConcurrentListNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_CONCURRENT_LIST_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void gee_concurrent_list_class_init (GeeConcurrentListClass * klass) {
	gee_concurrent_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeConcurrentListPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_concurrent_list_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_concurrent_list_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_concurrent_list_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_concurrent_list_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_concurrent_list_real_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = gee_concurrent_list_real_list_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_concurrent_list_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_concurrent_list_real_set;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_concurrent_list_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_concurrent_list_real_insert;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_concurrent_list_real_remove_at;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_concurrent_list_real_slice;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gee_concurrent_list_real_get_read_only;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_concurrent_list_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_concurrent_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_concurrent_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_concurrent_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_CONCURRENT_LIST_IS_EMPTY, g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_concurrent_list_instance_init (GeeConcurrentList * self) {
	self->priv = GEE_CONCURRENT_LIST_GET_PRIVATE (self);
}


static void gee_concurrent_list_finalize (GObject* obj) {
	GeeConcurrentList * self;
	GeeHazardPointerContext* ctx = NULL;
	GeeHazardPointerContext* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_CONCURRENT_LIST, GeeConcurrentList);
	_tmp0_ = gee_hazard_pointer_context_new (NULL);
	ctx = _tmp0_;
	_gee_concurrent_list_node_unref0 (self->priv->_head);
	self->priv->_head = NULL;
	gee_hazard_pointer_set_pointer (GEE_CONCURRENT_LIST_TYPE_NODE, (GBoxedCopyFunc) gee_concurrent_list_node_ref, gee_concurrent_list_node_unref, &self->priv->_tail, NULL, (gsize) 0, (gsize) 0);
	_gee_hazard_pointer_context_free0 (ctx);
	(self->priv->_equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->_equal_func_target_destroy_notify (self->priv->_equal_func_target), NULL);
	self->priv->_equal_func = NULL;
	self->priv->_equal_func_target = NULL;
	self->priv->_equal_func_target_destroy_notify = NULL;
	_gee_concurrent_list_node_unref0 (self->priv->_head);
	G_OBJECT_CLASS (gee_concurrent_list_parent_class)->finalize (obj);
}


/**
 * A single-linked list. This implementation is based on
 * [[http://www.cse.yorku.ca/~ruppert/papers/lfll.pdf|Mikhail Fomitchev and  Eric Ruppert paper ]].
 *
 * Many threads are allowed to operate on the same structure as well as modification
 * of structure during iteration is allowed. However the change may not be immidiatly
 * visible to other threads.
 */
GType gee_concurrent_list_get_type (void) {
	static volatile gsize gee_concurrent_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_concurrent_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeConcurrentListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_concurrent_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeConcurrentList), 0, (GInstanceInitFunc) gee_concurrent_list_instance_init, NULL };
		GType gee_concurrent_list_type_id;
		gee_concurrent_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "GeeConcurrentList", &g_define_type_info, 0);
		g_once_init_leave (&gee_concurrent_list_type_id__volatile, gee_concurrent_list_type_id);
	}
	return gee_concurrent_list_type_id__volatile;
}


static void _vala_gee_concurrent_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeConcurrentList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_CONCURRENT_LIST, GeeConcurrentList);
	switch (property_id) {
		case GEE_CONCURRENT_LIST_READ_ONLY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GEE_CONCURRENT_LIST_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_CONCURRENT_LIST_IS_EMPTY:
		g_value_set_boolean (value, gee_concurrent_list_get_is_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_concurrent_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeConcurrentList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_CONCURRENT_LIST, GeeConcurrentList);
	switch (property_id) {
		case GEE_CONCURRENT_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_CONCURRENT_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_CONCURRENT_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



