; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumb-eabi < %s | FileCheck %s

define i1 @test_srem_odd(i29 %X) nounwind {
; CHECK-LABEL: test_srem_odd:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    ldr r1, .LCPI0_0
; CHECK-NEXT:    muls r1, r0, r1
; CHECK-NEXT:    ldr r0, .LCPI0_1
; CHECK-NEXT:    adds r0, r1, r0
; CHECK-NEXT:    ldr r1, .LCPI0_2
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    blo .LBB0_2
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:    movs r0, #0
; CHECK-NEXT:    bx lr
; CHECK-NEXT:  .LBB0_2:
; CHECK-NEXT:    movs r0, #1
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 2
; CHECK-NEXT:  @ %bb.3:
; CHECK-NEXT:  .LCPI0_0:
; CHECK-NEXT:    .long 4208200280 @ 0xfad40a58
; CHECK-NEXT:  .LCPI0_1:
; CHECK-NEXT:    .long 21691752 @ 0x14afd68
; CHECK-NEXT:  .LCPI0_2:
; CHECK-NEXT:    .long 43383512 @ 0x295fad8
  %srem = srem i29 %X, 99
  %cmp = icmp eq i29 %srem, 0
  ret i1 %cmp
}

define i1 @test_srem_even(i4 %X) nounwind {
; CHECK-LABEL: test_srem_even:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    lsls r0, r0, #28
; CHECK-NEXT:    asrs r0, r0, #28
; CHECK-NEXT:    movs r1, #6
; CHECK-NEXT:    bl __aeabi_idivmod
; CHECK-NEXT:    subs r1, r1, #1
; CHECK-NEXT:    rsbs r0, r1, #0
; CHECK-NEXT:    adcs r0, r1
; CHECK-NEXT:    pop {r7}
; CHECK-NEXT:    pop {r1}
; CHECK-NEXT:    bx r1
  %srem = srem i4 %X, 6
  %cmp = icmp eq i4 %srem, 1
  ret i1 %cmp
}

define i1 @test_srem_pow2_setne(i6 %X) nounwind {
; CHECK-LABEL: test_srem_pow2_setne:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    lsls r1, r0, #26
; CHECK-NEXT:    asrs r1, r1, #26
; CHECK-NEXT:    lsrs r1, r1, #30
; CHECK-NEXT:    adds r1, r0, r1
; CHECK-NEXT:    movs r2, #60
; CHECK-NEXT:    ands r2, r1
; CHECK-NEXT:    subs r1, r0, r2
; CHECK-NEXT:    movs r0, #63
; CHECK-NEXT:    ands r0, r1
; CHECK-NEXT:    subs r1, r0, #1
; CHECK-NEXT:    sbcs r0, r1
; CHECK-NEXT:    bx lr
  %srem = srem i6 %X, 4
  %cmp = icmp ne i6 %srem, 0
  ret i1 %cmp
}

define <3 x i1> @test_srem_vec(<3 x i33> %X) nounwind {
; CHECK-LABEL: test_srem_vec:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, r5, r6, r7, lr}
; CHECK-NEXT:    push {r4, r5, r6, r7, lr}
; CHECK-NEXT:    .pad #12
; CHECK-NEXT:    sub sp, #12
; CHECK-NEXT:    movs r7, r3
; CHECK-NEXT:    str r2, [sp, #4] @ 4-byte Spill
; CHECK-NEXT:    movs r5, #1
; CHECK-NEXT:    ands r1, r5
; CHECK-NEXT:    rsbs r1, r1, #0
; CHECK-NEXT:    movs r6, #9
; CHECK-NEXT:    movs r3, #0
; CHECK-NEXT:    str r3, [sp] @ 4-byte Spill
; CHECK-NEXT:    movs r2, r6
; CHECK-NEXT:    bl __aeabi_ldivmod
; CHECK-NEXT:    movs r4, r2
; CHECK-NEXT:    movs r0, #3
; CHECK-NEXT:    str r0, [sp, #8] @ 4-byte Spill
; CHECK-NEXT:    eors r4, r0
; CHECK-NEXT:    orrs r4, r3
; CHECK-NEXT:    subs r0, r4, #1
; CHECK-NEXT:    sbcs r4, r0
; CHECK-NEXT:    ands r7, r5
; CHECK-NEXT:    rsbs r1, r7, #0
; CHECK-NEXT:    ldr r0, [sp, #4] @ 4-byte Reload
; CHECK-NEXT:    movs r2, r6
; CHECK-NEXT:    ldr r7, [sp] @ 4-byte Reload
; CHECK-NEXT:    movs r3, r7
; CHECK-NEXT:    bl __aeabi_ldivmod
; CHECK-NEXT:    movs r0, r5
; CHECK-NEXT:    bics r0, r3
; CHECK-NEXT:    movs r1, #2
; CHECK-NEXT:    mvns r6, r1
; CHECK-NEXT:    eors r6, r2
; CHECK-NEXT:    orrs r6, r0
; CHECK-NEXT:    subs r0, r6, #1
; CHECK-NEXT:    sbcs r6, r0
; CHECK-NEXT:    ldr r0, [sp, #36]
; CHECK-NEXT:    ands r0, r5
; CHECK-NEXT:    rsbs r1, r0, #0
; CHECK-NEXT:    movs r0, #8
; CHECK-NEXT:    mvns r2, r0
; CHECK-NEXT:    mvns r3, r7
; CHECK-NEXT:    ldr r0, [sp, #32]
; CHECK-NEXT:    bl __aeabi_ldivmod
; CHECK-NEXT:    ands r5, r3
; CHECK-NEXT:    ldr r0, [sp, #8] @ 4-byte Reload
; CHECK-NEXT:    eors r2, r0
; CHECK-NEXT:    orrs r2, r5
; CHECK-NEXT:    subs r0, r2, #1
; CHECK-NEXT:    sbcs r2, r0
; CHECK-NEXT:    movs r0, r4
; CHECK-NEXT:    movs r1, r6
; CHECK-NEXT:    add sp, #12
; CHECK-NEXT:    pop {r4, r5, r6, r7}
; CHECK-NEXT:    pop {r3}
; CHECK-NEXT:    bx r3
  %srem = srem <3 x i33> %X, <i33 9, i33 9, i33 -9>
  %cmp = icmp ne <3 x i33> %srem, <i33 3, i33 -3, i33 3>
  ret <3 x i1> %cmp
}
