; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -mattr=+2e3 | FileCheck %s

;eq
define i1 @icmpRR_eq(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_eq(i32 %x) {
; CHECK-LABEL: icmpRI_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_eq(i32 %x) {
; CHECK-LABEL: icmpRI_X_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33768
; CHECK-NEXT:    cmpne16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_eq(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_eq(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_eq(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_eq(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_eq(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_eq(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_eq(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_eq(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_eq:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp eq i1 %x, 1
  ret i1 %icmp
}

;ne
define i1 @icmpRR_ne(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_ne(i32 %x) {
; CHECK-LABEL: icmpRI_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpnei16 a0, 10
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_ne(i32 %x) {
; CHECK-LABEL: icmpRI_X_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33768
; CHECK-NEXT:    cmpne16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_ne(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_ne(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_ne(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_ne(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_ne(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmpne16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_ne(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_ne(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_ne(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_ne:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ne i1 %x, 1
  ret i1 %icmp
}


;ugt
define i1 @icmpRR_ugt(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_ugt(i32 %x) {
; CHECK-LABEL: icmpRI_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_ugt(i32 %x) {
; CHECK-LABEL: icmpRI_X_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33768
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_ugt(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_ugt(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a2, 1
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a2
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    movf32 a0, a2
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_ugt(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_ugt(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_ugt(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_ugt(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_ugt(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_ugt(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_ugt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ugt i1 %x, 1
  ret i1 %icmp
}


;uge
define i1 @icmpRR_uge(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_uge(i32 %x) {
; CHECK-LABEL: icmpRI_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_uge(i32 %x) {
; CHECK-LABEL: icmpRI_X_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33767
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_uge(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a0, (sp, 12)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_uge(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_uge(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_uge(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_uge(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_uge(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_uge(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_uge(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_uge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp uge i1 %x, 1
  ret i1 %icmp
}


;ult
define i1 @icmpRR_ult(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_ult(i32 %x) {
; CHECK-LABEL: icmpRI_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 10
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_ult(i32 %x) {
; CHECK-LABEL: icmpRI_X_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33768
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_ult(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmphs16 a3, a1
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a1, a0
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_ult(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_ult(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_ult(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_ult(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    cmphs16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_ult(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_ult(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a1, a1, 1
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_ult(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_ult:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ult i1 %x, 1
  ret i1 %icmp
}


;ule
define i1 @icmpRR_ule(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_ule(i32 %x) {
; CHECK-LABEL: icmpRI_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmphsi16 a0, 11
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_ule(i32 %x) {
; CHECK-LABEL: icmpRI_X_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33769
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_ule(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    cmphs16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 12)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a0, (sp, 12)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_ule(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 8
; CHECK-NEXT:    .cfi_def_cfa_offset 8
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 4)
; CHECK-NEXT:    cmphsi16 a0, 2
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    ld16.w a2, (sp, 4)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 8
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_ule(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_ule(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_ule(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphs16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_ule(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    cmphsi16 a0, 2
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_ule(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a1, a1, 1
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_ule(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_ule:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp ule i1 %x, 1
  ret i1 %icmp
}

;sgt
define i1 @icmpRR_sgt(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_sgt(i32 %x) {
; CHECK-LABEL: icmpRI_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_sgt(i32 %x) {
; CHECK-LABEL: icmpRI_X_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33768
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_sgt(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_sgt(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 8)
; CHECK-NEXT:    movi16 a2, 1
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a2
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    ld16.w a0, (sp, 8)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    movf32 a0, a2
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_sgt(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_sgt(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_sgt(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_sgt(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_sgt(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a1, a1, 1
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_sgt(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_sgt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sgt i1 %x, 1
  ret i1 %icmp
}

;sge
define i1 @icmpRR_sge(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_sge(i32 %x) {
; CHECK-LABEL: icmpRI_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 9
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_sge(i32 %x) {
; CHECK-LABEL: icmpRI_X_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33767
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_sge(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_sge(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a2, a1
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 12)
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a0, (sp, 12)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 16
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_sge(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_sge(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_sge(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_sge(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_sge(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a1, a1, 1
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_sge(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_sge:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sge i1 %x, 1
  ret i1 %icmp
}

;slt
define i1 @icmpRR_slt(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_slt(i32 %x) {
; CHECK-LABEL: icmpRI_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 10
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_slt(i32 %x) {
; CHECK-LABEL: icmpRI_X_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33768
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_slt(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmplt16 a3, a1
; CHECK-NEXT:    mvc32 t0
; CHECK-NEXT:    st32.w t0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphs16 a2, a0
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_slt(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmpnei16 a0, 0
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_slt(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_slt(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_slt(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    cmplt16 a1, a0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_slt(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_slt(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_slt(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_slt:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a0, 0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp slt i1 %x, 1
  ret i1 %icmp
}


;sle
define i1 @icmpRR_sle(i32 %x, i32 %y) {
; CHECK-LABEL: icmpRR_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %y, %x
  ret i1 %icmp
}

define i1 @icmpRI_sle(i32 %x) {
; CHECK-LABEL: icmpRI_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmplti16 a0, 11
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 10
  ret i1 %icmp
}

define i1 @icmpRI_X_sle(i32 %x) {
; CHECK-LABEL: icmpRI_X_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 62
; CHECK-NEXT:    ori32 a1, a1, 33769
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i32 %x, 4097000
  ret i1 %icmp
}

define i1 @ICMP_LONG_sle(i64 %x, i64 %y) {
; CHECK-LABEL: ICMP_LONG_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    cmphs16 a0, a2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 4)
; CHECK-NEXT:    cmpne16 a3, a1
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    st16.w a0, (sp, 8)
; CHECK-NEXT:    cmplt16 a1, a3
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    ld16.w a1, (sp, 4)
; CHECK-NEXT:    btsti32 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i64 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_LONG_I_sle(i64 %x) {
; CHECK-LABEL: ICMP_LONG_I_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    subi16 sp, sp, 12
; CHECK-NEXT:    .cfi_def_cfa_offset 12
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    cmplt16 a1, a2
; CHECK-NEXT:    mvc32 a2
; CHECK-NEXT:    st16.w a2, (sp, 4)
; CHECK-NEXT:    cmpnei16 a1, 0
; CHECK-NEXT:    mvc32 a1
; CHECK-NEXT:    st16.w a1, (sp, 8)
; CHECK-NEXT:    cmphsi16 a0, 2
; CHECK-NEXT:    mvcv16 a1
; CHECK-NEXT:    ld16.w a0, (sp, 4)
; CHECK-NEXT:    btsti32 a0, 0
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    ld16.w a2, (sp, 8)
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    movf32 a0, a1
; CHECK-NEXT:    addi16 sp, sp, 12
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i64 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_SHORT_sle(i16 %x, i16 %y) {
; CHECK-LABEL: ICMP_SHORT_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_SHORT_I_sle(i16 %x) {
; CHECK-LABEL: ICMP_SHORT_I_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i16 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_CHAR_sle(i8 %x, i8 %y) {
; CHECK-LABEL: ICMP_CHAR_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplt16 a0, a1
; CHECK-NEXT:    mvcv16 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_CHAR_I_sle(i8 %x) {
; CHECK-LABEL: ICMP_CHAR_I_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    cmplti16 a0, 2
; CHECK-NEXT:    mvc32 a0
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i8 %x, 1
  ret i1 %icmp
}

define i1 @ICMP_BIT_sle(i1 %x, i1 %y) {
; CHECK-LABEL: ICMP_BIT_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %y, %x
  ret i1 %icmp
}

define i1 @ICMP_BIT_I_sle(i1 %x) {
; CHECK-LABEL: ICMP_BIT_I_sle:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %icmp = icmp sle i1 %x, 1
  ret i1 %icmp
}
