; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases -mattr=+e2 -mattr=+2e3 < %s -mtriple=csky | FileCheck %s

define i32 @addRR(i32 %x, i32 %y) {
; CHECK-LABEL: addRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i32 %y, %x
  ret i32 %add
}

define i32 @addRI(i32 %x) {
; CHECK-LABEL: addRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi16 a0, 10
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i32 %x, 10
  ret i32 %add
}

define i32 @addRI_X(i32 %x) {
; CHECK-LABEL: addRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi32 a1, 4097
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i32 %x, 4097
  ret i32 %add
}

define i64 @ADD_LONG(i64 %x, i64 %y) {
; CHECK-LABEL: ADD_LONG:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrc32
; CHECK-NEXT:    addc32 a0, a2, a0
; CHECK-NEXT:    addc32 a1, a3, a1
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i64 %y, %x
  ret i64 %add
}

define i64 @ADD_LONG_I(i64 %x) {
; CHECK-LABEL: ADD_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrc32
; CHECK-NEXT:    movi16 a2, 1
; CHECK-NEXT:    addc16 a0, a2
; CHECK-NEXT:    movi16 a2, 0
; CHECK-NEXT:    addc16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i64 %x, 1
  ret i64 %add
}

define i16 @ADD_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: ADD_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i16 %y, %x
  ret i16 %add
}

define i16 @ADD_SHORT_I(i16 %x) {
; CHECK-LABEL: ADD_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i16 %x, 1
  ret i16 %add
}

define i8 @ADD_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: ADD_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i8 %y, %x
  ret i8 %add
}

define i8 @ADD_CHAR_I(i8 %x) {
; CHECK-LABEL: ADD_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %add = add nsw i8 %x, 1
  ret i8 %add
}


define i32 @subRR(i32 %x, i32 %y) {
; CHECK-LABEL: subRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subu16 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i32 %y, %x
  ret i32 %sub
}

define i32 @subRI(i32 %x) {
; CHECK-LABEL: subRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65526
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i32 %x, 10
  ret i32 %sub
}

define i32 @subRI_X(i32 %x) {
; CHECK-LABEL: subRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 61439
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i32 %x, 4097
  ret i32 %sub
}

define i64 @SUB_LONG(i64 %x, i64 %y) {
; CHECK-LABEL: SUB_LONG:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    setc32
; CHECK-NEXT:    subc32 a0, a2, a0
; CHECK-NEXT:    mvcv16 a2
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    mvcv16 a2
; CHECK-NEXT:    btsti32 a2, 0
; CHECK-NEXT:    subc32 a1, a3, a1
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i64 %y, %x
  ret i64 %sub
}

define i64 @SUB_LONG_I(i64 %x) {
; CHECK-LABEL: SUB_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrc32
; CHECK-NEXT:    movih32 a2, 65535
; CHECK-NEXT:    ori32 a2, a2, 65535
; CHECK-NEXT:    addc16 a0, a2
; CHECK-NEXT:    addc16 a1, a2
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i64 %x, 1
  ret i64 %sub
}

define i16 @SUB_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: SUB_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subu16 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i16 %y, %x
  ret i16 %sub
}

define i16 @SUB_SHORT_I(i16 %x) {
; CHECK-LABEL: SUB_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i16 %x, 1
  ret i16 %sub
}

define i8 @SUB_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: SUB_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    subu16 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i8 %y, %x
  ret i8 %sub
}

define i8 @SUB_CHAR_I(i8 %x) {
; CHECK-LABEL: SUB_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65535
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %sub = sub nsw i8 %x, 1
  ret i8 %sub
}

define i32 @mulRR(i32 %x, i32 %y) {
; CHECK-LABEL: mulRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %mul = mul nsw i32 %y, %x
  ret i32 %mul
}

define i32 @mulRI(i32 %x) {
; CHECK-LABEL: mulRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %mul = mul nsw i32 %x, 10
  ret i32 %mul
}

define i32 @mulRI_X(i32 %x) {
; CHECK-LABEL: mulRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi32 a1, 4097
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %mul = mul nsw i32 %x, 4097
  ret i32 %mul
}

define i16 @MUL_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: MUL_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %mul = mul nsw i16 %y, %x
  ret i16 %mul
}

define i16 @MUL_SHORT_I(i16 %x) {
; CHECK-LABEL: MUL_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 3
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %mul = mul nsw i16 %x, 3
  ret i16 %mul
}

define i8 @MUL_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: MUL_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %mul = mul nsw i8 %y, %x
  ret i8 %mul
}

define i8 @MUL_CHAR_I(i8 %x) {
; CHECK-LABEL: MUL_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movih32 a1, 65535
; CHECK-NEXT:    ori32 a1, a1, 65533
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %mul = mul nsw i8 %x, -3
  ret i8 %mul
}

define i32 @udivRR(i32 %x, i32 %y) {
; CHECK-LABEL: udivRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    divu32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %udiv = udiv  i32 %y, %x
  ret i32 %udiv
}

define i32 @udivRI(i32 %x) {
; CHECK-LABEL: udivRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    divu32 a0, a0, a1
; CHECK-NEXT:    rts16
entry:
  %udiv = udiv  i32 %x, 10
  ret i32 %udiv
}

define i32 @udivRI_X(i32 %x) {
; CHECK-LABEL: udivRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi32 a1, 4097
; CHECK-NEXT:    divu32 a0, a0, a1
; CHECK-NEXT:    rts16
entry:
  %udiv = udiv  i32 %x, 4097
  ret i32 %udiv
}

define i16 @UDIV_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: UDIV_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    divu32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %udiv = udiv  i16 %y, %x
  ret i16 %udiv
}

define i16 @UDIV_SHORT_I(i16 %x) {
; CHECK-LABEL: UDIV_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    movi32 a1, 43691
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    lsri16 a0, a0, 17
; CHECK-NEXT:    rts16
entry:
  %udiv = udiv  i16 %x, 3
  ret i16 %udiv
}

define i8 @UDIV_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: UDIV_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    divu32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %udiv = udiv  i8 %y, %x
  ret i8 %udiv
}

define i8 @UDIV_CHAR_I(i8 %x) {
; CHECK-LABEL: UDIV_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    movi16 a1, 171
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    lsri16 a0, a0, 9
; CHECK-NEXT:    rts16
entry:
  %udiv = udiv  i8 %x, 3
  ret i8 %udiv
}

define i32 @sdivRR(i32 %x, i32 %y) {
; CHECK-LABEL: sdivRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    divs32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %sdiv = sdiv  i32 %y, %x
  ret i32 %sdiv
}

define i32 @sdivRI(i32 %x) {
; CHECK-LABEL: sdivRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi16 a1, 10
; CHECK-NEXT:    divs32 a0, a0, a1
; CHECK-NEXT:    rts16
entry:
  %sdiv = sdiv  i32 %x, 10
  ret i32 %sdiv
}

define i32 @sdivRI_X(i32 %x) {
; CHECK-LABEL: sdivRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi32 a1, 4097
; CHECK-NEXT:    divs32 a0, a0, a1
; CHECK-NEXT:    rts16
entry:
  %sdiv = sdiv  i32 %x, 4097
  ret i32 %sdiv
}

define i16 @SDIV_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: SDIV_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    divs32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %sdiv = sdiv  i16 %y, %x
  ret i16 %sdiv
}

define i16 @SDIV_SHORT_I(i16 %x) {
; CHECK-LABEL: SDIV_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    movi32 a1, 21846
; CHECK-NEXT:    mult16 a0, a1
; CHECK-NEXT:    lsri16 a1, a0, 31
; CHECK-NEXT:    lsri16 a0, a0, 16
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %sdiv = sdiv  i16 %x, 3
  ret i16 %sdiv
}

define i8 @SDIV_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: SDIV_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    divs32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %sdiv = sdiv  i8 %y, %x
  ret i8 %sdiv
}

define i8 @SDIV_CHAR_I(i8 %x) {
; CHECK-LABEL: SDIV_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a0
; CHECK-NEXT:    movi16 a2, 85
; CHECK-NEXT:    mult16 a1, a2
; CHECK-NEXT:    lsri16 a1, a1, 8
; CHECK-NEXT:    subu16 a0, a1, a0
; CHECK-NEXT:    andi32 a1, a0, 128
; CHECK-NEXT:    lsri16 a1, a1, 7
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    asri16 a0, a0, 1
; CHECK-NEXT:    addu16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %sdiv = sdiv  i8 %x, -3
  ret i8 %sdiv
}

define i32 @shlRR(i32 %x, i32 %y) {
; CHECK-LABEL: shlRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsl32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %shl = shl nsw i32 %y, %x
  ret i32 %shl
}

define i32 @shlRI(i32 %x) {
; CHECK-LABEL: shlRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsli16 a0, a0, 10
; CHECK-NEXT:    rts16
entry:
  %shl = shl nsw i32 %x, 10
  ret i32 %shl
}


define i64 @SHL_LONG_I(i64 %x) {
; CHECK-LABEL: SHL_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsri16 a2, a0, 25
; CHECK-NEXT:    lsli16 a1, a1, 7
; CHECK-NEXT:    or16 a1, a2
; CHECK-NEXT:    lsli16 a0, a0, 7
; CHECK-NEXT:    rts16
entry:
  %shl = shl nsw i64 %x, 7
  ret i64 %shl
}

define i16 @SHL_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: SHL_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    lsl32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %shl = shl nsw i16 %y, %x
  ret i16 %shl
}

define i16 @SHL_SHORT_I(i16 %x) {
; CHECK-LABEL: SHL_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsli16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %shl = shl nsw i16 %x, 1
  ret i16 %shl
}

define i8 @SHL_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: SHL_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    lsl32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %shl = shl nsw i8 %y, %x
  ret i8 %shl
}

define i8 @SHL_CHAR_I(i8 %x) {
; CHECK-LABEL: SHL_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsli16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %shl = shl nsw i8 %x, 1
  ret i8 %shl
}

define i32 @andRR(i32 %x, i32 %y) {
; CHECK-LABEL: andRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %and = and  i32 %y, %x
  ret i32 %and
}

define i32 @andRI(i32 %x) {
; CHECK-LABEL: andRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 10
; CHECK-NEXT:    rts16
entry:
  %and = and  i32 %x, 10
  ret i32 %and
}

define i32 @andRI_X(i32 %x) {
; CHECK-LABEL: andRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi32 a1, 4097
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %and = and  i32 %x, 4097
  ret i32 %and
}

define i64 @AND_LONG(i64 %x, i64 %y) {
; CHECK-LABEL: AND_LONG:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    and16 a0, a2
; CHECK-NEXT:    and16 a1, a3
; CHECK-NEXT:    rts16
entry:
  %and = and  i64 %y, %x
  ret i64 %and
}

define i64 @AND_LONG_I(i64 %x) {
; CHECK-LABEL: AND_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    movi16 a1, 0
; CHECK-NEXT:    rts16
entry:
  %and = and  i64 %x, 1
  ret i64 %and
}

define i16 @AND_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: AND_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %and = and  i16 %y, %x
  ret i16 %and
}

define i16 @AND_SHORT_I(i16 %x) {
; CHECK-LABEL: AND_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %and = and  i16 %x, 1
  ret i16 %and
}

define i8 @AND_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: AND_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %and = and  i8 %y, %x
  ret i8 %and
}

define i8 @AND_CHAR_I(i8 %x) {
; CHECK-LABEL: AND_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %and = and  i8 %x, 1
  ret i8 %and
}

define i32 @ashrRR(i32 %x, i32 %y) {
; CHECK-LABEL: ashrRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    asr32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %ashr = ashr  i32 %y, %x
  ret i32 %ashr
}

define i32 @ashrRI(i32 %x) {
; CHECK-LABEL: ashrRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    asri16 a0, a0, 10
; CHECK-NEXT:    rts16
entry:
  %ashr = ashr  i32 %x, 10
  ret i32 %ashr
}


define i64 @ASHR_LONG_I(i64 %x) {
; CHECK-LABEL: ASHR_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsli16 a2, a1, 25
; CHECK-NEXT:    lsri16 a0, a0, 7
; CHECK-NEXT:    or16 a0, a2
; CHECK-NEXT:    asri16 a1, a1, 7
; CHECK-NEXT:    rts16
entry:
  %ashr = ashr  i64 %x, 7
  ret i64 %ashr
}

define i16 @ASHR_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: ASHR_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    asr32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %ashr = ashr  i16 %y, %x
  ret i16 %ashr
}

define i16 @ASHR_SHORT_I(i16 %x) {
; CHECK-LABEL: ASHR_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sexth16 a0, a0
; CHECK-NEXT:    asri16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %ashr = ashr  i16 %x, 1
  ret i16 %ashr
}

define i8 @ASHR_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: ASHR_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    asr32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %ashr = ashr  i8 %y, %x
  ret i8 %ashr
}

define i8 @ASHR_CHAR_I(i8 %x) {
; CHECK-LABEL: ASHR_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    sextb16 a0, a0
; CHECK-NEXT:    asri16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %ashr = ashr  i8 %x, 1
  ret i8 %ashr
}


define i32 @lshrRR(i32 %x, i32 %y) {
; CHECK-LABEL: lshrRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsr32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i32 %y, %x
  ret i32 %lshr
}

define i32 @lshrRI(i32 %x) {
; CHECK-LABEL: lshrRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsri16 a0, a0, 10
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i32 %x, 10
  ret i32 %lshr
}

define i64 @LSHR_LONG_I(i64 %x) {
; CHECK-LABEL: LSHR_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lsli16 a2, a1, 25
; CHECK-NEXT:    lsri16 a0, a0, 7
; CHECK-NEXT:    or16 a0, a2
; CHECK-NEXT:    lsri16 a1, a1, 7
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i64 %x, 7
  ret i64 %lshr
}

define i16 @LSHR_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: LSHR_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zexth16 a1, a1
; CHECK-NEXT:    zexth16 a0, a0
; CHECK-NEXT:    lsr32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i16 %y, %x
  ret i16 %lshr
}

define i16 @LSHR_SHORT_I(i16 %x) {
; CHECK-LABEL: LSHR_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi32 a1, 65534
; CHECK-NEXT:    and16 a0, a1
; CHECK-NEXT:    lsri16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i16 %x, 1
  ret i16 %lshr
}

define i8 @LSHR_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: LSHR_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    zextb16 a1, a1
; CHECK-NEXT:    zextb16 a0, a0
; CHECK-NEXT:    lsr32 a0, a1, a0
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i8 %y, %x
  ret i8 %lshr
}

define i8 @LSHR_CHAR_I(i8 %x) {
; CHECK-LABEL: LSHR_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi32 a0, a0, 254
; CHECK-NEXT:    lsri16 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i8 %x, 1
  ret i8 %lshr
}

define i1 @LSHR_BIT(i1 %x, i1 %y) {
; CHECK-LABEL: LSHR_BIT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    mov16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i1 %y, %x
  ret i1 %lshr
}

define i1 @LSHR_BIT_I(i1 %x) {
; CHECK-LABEL: LSHR_BIT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %lshr = lshr  i1 %x, 1
  ret i1 %lshr
}

define i32 @orRR(i32 %x, i32 %y) {
; CHECK-LABEL: orRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %or = or  i32 %y, %x
  ret i32 %or
}

define i32 @orRI(i32 %x) {
; CHECK-LABEL: orRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori32 a0, a0, 10
; CHECK-NEXT:    rts16
entry:
  %or = or  i32 %x, 10
  ret i32 %or
}

define i32 @orRI_X(i32 %x) {
; CHECK-LABEL: orRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori32 a0, a0, 4097
; CHECK-NEXT:    rts16
entry:
  %or = or  i32 %x, 4097
  ret i32 %or
}

define i64 @OR_LONG(i64 %x, i64 %y) {
; CHECK-LABEL: OR_LONG:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a2
; CHECK-NEXT:    or16 a1, a3
; CHECK-NEXT:    rts16
entry:
  %or = or  i64 %y, %x
  ret i64 %or
}

define i64 @OR_LONG_I(i64 %x) {
; CHECK-LABEL: OR_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %or = or  i64 %x, 1
  ret i64 %or
}

define i16 @OR_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: OR_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %or = or  i16 %y, %x
  ret i16 %or
}

define i16 @OR_SHORT_I(i16 %x) {
; CHECK-LABEL: OR_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %or = or  i16 %x, 1
  ret i16 %or
}

define i8 @OR_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: OR_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    or16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %or = or  i8 %y, %x
  ret i8 %or
}

define i8 @OR_CHAR_I(i8 %x) {
; CHECK-LABEL: OR_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    ori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %or = or  i8 %x, 1
  ret i8 %or
}


define i32 @xorRR(i32 %x, i32 %y) {
; CHECK-LABEL: xorRR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i32 %y, %x
  ret i32 %xor
}

define i32 @xorRI(i32 %x) {
; CHECK-LABEL: xorRI:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 10
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i32 %x, 10
  ret i32 %xor
}

define i32 @xorRI_X(i32 %x) {
; CHECK-LABEL: xorRI_X:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movi32 a1, 4097
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i32 %x, 4097
  ret i32 %xor
}

define i64 @XOR_LONG(i64 %x, i64 %y) {
; CHECK-LABEL: XOR_LONG:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a2
; CHECK-NEXT:    xor16 a1, a3
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i64 %y, %x
  ret i64 %xor
}

define i64 @XOR_LONG_I(i64 %x) {
; CHECK-LABEL: XOR_LONG_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i64 %x, 1
  ret i64 %xor
}

define i16 @XOR_SHORT(i16 %x, i16 %y) {
; CHECK-LABEL: XOR_SHORT:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i16 %y, %x
  ret i16 %xor
}

define i16 @XOR_SHORT_I(i16 %x) {
; CHECK-LABEL: XOR_SHORT_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i16 %x, 1
  ret i16 %xor
}

define i8 @XOR_CHAR(i8 %x, i8 %y) {
; CHECK-LABEL: XOR_CHAR:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xor16 a0, a1
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i8 %y, %x
  ret i8 %xor
}

define i8 @XOR_CHAR_I(i8 %x) {
; CHECK-LABEL: XOR_CHAR_I:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xori32 a0, a0, 1
; CHECK-NEXT:    rts16
entry:
  %xor = xor  i8 %x, 1
  ret i8 %xor
}

; i64 --> i32/i16/i8/i1
define i32 @truncR_i64_0(i64 %x) {
; CHECK-LABEL: truncR_i64_0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i64 %x to i32
  ret i32 %trunc
}

define i16 @truncR_i64_1(i64 %x) {
; CHECK-LABEL: truncR_i64_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i64 %x to i16
  ret i16 %trunc
}

define i8 @truncR_i64_2(i64 %x) {
; CHECK-LABEL: truncR_i64_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i64 %x to i8
  ret i8 %trunc
}

define i1 @truncR_i64_3(i64 %x) {
; CHECK-LABEL: truncR_i64_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i64 %x to i1
  ret i1 %trunc
}


; i32 --> i16/i8/i1
define i16 @truncR_i32_1(i32 %x) {
; CHECK-LABEL: truncR_i32_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i32 %x to i16
  ret i16 %trunc
}

define i8 @truncR_i32_2(i32 %x) {
; CHECK-LABEL: truncR_i32_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i32 %x to i8
  ret i8 %trunc
}

define i1 @truncR_i32_3(i32 %x) {
; CHECK-LABEL: truncR_i32_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i32 %x to i1
  ret i1 %trunc
}

; i16 --> i8/i1
define i8 @truncR_i16_2(i16 %x) {
; CHECK-LABEL: truncR_i16_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i16 %x to i8
  ret i8 %trunc
}

define i1 @truncR_i16_3(i16 %x) {
; CHECK-LABEL: truncR_i16_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i16 %x to i1
  ret i1 %trunc
}


;i8 --> i1
define i1 @truncR_i8_3(i8 %x) {
; CHECK-LABEL: truncR_i8_3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    rts16
entry:
  %trunc = trunc i8 %x to i1
  ret i1 %trunc
}
