; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -O0 -mtriple=mipsel-linux-gnu -global-isel -mcpu=mips32r5 -mattr=+msa,+fp64,+nan2008 -stop-after=legalizer -verify-machineinstrs %s -o - | FileCheck %s -check-prefixes=P5600

; Check there are no COPY instructions surrounding ADDVI_W instruction.
; All virtual registers were created with createGenericVirtualRegister
; which sets RegClassOrRegBank in VRegInfo.
; Constraining register classes when G_INTRINSIC intrinsic(@llvm.mips.addvi.w)
; gets selected into ADDVI_W works as expected.
; Check that setRegClassOrRegBank.mir has same output.

declare <4 x i32> @llvm.mips.addvi.w(<4 x i32>, i32 immarg)
define void @add_v4i32_builtin_imm(<4 x i32>* %a, <4 x i32>* %c) {
  ; P5600-LABEL: name: add_v4i32_builtin_imm
  ; P5600: bb.1.entry:
  ; P5600:   liveins: $a0, $a1
  ; P5600:   [[COPY:%[0-9]+]]:_(p0) = COPY $a0
  ; P5600:   [[COPY1:%[0-9]+]]:_(p0) = COPY $a1
  ; P5600:   [[LOAD:%[0-9]+]]:msa128w(<4 x s32>) = G_LOAD [[COPY]](p0) :: (load (<4 x s32>) from %ir.a)
  ; P5600:   [[ADDVI_W:%[0-9]+]]:msa128w(<4 x s32>) = ADDVI_W [[LOAD]](<4 x s32>), 25
  ; P5600:   G_STORE [[ADDVI_W]](<4 x s32>), [[COPY1]](p0) :: (store (<4 x s32>) into %ir.c)
  ; P5600:   RetRA
entry:
  %0 = load <4 x i32>, <4 x i32>* %a, align 16
  %1 = tail call <4 x i32> @llvm.mips.addvi.w(<4 x i32> %0, i32 25)
  store <4 x i32> %1, <4 x i32>* %c, align 16
  ret void
}
