; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv2_sf | FileCheck %s --check-prefix=CHECK-SF
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv3_sf | FileCheck %s --check-prefix=CHECK-SF2


define float @faddRR(float %x, float %y) {
;
; CHECK-SF-LABEL: faddRR:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fadds vr0, vr1, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: faddRR:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fadd.32 vr0, vr1, vr0
; CHECK-SF2-NEXT:    rts16

entry:
  %fadd = fadd  float %y, %x
  ret float %fadd
}

define float @faddRI(float %x) {
;
; CHECK-SF-LABEL: faddRI:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fadds vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: faddRI:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fadd.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16

entry:
  %fadd = fadd  float %x, 10.0
  ret float %fadd
}

define float @faddRI_X(float %x) {
;
; CHECK-SF-LABEL: faddRI_X:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 17792
; CHECK-SF-NEXT:    ori32 a0, a0, 2048
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fadds vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: faddRI_X:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 17792
; CHECK-SF2-NEXT:    ori32 a0, a0, 2048
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fadd.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16

entry:
  %fadd = fadd  float %x, 4097.0
  ret float %fadd
}

define float @fsubRR(float %x, float %y) {
;
; CHECK-SF-LABEL: fsubRR:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fsubs vr0, vr1, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fsubRR:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fsub.32 vr0, vr1, vr0
; CHECK-SF2-NEXT:    rts16


entry:
  %fsub = fsub  float %y, %x
  ret float %fsub
}

define float @fsubRI(float %x) {
;
; CHECK-SF-LABEL: fsubRI:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 49440
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fadds vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fsubRI:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 49440
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fadd.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16

entry:
  %fsub = fsub  float %x, 10.0
  ret float %fsub
}

define float @fsubRI_X(float %x) {
;
; CHECK-SF-LABEL: fsubRI_X:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 50560
; CHECK-SF-NEXT:    ori32 a0, a0, 2048
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fadds vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fsubRI_X:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 50560
; CHECK-SF2-NEXT:    ori32 a0, a0, 2048
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fadd.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16

entry:
  %fsub = fsub  float %x, 4097.0
  ret float %fsub
}

define float @fmulRR(float %x, float %y) {
;
; CHECK-SF-LABEL: fmulRR:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fmuls vr0, vr1, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fmulRR:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fmul.32 vr0, vr1, vr0
; CHECK-SF2-NEXT:    rts16

entry:
  %fmul = fmul  float %y, %x
  ret float %fmul
}

define float @fmulRI(float %x) {
;
; CHECK-SF-LABEL: fmulRI:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fmuls vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fmulRI:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fmul.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16

entry:
  %fmul = fmul  float %x, 10.0
  ret float %fmul
}

define float @fmulRI_X(float %x) {
;
; CHECK-SF-LABEL: fmulRI_X:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 17792
; CHECK-SF-NEXT:    ori32 a0, a0, 2048
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fmuls vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fmulRI_X:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 17792
; CHECK-SF2-NEXT:    ori32 a0, a0, 2048
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fmul.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16

entry:
  %fmul = fmul  float %x, 4097.0
  ret float %fmul
}

define float @fdivRR(float %x, float %y) {
;
; CHECK-SF-LABEL: fdivRR:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fdivs vr0, vr1, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fdivRR:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fdiv.32 vr0, vr1, vr0
; CHECK-SF2-NEXT:    rts16


entry:
  %fdiv = fdiv  float %y, %x
  ret float %fdiv
}

define float @fdivRI(float %x) {
;
; CHECK-SF-LABEL: fdivRI:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fdivs vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fdivRI:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fdiv.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16


entry:
  %fdiv = fdiv  float %x, 10.0
  ret float %fdiv
}

define float @fdivRI_X(float %x) {
;
; CHECK-SF-LABEL: fdivRI_X:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 17792
; CHECK-SF-NEXT:    ori32 a0, a0, 2048
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fdivs vr0, vr0, vr1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fdivRI_X:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 17792
; CHECK-SF2-NEXT:    ori32 a0, a0, 2048
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fdiv.32 vr0, vr0, vr1
; CHECK-SF2-NEXT:    rts16

entry:
  %fdiv = fdiv  float %x, 4097.0
  ret float %fdiv
}

define float @fnegRR(float %x) {
;
; CHECK-SF-LABEL: fnegRR:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fnegs vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fnegRR:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fneg.32 vr0, vr0
; CHECK-SF2-NEXT:    rts16

entry:
  %fneg = fneg  float %x
  ret float %fneg
}
