/* -*- Mode: vala; tab-width: 4; intend-tabs-mode: t -*- */
/* alm
 *
 * Copyright (C) 2013 Jeremy Bicha <jbicha@ubuntu.com>
 *
 * alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;

namespace Alm {

	public class SecurityWidget : Gtk.Box {

		private GLib.Settings power_settings;
		private GLib.Settings screensaver_settings;

		public SecurityWidget () {
			Object (orientation: Orientation.VERTICAL);
			this.spacing = 5;
			this.set_border_width(12);

			power_settings = new GLib.Settings ("org.gnome.settings-daemon.plugins.power");
			screensaver_settings = new GLib.Settings ("org.gnome.desktop.screensaver");

			this.set_up_ui ();
		}

		private void set_up_ui () {

			var liststore_delay = new ListStore (2, typeof (string), typeof (int));
			TreeIter iter;
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "1 second", 1, 0);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "30 seconds", 1, 30);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "1 minute", 1, 60);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "2 minutes", 1, 120);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "3 minutes", 1, 180);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "5 minutes", 1, 300);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "10 minutes", 1, 600);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "30 minutes", 1, 1800);
			liststore_delay.append (out iter);
			liststore_delay.set (iter, 0, "1 hour", 1, 3600);

			var grid = new Grid();
			grid.set_halign(Align.START);
			grid.set_valign(Align.START);
			grid.set_margin_top(25);
			grid.set_margin_left(25);
			grid.set_column_spacing(25);
			grid.set_row_spacing(5);
			grid.set_row_homogeneous(true);
			this.add(grid);

			var list_focus = new GLib.List<Widget> ();

			var header = new Label("");
			header.set_markup("<b>%s</b>".printf(_("Require my password when:")));
			grid.attach(header, 0, 0, 1, 1);

			var checkbox_suspend = new CheckButton.with_mnemonic (_("_Waking from suspend"));
			screensaver_settings.bind ("ubuntu-lock-on-suspend", checkbox_suspend, "active", SettingsBindFlags.DEFAULT);
			list_focus.append(checkbox_suspend);
			grid.attach(checkbox_suspend, 0, 1, 1, 1);

			var checkbox_screensaver = new CheckButton.with_mnemonic (_("_Returning from blank screen"));
			screensaver_settings.bind ("lock-enabled", checkbox_screensaver, "active", SettingsBindFlags.DEFAULT);
			list_focus.append(checkbox_screensaver);
			grid.attach(checkbox_screensaver, 0, 2, 1, 1);

			var label_combo_delay = new Label(null);
			label_combo_delay.set_markup_with_mnemonic(_("_if screen has been blank for"));
			label_combo_delay.set_margin_left(18);
			grid.attach(label_combo_delay, 0, 3, 1, 1);

			var combo_delay = new ComboBox.with_model(liststore_delay);
			combo_delay.changed.connect(set_delay_cb);
			label_combo_delay.set_mnemonic_widget(combo_delay);
			var cell = new CellRendererText();
			combo_delay.pack_start(cell, false);
			combo_delay.add_attribute(cell, "text", 0);
			list_focus.append(combo_delay);
			screensaver_settings.changed["lock-enabled"].connect (() => {
				combo_delay.sensitive = screensaver_settings.get_boolean("lock-enabled");
			});
			combo_delay.sensitive = screensaver_settings.get_boolean("lock-enabled");
			screensaver_settings.changed["lock-delay"].connect (() => {
				get_delay_cb(combo_delay);
			});
			get_delay_cb(combo_delay);
			grid.attach(combo_delay, 1, 3, 1, 1);

			var link_password = new Gtk.LinkButton (_("Password Settings"));
			link_password.activate_link.connect (() => {
				try {
					Process.spawn_command_line_async ("gnome-control-center user-accounts");
				} catch (SpawnError e) {
					warning ("%s", e.message);
				}
				return true;
			});
			link_password.set_halign(Align.START);
			list_focus.append(link_password);
			grid.attach(link_password, 2, 0, 1, 1);

			var link_power = new Gtk.LinkButton(_("Power Settings"));
			link_power.activate_link.connect (() => {
				try {
					Process.spawn_command_line_async ("gnome-control-center power");
				} catch (SpawnError e) {
					warning ("%s", e.message);
				}
				return true;
			});
			link_power.set_halign(Align.START);
			list_focus.append(link_power);
			grid.attach(link_power, 2, 1, 1, 1);

			grid.set_focus_chain(list_focus);

		}

		private void set_delay_cb (Gtk.ComboBox combo)
		{
			uint seconds;
			TreeIter iter;
			combo.get_active_iter(out iter);
			combo.model.get(iter, 1, out seconds);
			screensaver_settings.set_uint("lock-delay", seconds);
		}

		private void get_delay_cb (Gtk.ComboBox combo)
		{
			/* try to make the UI match the lock setting */
			int i = 0;
			int value_prev = 0;
			int value_tmp = 0;
			TreeModel model = combo.get_model();
			TreeIter iter;
			model.get_iter_first(out iter);
			var value = screensaver_settings.get_uint("lock-delay");
			do {
				model.get(iter, 1, out value_tmp);
				if (value == value_tmp ||
					(value_tmp > value_prev && value < value_tmp))
				{
					combo.set_active_iter(iter);
					return;
				}
				value_prev = value_tmp;
				i++;
			} while (model.iter_next(ref iter));
			combo.set_active(i - 1);
		}

	}
}
