; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=verde < %s | FileCheck -enable-var-scope -check-prefixes=SI,GCN %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -enable-var-scope -check-prefixes=VI,GCN %s

define amdgpu_kernel void @xor_v2i32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: xor_v2i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[12:15], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v1, v3, v1
; SI-NEXT:    v_xor_b32_e32 v0, v2, v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: xor_v2i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v1, v1, v3
; VI-NEXT:    v_xor_b32_e32 v0, v0, v2
; VI-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; VI-NEXT:    s_endpgm
  %a = load <2 x i32>, ptr addrspace(1) %in0
  %b = load <2 x i32>, ptr addrspace(1) %in1
  %result = xor <2 x i32> %a, %b
  store <2 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @xor_v4i32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: xor_v4i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx4 v[4:7], off, s[12:15], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v3, v7, v3
; SI-NEXT:    v_xor_b32_e32 v2, v6, v2
; SI-NEXT:    v_xor_b32_e32 v1, v5, v1
; SI-NEXT:    v_xor_b32_e32 v0, v4, v0
; SI-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: xor_v4i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v4, s4
; VI-NEXT:    v_mov_b32_e32 v5, s5
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; VI-NEXT:    v_mov_b32_e32 v8, s0
; VI-NEXT:    v_mov_b32_e32 v9, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v3, v3, v7
; VI-NEXT:    v_xor_b32_e32 v2, v2, v6
; VI-NEXT:    v_xor_b32_e32 v1, v1, v5
; VI-NEXT:    v_xor_b32_e32 v0, v0, v4
; VI-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; VI-NEXT:    s_endpgm
  %a = load <4 x i32>, ptr addrspace(1) %in0
  %b = load <4 x i32>, ptr addrspace(1) %in1
  %result = xor <4 x i32> %a, %b
  store <4 x i32> %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @xor_i1(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: xor_i1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    buffer_load_dword v1, off, s[12:15], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_le_f32_e32 vcc, 1.0, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cmp_le_f32_e64 s[0:1], 0, v1
; SI-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; SI-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: xor_i1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    flat_load_dword v2, v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cmp_le_f32_e32 vcc, 0, v4
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cmp_le_f32_e64 s[0:1], 1.0, v2
; VI-NEXT:    s_xor_b64 vcc, vcc, s[0:1]
; VI-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %a = load float, ptr addrspace(1) %in0
  %b = load float, ptr addrspace(1) %in1
  %acmp = fcmp oge float %a, 0.000000e+00
  %bcmp = fcmp oge float %b, 1.000000e+00
  %xor = xor i1 %acmp, %bcmp
  %result = select i1 %xor, float %a, float %b
  store float %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_xor_i1(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: v_xor_i1:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    buffer_load_ubyte v0, off, s[12:15], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_load_ubyte v1, off, s[8:11], 0 glc
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_xor_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 1, v0
; SI-NEXT:    buffer_store_byte v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: v_xor_i1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    flat_load_ubyte v4, v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_load_ubyte v2, v[2:3] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_xor_b32_e32 v2, v4, v2
; VI-NEXT:    v_and_b32_e32 v2, 1, v2
; VI-NEXT:    flat_store_byte v[0:1], v2
; VI-NEXT:    s_endpgm
  %a = load volatile i1, ptr addrspace(1) %in0
  %b = load volatile i1, ptr addrspace(1) %in1
  %xor = xor i1 %a, %b
  store i1 %xor, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @vector_xor_i32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: vector_xor_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    buffer_load_dword v0, off, s[12:15], 0
; SI-NEXT:    buffer_load_dword v1, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, v0, v1
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: vector_xor_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    flat_load_dword v2, v[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v2, v4, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %a = load i32, ptr addrspace(1) %in0
  %b = load i32, ptr addrspace(1) %in1
  %result = xor i32 %a, %b
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @scalar_xor_i32(ptr addrspace(1) %out, i32 %a, i32 %b) {
; SI-LABEL: scalar_xor_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_xor_b32 s0, s2, s3
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_xor_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_xor_b32 s2, s2, s3
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %result = xor i32 %a, %b
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @scalar_not_i32(ptr addrspace(1) %out, i32 %a) {
; SI-LABEL: scalar_not_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dword s6, s[4:5], 0xb
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_not_b32 s4, s6
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_not_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_not_b32 s2, s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %result = xor i32 %a, -1
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @vector_not_i32(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: vector_not_i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_not_b32_e32 v0, v0
; SI-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: vector_not_i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_load_dword v2, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_not_b32_e32 v2, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
  %a = load i32, ptr addrspace(1) %in0
  %b = load i32, ptr addrspace(1) %in1
  %result = xor i32 %a, -1
  store i32 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @vector_xor_i64(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: vector_xor_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    s_mov_b32 s14, s6
; SI-NEXT:    s_mov_b32 s15, s7
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    buffer_load_dwordx2 v[2:3], off, s[12:15], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, v2, v0
; SI-NEXT:    v_xor_b32_e32 v1, v3, v1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: vector_xor_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v3, s5
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    flat_load_dwordx2 v[2:3], v[2:3]
; VI-NEXT:    v_mov_b32_e32 v4, s0
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v0, v0, v2
; VI-NEXT:    v_xor_b32_e32 v1, v1, v3
; VI-NEXT:    flat_store_dwordx2 v[4:5], v[0:1]
; VI-NEXT:    s_endpgm
  %a = load i64, ptr addrspace(1) %in0
  %b = load i64, ptr addrspace(1) %in1
  %result = xor i64 %a, %b
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @scalar_xor_i64(ptr addrspace(1) %out, i64 %a, i64 %b) {
; SI-LABEL: scalar_xor_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0xd
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_xor_b64 s[0:1], s[2:3], s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_xor_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x34
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_xor_b64 s[0:1], s[2:3], s[4:5]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
  %result = xor i64 %a, %b
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @scalar_not_i64(ptr addrspace(1) %out, i64 %a) {
; SI-LABEL: scalar_not_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_not_b64 s[0:1], s[2:3]
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_not_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_not_b64 s[0:1], s[2:3]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
  %result = xor i64 %a, -1
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @vector_not_i64(ptr addrspace(1) %out, ptr addrspace(1) %in0, ptr addrspace(1) %in1) {
; SI-LABEL: vector_not_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_not_b32_e32 v0, v0
; SI-NEXT:    v_not_b32_e32 v1, v1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: vector_not_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_not_b32_e32 v0, v0
; VI-NEXT:    v_not_b32_e32 v1, v1
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
  %a = load i64, ptr addrspace(1) %in0
  %b = load i64, ptr addrspace(1) %in1
  %result = xor i64 %a, -1
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @xor_cf(ptr addrspace(1) %out, ptr addrspace(1) %in, i64 %a, i64 %b) {
; SI-LABEL: xor_cf:
; SI:       ; %bb.0: ; %entry
; SI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x9
; SI-NEXT:    s_mov_b64 s[8:9], 0
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u64_e64 s[10:11], s[4:5], 0
; SI-NEXT:    s_and_b64 vcc, exec, s[10:11]
; SI-NEXT:    s_cbranch_vccz .LBB12_4
; SI-NEXT:  ; %bb.1: ; %else
; SI-NEXT:    s_mov_b32 s15, 0xf000
; SI-NEXT:    s_mov_b32 s14, -1
; SI-NEXT:    s_mov_b32 s12, s2
; SI-NEXT:    s_mov_b32 s13, s3
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[12:15], 0
; SI-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; SI-NEXT:    s_cbranch_vccnz .LBB12_3
; SI-NEXT:  .LBB12_2: ; %if
; SI-NEXT:    s_xor_b64 s[2:3], s[4:5], s[6:7]
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s2
; SI-NEXT:    v_mov_b32_e32 v1, s3
; SI-NEXT:  .LBB12_3: ; %endif
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
; SI-NEXT:  .LBB12_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; SI-NEXT:    s_branch .LBB12_2
;
; VI-LABEL: xor_cf:
; VI:       ; %bb.0: ; %entry
; VI-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x24
; VI-NEXT:    s_mov_b64 s[8:9], 0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u64 s[4:5], 0
; VI-NEXT:    s_cbranch_scc0 .LBB12_4
; VI-NEXT:  ; %bb.1: ; %else
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_andn2_b64 vcc, exec, s[8:9]
; VI-NEXT:    s_cbranch_vccnz .LBB12_3
; VI-NEXT:  .LBB12_2: ; %if
; VI-NEXT:    s_xor_b64 s[2:3], s[4:5], s[6:7]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:  .LBB12_3: ; %endif
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
; VI-NEXT:  .LBB12_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1
; VI-NEXT:    s_branch .LBB12_2
entry:
  %0 = icmp eq i64 %a, 0
  br i1 %0, label %if, label %else

if:
  %1 = xor i64 %a, %b
  br label %endif

else:
  %2 = load i64, ptr addrspace(1) %in
  br label %endif

endif:
  %3 = phi i64 [%1, %if], [%2, %else]
  store i64 %3, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @scalar_xor_literal_i64(ptr addrspace(1) %out, [8 x i32], i64 %a) {
; SI-LABEL: scalar_xor_literal_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_xor_b32 s4, s7, 0xf237b
; SI-NEXT:    s_xor_b32 s5, s6, 0x3039
; SI-NEXT:    v_mov_b32_e32 v0, s5
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_xor_literal_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_xor_b32 s1, s1, 0xf237b
; VI-NEXT:    s_xor_b32 s0, s0, 0x3039
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
  %or = xor i64 %a, 4261135838621753
  store i64 %or, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @scalar_xor_literal_multi_use_i64(ptr addrspace(1) %out, [8 x i32], i64 %a, i64 %b) {
; SI-LABEL: scalar_xor_literal_multi_use_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_load_dwordx4 s[4:7], s[4:5], 0x13
; SI-NEXT:    s_movk_i32 s8, 0x3039
; SI-NEXT:    s_mov_b32 s9, 0xf237b
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_xor_b64 s[4:5], s[4:5], s[8:9]
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_add_u32 s0, s6, 0x3039
; SI-NEXT:    s_addc_u32 s1, s7, 0xf237b
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v0, s0
; SI-NEXT:    v_mov_b32_e32 v1, s1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_xor_literal_multi_use_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; VI-NEXT:    s_movk_i32 s6, 0x3039
; VI-NEXT:    s_mov_b32 s7, 0xf237b
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_xor_b64 s[0:1], s[0:1], s[6:7]
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    s_add_u32 s0, s2, 0x3039
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_addc_u32 s1, s3, 0xf237b
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_endpgm
  %or = xor i64 %a, 4261135838621753
  store i64 %or, ptr addrspace(1) %out

  %foo = add i64 %b, 4261135838621753
  store volatile i64 %foo, ptr addrspace(1) poison
  ret void
}

define amdgpu_kernel void @scalar_xor_inline_imm_i64(ptr addrspace(1) %out, [8 x i32], i64 %a) {
; SI-LABEL: scalar_xor_inline_imm_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_xor_b32 s4, s6, 63
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_xor_inline_imm_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_xor_b32 s0, s0, 63
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
  %or = xor i64 %a, 63
  store i64 %or, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @scalar_xor_neg_inline_imm_i64(ptr addrspace(1) %out, [8 x i32], i64 %a) {
; SI-LABEL: scalar_xor_neg_inline_imm_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x13
; SI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s3, 0xf000
; SI-NEXT:    s_mov_b32 s2, -1
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_xor_b64 s[4:5], s[6:7], -8
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: scalar_xor_neg_inline_imm_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x4c
; VI-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_xor_b64 s[0:1], s[0:1], -8
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
  %or = xor i64 %a, -8
  store i64 %or, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @vector_xor_i64_neg_inline_imm(ptr addrspace(1) %out, ptr addrspace(1) %a, ptr addrspace(1) %b) {
; SI-LABEL: vector_xor_i64_neg_inline_imm:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v0, -8, v0
; SI-NEXT:    v_xor_b32_e32 v1, -1, v1
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: vector_xor_i64_neg_inline_imm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v0, -8, v0
; VI-NEXT:    v_xor_b32_e32 v1, -1, v1
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
  %loada = load i64, ptr addrspace(1) %a, align 8
  %or = xor i64 %loada, -8
  store i64 %or, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @vector_xor_literal_i64(ptr addrspace(1) %out, ptr addrspace(1) %a, ptr addrspace(1) %b) {
; SI-LABEL: vector_xor_literal_i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NEXT:    s_mov_b32 s7, 0xf000
; SI-NEXT:    s_mov_b32 s6, -1
; SI-NEXT:    s_mov_b32 s10, s6
; SI-NEXT:    s_mov_b32 s11, s7
; SI-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NEXT:    s_mov_b32 s8, s2
; SI-NEXT:    s_mov_b32 s9, s3
; SI-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NEXT:    s_mov_b32 s4, s0
; SI-NEXT:    s_mov_b32 s5, s1
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_xor_b32_e32 v1, 0x146f, v1
; SI-NEXT:    v_xor_b32_e32 v0, 0xdf77987f, v0
; SI-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NEXT:    s_endpgm
;
; VI-LABEL: vector_xor_literal_i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s2
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_xor_b32_e32 v1, 0x146f, v1
; VI-NEXT:    v_xor_b32_e32 v0, 0xdf77987f, v0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
  %loada = load i64, ptr addrspace(1) %a, align 8
  %or = xor i64 %loada, 22470723082367
  store i64 %or, ptr addrspace(1) %out
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
