; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals none --version 5
; RUN: opt -p loop-unroll -mcpu=neoverse-v1 -S %s | FileCheck --check-prefixes=COMMON,UNROLL4 %s
; RUN: opt -p loop-unroll -mcpu=generic -S %s | FileCheck --check-prefixes=COMMON,UNROLL4 %s
; RUN: opt -p loop-unroll -mcpu=generic -unroll-runtime-multi-exit=false -S %s | FileCheck --check-prefixes=COMMON,NOUNROLL %s

target triple = "aarch64-linux-gnu"

define i1 @multi_2_exiting_find_i8_loop_same_exit(ptr %vec, i8 %tgt) {
; UNROLL4-LABEL: define i1 @multi_2_exiting_find_i8_loop_same_exit(
; UNROLL4-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0:[0-9]+]] {
; UNROLL4-NEXT:  [[ENTRY:.*]]:
; UNROLL4-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; UNROLL4-NEXT:    [[START2:%.*]] = ptrtoint ptr [[START]] to i64
; UNROLL4-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; UNROLL4-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; UNROLL4-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; UNROLL4-NEXT:    [[TMP0:%.*]] = sub i64 [[END1]], [[START2]]
; UNROLL4-NEXT:    [[TMP1:%.*]] = freeze i64 [[TMP0]]
; UNROLL4-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], -1
; UNROLL4-NEXT:    [[XTRAITER:%.*]] = and i64 [[TMP1]], 3
; UNROLL4-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i64 [[XTRAITER]], 0
; UNROLL4-NEXT:    br i1 [[LCMP_MOD]], label %[[LOOP_HEADER_PROL_PREHEADER:.*]], label %[[LOOP_HEADER_PROL_LOOPEXIT:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL_PREHEADER]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_PROL:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL:%.*]], %[[LOOP_LATCH_PROL:.*]] ], [ [[START]], %[[LOOP_HEADER_PROL_PREHEADER]] ]
; UNROLL4-NEXT:    [[PROL_ITER:%.*]] = phi i64 [ 0, %[[LOOP_HEADER_PROL_PREHEADER]] ], [ [[PROL_ITER_NEXT:%.*]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    [[L_PROL:%.*]] = load i8, ptr [[PTR_IV_PROL]], align 8
; UNROLL4-NEXT:    [[C_1_PROL:%.*]] = icmp eq i8 [[L_PROL]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_PROL]], label %[[EXIT_UNR_LCSSA_LOOPEXIT3:.*]], label %[[LOOP_LATCH_PROL]]
; UNROLL4:       [[LOOP_LATCH_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_PROL]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_PROL]], i64 1
; UNROLL4-NEXT:    [[C_2_PROL:%.*]] = icmp eq ptr [[PTR_IV_NEXT_PROL]], [[END]]
; UNROLL4-NEXT:    [[PROL_ITER_NEXT]] = add i64 [[PROL_ITER]], 1
; UNROLL4-NEXT:    [[PROL_ITER_CMP:%.*]] = icmp ne i64 [[PROL_ITER_NEXT]], [[XTRAITER]]
; UNROLL4-NEXT:    br i1 [[PROL_ITER_CMP]], label %[[LOOP_HEADER_PROL]], label %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA:.*]], !llvm.loop [[LOOP0:![0-9]+]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    [[RES_UNR_PH:%.*]] = phi ptr [ [[END]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    [[PTR_IV_UNR_PH:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL_LOOPEXIT]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT]]:
; UNROLL4-NEXT:    [[RES_UNR:%.*]] = phi ptr [ poison, %[[ENTRY]] ], [ [[RES_UNR_PH]], %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    [[PTR_IV_UNR:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[PTR_IV_UNR_PH]], %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    [[TMP3:%.*]] = icmp ult i64 [[TMP2]], 3
; UNROLL4-NEXT:    br i1 [[TMP3]], label %[[EXIT:.*]], label %[[ENTRY_NEW:.*]]
; UNROLL4:       [[ENTRY_NEW]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER:.*]]
; UNROLL4:       [[LOOP_HEADER]]:
; UNROLL4-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_UNR]], %[[ENTRY_NEW]] ], [ [[PTR_IV_NEXT_3:%.*]], %[[LOOP_LATCH_3:.*]] ]
; UNROLL4-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; UNROLL4-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1]], label %[[EXIT_UNR_LCSSA_LOOPEXIT:.*]], label %[[LOOP_LATCH:.*]]
; UNROLL4:       [[LOOP_LATCH]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; UNROLL4-NEXT:    [[L_1:%.*]] = load i8, ptr [[PTR_IV_NEXT]], align 8
; UNROLL4-NEXT:    [[C_1_1:%.*]] = icmp eq i8 [[L_1]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_1]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_LATCH_1:.*]]
; UNROLL4:       [[LOOP_LATCH_1]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_1:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT]], i64 1
; UNROLL4-NEXT:    [[L_2:%.*]] = load i8, ptr [[PTR_IV_NEXT_1]], align 8
; UNROLL4-NEXT:    [[C_1_2:%.*]] = icmp eq i8 [[L_2]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_2]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_LATCH_2:.*]]
; UNROLL4:       [[LOOP_LATCH_2]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_2:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_1]], i64 1
; UNROLL4-NEXT:    [[L_3:%.*]] = load i8, ptr [[PTR_IV_NEXT_2]], align 8
; UNROLL4-NEXT:    [[C_1_3:%.*]] = icmp eq i8 [[L_3]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_3]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_LATCH_3]]
; UNROLL4:       [[LOOP_LATCH_3]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_3]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_2]], i64 1
; UNROLL4-NEXT:    [[C_2_3:%.*]] = icmp eq ptr [[PTR_IV_NEXT_3]], [[END]]
; UNROLL4-NEXT:    br i1 [[C_2_3]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_HEADER]]
; UNROLL4:       [[EXIT_UNR_LCSSA_LOOPEXIT]]:
; UNROLL4-NEXT:    [[RES_PH_PH:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[PTR_IV_NEXT]], %[[LOOP_LATCH]] ], [ [[PTR_IV_NEXT_1]], %[[LOOP_LATCH_1]] ], [ [[PTR_IV_NEXT_2]], %[[LOOP_LATCH_2]] ], [ [[END]], %[[LOOP_LATCH_3]] ]
; UNROLL4-NEXT:    br label %[[EXIT_UNR_LCSSA:.*]]
; UNROLL4:       [[EXIT_UNR_LCSSA_LOOPEXIT3]]:
; UNROLL4-NEXT:    [[RES_PH_PH4:%.*]] = phi ptr [ [[PTR_IV_PROL]], %[[LOOP_HEADER_PROL]] ]
; UNROLL4-NEXT:    br label %[[EXIT_UNR_LCSSA]]
; UNROLL4:       [[EXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    [[RES_PH:%.*]] = phi ptr [ [[RES_PH_PH]], %[[EXIT_UNR_LCSSA_LOOPEXIT]] ], [ [[RES_PH_PH4]], %[[EXIT_UNR_LCSSA_LOOPEXIT3]] ]
; UNROLL4-NEXT:    br label %[[EXIT]]
; UNROLL4:       [[EXIT]]:
; UNROLL4-NEXT:    [[RES:%.*]] = phi ptr [ [[RES_UNR]], %[[LOOP_HEADER_PROL_LOOPEXIT]] ], [ [[RES_PH]], %[[EXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; UNROLL4-NEXT:    ret i1 [[C_3]]
;
; NOUNROLL-LABEL: define i1 @multi_2_exiting_find_i8_loop_same_exit(
; NOUNROLL-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0:[0-9]+]] {
; NOUNROLL-NEXT:  [[ENTRY:.*]]:
; NOUNROLL-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; NOUNROLL-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; NOUNROLL-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; NOUNROLL-NEXT:    br label %[[LOOP_HEADER:.*]]
; NOUNROLL:       [[LOOP_HEADER]]:
; NOUNROLL-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; NOUNROLL-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; NOUNROLL-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; NOUNROLL-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; NOUNROLL:       [[LOOP_LATCH]]:
; NOUNROLL-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; NOUNROLL-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; NOUNROLL-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; NOUNROLL:       [[EXIT]]:
; NOUNROLL-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; NOUNROLL-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; NOUNROLL-NEXT:    ret i1 [[C_3]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  %c.1 = icmp eq i8 %l, %tgt
  br i1 %c.1, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3
}


define i1 @multi_2_exiting_find_i8_loop_diff_exit(ptr %vec, i8 %tgt) {
; UNROLL4-LABEL: define i1 @multi_2_exiting_find_i8_loop_diff_exit(
; UNROLL4-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0]] {
; UNROLL4-NEXT:  [[ENTRY:.*]]:
; UNROLL4-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; UNROLL4-NEXT:    [[START2:%.*]] = ptrtoint ptr [[START]] to i64
; UNROLL4-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; UNROLL4-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; UNROLL4-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; UNROLL4-NEXT:    [[TMP0:%.*]] = sub i64 [[END1]], [[START2]]
; UNROLL4-NEXT:    [[TMP1:%.*]] = freeze i64 [[TMP0]]
; UNROLL4-NEXT:    [[TMP2:%.*]] = add i64 [[TMP1]], -1
; UNROLL4-NEXT:    [[XTRAITER:%.*]] = and i64 [[TMP1]], 3
; UNROLL4-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i64 [[XTRAITER]], 0
; UNROLL4-NEXT:    br i1 [[LCMP_MOD]], label %[[LOOP_HEADER_PROL_PREHEADER:.*]], label %[[LOOP_HEADER_PROL_LOOPEXIT:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL_PREHEADER]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_PROL:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL:%.*]], %[[LOOP_LATCH_PROL:.*]] ], [ [[START]], %[[LOOP_HEADER_PROL_PREHEADER]] ]
; UNROLL4-NEXT:    [[PROL_ITER:%.*]] = phi i64 [ 0, %[[LOOP_HEADER_PROL_PREHEADER]] ], [ [[PROL_ITER_NEXT:%.*]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    [[L_PROL:%.*]] = load i8, ptr [[PTR_IV_PROL]], align 8
; UNROLL4-NEXT:    [[C_1_PROL:%.*]] = icmp eq i8 [[L_PROL]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_PROL]], label %[[EARLY_EXIT_LOOPEXIT3:.*]], label %[[LOOP_LATCH_PROL]]
; UNROLL4:       [[LOOP_LATCH_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_PROL]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_PROL]], i64 1
; UNROLL4-NEXT:    [[C_2_PROL:%.*]] = icmp eq ptr [[PTR_IV_NEXT_PROL]], [[END]]
; UNROLL4-NEXT:    [[PROL_ITER_NEXT]] = add i64 [[PROL_ITER]], 1
; UNROLL4-NEXT:    [[PROL_ITER_CMP:%.*]] = icmp ne i64 [[PROL_ITER_NEXT]], [[XTRAITER]]
; UNROLL4-NEXT:    br i1 [[PROL_ITER_CMP]], label %[[LOOP_HEADER_PROL]], label %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA:.*]], !llvm.loop [[LOOP2:![0-9]+]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    [[PTR_IV_UNR_PH:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL_LOOPEXIT]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT]]:
; UNROLL4-NEXT:    [[PTR_IV_UNR:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[PTR_IV_UNR_PH]], %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    [[TMP3:%.*]] = icmp ult i64 [[TMP2]], 3
; UNROLL4-NEXT:    br i1 [[TMP3]], label %[[LATCH_EXIT:.*]], label %[[ENTRY_NEW:.*]]
; UNROLL4:       [[ENTRY_NEW]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER:.*]]
; UNROLL4:       [[LOOP_HEADER]]:
; UNROLL4-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_UNR]], %[[ENTRY_NEW]] ], [ [[PTR_IV_NEXT_3:%.*]], %[[LOOP_LATCH_3:.*]] ]
; UNROLL4-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; UNROLL4-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1]], label %[[EARLY_EXIT_LOOPEXIT:.*]], label %[[LOOP_LATCH:.*]]
; UNROLL4:       [[LOOP_LATCH]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; UNROLL4-NEXT:    [[L_1:%.*]] = load i8, ptr [[PTR_IV_NEXT]], align 8
; UNROLL4-NEXT:    [[C_1_1:%.*]] = icmp eq i8 [[L_1]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_1]], label %[[EARLY_EXIT_LOOPEXIT]], label %[[LOOP_LATCH_1:.*]]
; UNROLL4:       [[LOOP_LATCH_1]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_1:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT]], i64 1
; UNROLL4-NEXT:    [[L_2:%.*]] = load i8, ptr [[PTR_IV_NEXT_1]], align 8
; UNROLL4-NEXT:    [[C_1_2:%.*]] = icmp eq i8 [[L_2]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_2]], label %[[EARLY_EXIT_LOOPEXIT]], label %[[LOOP_LATCH_2:.*]]
; UNROLL4:       [[LOOP_LATCH_2]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_2:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_1]], i64 1
; UNROLL4-NEXT:    [[L_3:%.*]] = load i8, ptr [[PTR_IV_NEXT_2]], align 8
; UNROLL4-NEXT:    [[C_1_3:%.*]] = icmp eq i8 [[L_3]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_3]], label %[[EARLY_EXIT_LOOPEXIT]], label %[[LOOP_LATCH_3]]
; UNROLL4:       [[LOOP_LATCH_3]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_3]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_2]], i64 1
; UNROLL4-NEXT:    [[C_2_3:%.*]] = icmp eq ptr [[PTR_IV_NEXT_3]], [[END]]
; UNROLL4-NEXT:    br i1 [[C_2_3]], label %[[LATCH_EXIT_UNR_LCSSA:.*]], label %[[LOOP_HEADER]]
; UNROLL4:       [[EARLY_EXIT_LOOPEXIT]]:
; UNROLL4-NEXT:    br label %[[EARLY_EXIT:.*]]
; UNROLL4:       [[EARLY_EXIT_LOOPEXIT3]]:
; UNROLL4-NEXT:    br label %[[EARLY_EXIT]]
; UNROLL4:       [[EARLY_EXIT]]:
; UNROLL4-NEXT:    ret i1 true
; UNROLL4:       [[LATCH_EXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    br label %[[LATCH_EXIT]]
; UNROLL4:       [[LATCH_EXIT]]:
; UNROLL4-NEXT:    ret i1 false
;
; NOUNROLL-LABEL: define i1 @multi_2_exiting_find_i8_loop_diff_exit(
; NOUNROLL-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0]] {
; NOUNROLL-NEXT:  [[ENTRY:.*]]:
; NOUNROLL-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; NOUNROLL-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; NOUNROLL-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; NOUNROLL-NEXT:    br label %[[LOOP_HEADER:.*]]
; NOUNROLL:       [[LOOP_HEADER]]:
; NOUNROLL-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; NOUNROLL-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; NOUNROLL-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; NOUNROLL-NEXT:    br i1 [[C_1]], label %[[EARLY_EXIT:.*]], label %[[LOOP_LATCH]]
; NOUNROLL:       [[LOOP_LATCH]]:
; NOUNROLL-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; NOUNROLL-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; NOUNROLL-NEXT:    br i1 [[C_2]], label %[[LATCH_EXIT:.*]], label %[[LOOP_HEADER]]
; NOUNROLL:       [[EARLY_EXIT]]:
; NOUNROLL-NEXT:    ret i1 true
; NOUNROLL:       [[LATCH_EXIT]]:
; NOUNROLL-NEXT:    ret i1 false
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  %c.1 = icmp eq i8 %l, %tgt
  br i1 %c.1, label %early.exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %latch.exit, label %loop.header

early.exit:
  ret i1 1

latch.exit:
  ret i1 0
}


define i1 @multi_2_exiting_find_ptr_loop_same_exit(ptr %vec, ptr %tgt) {
; UNROLL4-LABEL: define i1 @multi_2_exiting_find_ptr_loop_same_exit(
; UNROLL4-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]]) #[[ATTR0]] {
; UNROLL4-NEXT:  [[ENTRY:.*]]:
; UNROLL4-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; UNROLL4-NEXT:    [[START2:%.*]] = ptrtoint ptr [[START]] to i64
; UNROLL4-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; UNROLL4-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; UNROLL4-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; UNROLL4-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; UNROLL4-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; UNROLL4-NEXT:    [[TMP0:%.*]] = add i64 [[END1]], -8
; UNROLL4-NEXT:    [[TMP1:%.*]] = sub i64 [[TMP0]], [[START2]]
; UNROLL4-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 3
; UNROLL4-NEXT:    [[TMP3:%.*]] = add nuw nsw i64 [[TMP2]], 1
; UNROLL4-NEXT:    [[TMP4:%.*]] = freeze i64 [[TMP3]]
; UNROLL4-NEXT:    [[TMP5:%.*]] = add i64 [[TMP4]], -1
; UNROLL4-NEXT:    [[XTRAITER:%.*]] = and i64 [[TMP4]], 3
; UNROLL4-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i64 [[XTRAITER]], 0
; UNROLL4-NEXT:    br i1 [[LCMP_MOD]], label %[[LOOP_HEADER_PROL_PREHEADER:.*]], label %[[LOOP_HEADER_PROL_LOOPEXIT:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL_PREHEADER]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_PROL:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL:%.*]], %[[LOOP_LATCH_PROL:.*]] ], [ [[START]], %[[LOOP_HEADER_PROL_PREHEADER]] ]
; UNROLL4-NEXT:    [[PROL_ITER:%.*]] = phi i64 [ 0, %[[LOOP_HEADER_PROL_PREHEADER]] ], [ [[PROL_ITER_NEXT:%.*]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    [[L_PROL:%.*]] = load ptr, ptr [[PTR_IV_PROL]], align 8
; UNROLL4-NEXT:    [[C_1_PROL:%.*]] = icmp eq ptr [[L_PROL]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_PROL]], label %[[EXIT_UNR_LCSSA_LOOPEXIT3:.*]], label %[[LOOP_LATCH_PROL]]
; UNROLL4:       [[LOOP_LATCH_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_PROL]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_PROL]], i64 8
; UNROLL4-NEXT:    [[C_2_PROL:%.*]] = icmp eq ptr [[PTR_IV_NEXT_PROL]], [[END]]
; UNROLL4-NEXT:    [[PROL_ITER_NEXT]] = add i64 [[PROL_ITER]], 1
; UNROLL4-NEXT:    [[PROL_ITER_CMP:%.*]] = icmp ne i64 [[PROL_ITER_NEXT]], [[XTRAITER]]
; UNROLL4-NEXT:    br i1 [[PROL_ITER_CMP]], label %[[LOOP_HEADER_PROL]], label %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA:.*]], !llvm.loop [[LOOP3:![0-9]+]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    [[RES_UNR_PH:%.*]] = phi ptr [ [[END]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    [[PTR_IV_UNR_PH:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL_LOOPEXIT]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT]]:
; UNROLL4-NEXT:    [[RES_UNR:%.*]] = phi ptr [ poison, %[[ENTRY]] ], [ [[RES_UNR_PH]], %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    [[PTR_IV_UNR:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[PTR_IV_UNR_PH]], %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    [[TMP6:%.*]] = icmp ult i64 [[TMP5]], 3
; UNROLL4-NEXT:    br i1 [[TMP6]], label %[[EXIT:.*]], label %[[ENTRY_NEW:.*]]
; UNROLL4:       [[ENTRY_NEW]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER:.*]]
; UNROLL4:       [[LOOP_HEADER]]:
; UNROLL4-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_UNR]], %[[ENTRY_NEW]] ], [ [[PTR_IV_NEXT_3:%.*]], %[[LOOP_LATCH_3:.*]] ]
; UNROLL4-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; UNROLL4-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1]], label %[[EXIT_UNR_LCSSA_LOOPEXIT:.*]], label %[[LOOP_LATCH:.*]]
; UNROLL4:       [[LOOP_LATCH]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; UNROLL4-NEXT:    [[L_1:%.*]] = load ptr, ptr [[PTR_IV_NEXT]], align 8
; UNROLL4-NEXT:    [[C_1_1:%.*]] = icmp eq ptr [[L_1]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_1]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_LATCH_1:.*]]
; UNROLL4:       [[LOOP_LATCH_1]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_1:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT]], i64 8
; UNROLL4-NEXT:    [[L_2:%.*]] = load ptr, ptr [[PTR_IV_NEXT_1]], align 8
; UNROLL4-NEXT:    [[C_1_2:%.*]] = icmp eq ptr [[L_2]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_2]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_LATCH_2:.*]]
; UNROLL4:       [[LOOP_LATCH_2]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_2:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_1]], i64 8
; UNROLL4-NEXT:    [[L_3:%.*]] = load ptr, ptr [[PTR_IV_NEXT_2]], align 8
; UNROLL4-NEXT:    [[C_1_3:%.*]] = icmp eq ptr [[L_3]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_3]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_LATCH_3]]
; UNROLL4:       [[LOOP_LATCH_3]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_3]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_2]], i64 8
; UNROLL4-NEXT:    [[C_2_3:%.*]] = icmp eq ptr [[PTR_IV_NEXT_3]], [[END]]
; UNROLL4-NEXT:    br i1 [[C_2_3]], label %[[EXIT_UNR_LCSSA_LOOPEXIT]], label %[[LOOP_HEADER]]
; UNROLL4:       [[EXIT_UNR_LCSSA_LOOPEXIT]]:
; UNROLL4-NEXT:    [[RES_PH_PH:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[PTR_IV_NEXT]], %[[LOOP_LATCH]] ], [ [[PTR_IV_NEXT_1]], %[[LOOP_LATCH_1]] ], [ [[PTR_IV_NEXT_2]], %[[LOOP_LATCH_2]] ], [ [[END]], %[[LOOP_LATCH_3]] ]
; UNROLL4-NEXT:    br label %[[EXIT_UNR_LCSSA:.*]]
; UNROLL4:       [[EXIT_UNR_LCSSA_LOOPEXIT3]]:
; UNROLL4-NEXT:    [[RES_PH_PH4:%.*]] = phi ptr [ [[PTR_IV_PROL]], %[[LOOP_HEADER_PROL]] ]
; UNROLL4-NEXT:    br label %[[EXIT_UNR_LCSSA]]
; UNROLL4:       [[EXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    [[RES_PH:%.*]] = phi ptr [ [[RES_PH_PH]], %[[EXIT_UNR_LCSSA_LOOPEXIT]] ], [ [[RES_PH_PH4]], %[[EXIT_UNR_LCSSA_LOOPEXIT3]] ]
; UNROLL4-NEXT:    br label %[[EXIT]]
; UNROLL4:       [[EXIT]]:
; UNROLL4-NEXT:    [[RES:%.*]] = phi ptr [ [[RES_UNR]], %[[LOOP_HEADER_PROL_LOOPEXIT]] ], [ [[RES_PH]], %[[EXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; UNROLL4-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; UNROLL4-NEXT:    ret i1 [[C_3]]
;
; NOUNROLL-LABEL: define i1 @multi_2_exiting_find_ptr_loop_same_exit(
; NOUNROLL-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]]) #[[ATTR0]] {
; NOUNROLL-NEXT:  [[ENTRY:.*]]:
; NOUNROLL-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; NOUNROLL-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; NOUNROLL-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; NOUNROLL-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; NOUNROLL-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; NOUNROLL-NEXT:    br label %[[LOOP_HEADER:.*]]
; NOUNROLL:       [[LOOP_HEADER]]:
; NOUNROLL-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; NOUNROLL-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; NOUNROLL-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; NOUNROLL-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; NOUNROLL:       [[LOOP_LATCH]]:
; NOUNROLL-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; NOUNROLL-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; NOUNROLL-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; NOUNROLL:       [[EXIT]]:
; NOUNROLL-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; NOUNROLL-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; NOUNROLL-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; NOUNROLL-NEXT:    ret i1 [[C_3]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %start, i64 8) ]
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 8
  %end = load ptr, ptr %gep.end, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load ptr, ptr %ptr.iv, align 8
  %c.1 = icmp eq ptr %l, %tgt
  br i1 %c.1, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 8
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3
}


define ptr @multi_2_exiting_find_ptr_loop_diff_exit(ptr %vec, ptr %tgt) {
; UNROLL4-LABEL: define ptr @multi_2_exiting_find_ptr_loop_diff_exit(
; UNROLL4-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]]) #[[ATTR0]] {
; UNROLL4-NEXT:  [[ENTRY:.*]]:
; UNROLL4-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; UNROLL4-NEXT:    [[START3:%.*]] = ptrtoint ptr [[START]] to i64
; UNROLL4-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; UNROLL4-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; UNROLL4-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; UNROLL4-NEXT:    [[END2:%.*]] = ptrtoint ptr [[END]] to i64
; UNROLL4-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; UNROLL4-NEXT:    [[TMP0:%.*]] = add i64 [[END2]], -8
; UNROLL4-NEXT:    [[TMP1:%.*]] = sub i64 [[TMP0]], [[START3]]
; UNROLL4-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 3
; UNROLL4-NEXT:    [[TMP3:%.*]] = add nuw nsw i64 [[TMP2]], 1
; UNROLL4-NEXT:    [[TMP4:%.*]] = freeze i64 [[TMP3]]
; UNROLL4-NEXT:    [[TMP5:%.*]] = add i64 [[TMP4]], -1
; UNROLL4-NEXT:    [[XTRAITER:%.*]] = and i64 [[TMP4]], 3
; UNROLL4-NEXT:    [[LCMP_MOD:%.*]] = icmp ne i64 [[XTRAITER]], 0
; UNROLL4-NEXT:    br i1 [[LCMP_MOD]], label %[[LOOP_HEADER_PROL_PREHEADER:.*]], label %[[LOOP_HEADER_PROL_LOOPEXIT:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL_PREHEADER]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL:.*]]
; UNROLL4:       [[LOOP_HEADER_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_PROL:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL:%.*]], %[[LOOP_LATCH_PROL:.*]] ], [ [[START]], %[[LOOP_HEADER_PROL_PREHEADER]] ]
; UNROLL4-NEXT:    [[PROL_ITER:%.*]] = phi i64 [ 0, %[[LOOP_HEADER_PROL_PREHEADER]] ], [ [[PROL_ITER_NEXT:%.*]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    [[L_PROL:%.*]] = load ptr, ptr [[PTR_IV_PROL]], align 8
; UNROLL4-NEXT:    [[C_1_PROL:%.*]] = icmp eq ptr [[L_PROL]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_PROL]], label %[[EARLY_EXIT_LOOPEXIT4:.*]], label %[[LOOP_LATCH_PROL]]
; UNROLL4:       [[LOOP_LATCH_PROL]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_PROL]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_PROL]], i64 8
; UNROLL4-NEXT:    [[C_2_PROL:%.*]] = icmp eq ptr [[PTR_IV_NEXT_PROL]], [[END]]
; UNROLL4-NEXT:    [[PROL_ITER_NEXT]] = add i64 [[PROL_ITER]], 1
; UNROLL4-NEXT:    [[PROL_ITER_CMP:%.*]] = icmp ne i64 [[PROL_ITER_NEXT]], [[XTRAITER]]
; UNROLL4-NEXT:    br i1 [[PROL_ITER_CMP]], label %[[LOOP_HEADER_PROL]], label %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA:.*]], !llvm.loop [[LOOP4:![0-9]+]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    [[PTR_IV_UNR_PH:%.*]] = phi ptr [ [[PTR_IV_NEXT_PROL]], %[[LOOP_LATCH_PROL]] ]
; UNROLL4-NEXT:    br label %[[LOOP_HEADER_PROL_LOOPEXIT]]
; UNROLL4:       [[LOOP_HEADER_PROL_LOOPEXIT]]:
; UNROLL4-NEXT:    [[PTR_IV_UNR:%.*]] = phi ptr [ [[START]], %[[ENTRY]] ], [ [[PTR_IV_UNR_PH]], %[[LOOP_HEADER_PROL_LOOPEXIT_UNR_LCSSA]] ]
; UNROLL4-NEXT:    [[TMP6:%.*]] = icmp ult i64 [[TMP5]], 3
; UNROLL4-NEXT:    br i1 [[TMP6]], label %[[LATCH_EXIT:.*]], label %[[ENTRY_NEW:.*]]
; UNROLL4:       [[ENTRY_NEW]]:
; UNROLL4-NEXT:    br label %[[LOOP_HEADER:.*]]
; UNROLL4:       [[LOOP_HEADER]]:
; UNROLL4-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_UNR]], %[[ENTRY_NEW]] ], [ [[PTR_IV_NEXT_3:%.*]], %[[LOOP_LATCH_3:.*]] ]
; UNROLL4-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; UNROLL4-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1]], label %[[EARLY_EXIT_LOOPEXIT:.*]], label %[[LOOP_LATCH:.*]]
; UNROLL4:       [[LOOP_LATCH]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; UNROLL4-NEXT:    [[L_1:%.*]] = load ptr, ptr [[PTR_IV_NEXT]], align 8
; UNROLL4-NEXT:    [[C_1_1:%.*]] = icmp eq ptr [[L_1]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_1]], label %[[EARLY_EXIT_LOOPEXIT]], label %[[LOOP_LATCH_1:.*]]
; UNROLL4:       [[LOOP_LATCH_1]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_1:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT]], i64 8
; UNROLL4-NEXT:    [[L_2:%.*]] = load ptr, ptr [[PTR_IV_NEXT_1]], align 8
; UNROLL4-NEXT:    [[C_1_2:%.*]] = icmp eq ptr [[L_2]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_2]], label %[[EARLY_EXIT_LOOPEXIT]], label %[[LOOP_LATCH_2:.*]]
; UNROLL4:       [[LOOP_LATCH_2]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_2:%.*]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_1]], i64 8
; UNROLL4-NEXT:    [[L_3:%.*]] = load ptr, ptr [[PTR_IV_NEXT_2]], align 8
; UNROLL4-NEXT:    [[C_1_3:%.*]] = icmp eq ptr [[L_3]], [[TGT]]
; UNROLL4-NEXT:    br i1 [[C_1_3]], label %[[EARLY_EXIT_LOOPEXIT]], label %[[LOOP_LATCH_3]]
; UNROLL4:       [[LOOP_LATCH_3]]:
; UNROLL4-NEXT:    [[PTR_IV_NEXT_3]] = getelementptr inbounds nuw i8, ptr [[PTR_IV_NEXT_2]], i64 8
; UNROLL4-NEXT:    [[C_2_3:%.*]] = icmp eq ptr [[PTR_IV_NEXT_3]], [[END]]
; UNROLL4-NEXT:    br i1 [[C_2_3]], label %[[LATCH_EXIT_UNR_LCSSA:.*]], label %[[LOOP_HEADER]]
; UNROLL4:       [[EARLY_EXIT_LOOPEXIT]]:
; UNROLL4-NEXT:    [[L_LCSSA_PH:%.*]] = phi ptr [ [[L]], %[[LOOP_HEADER]] ], [ [[L_1]], %[[LOOP_LATCH]] ], [ [[L_2]], %[[LOOP_LATCH_1]] ], [ [[L_3]], %[[LOOP_LATCH_2]] ]
; UNROLL4-NEXT:    br label %[[EARLY_EXIT:.*]]
; UNROLL4:       [[EARLY_EXIT_LOOPEXIT4]]:
; UNROLL4-NEXT:    [[L_LCSSA_PH5:%.*]] = phi ptr [ [[L_PROL]], %[[LOOP_HEADER_PROL]] ]
; UNROLL4-NEXT:    br label %[[EARLY_EXIT]]
; UNROLL4:       [[EARLY_EXIT]]:
; UNROLL4-NEXT:    [[L_LCSSA:%.*]] = phi ptr [ [[L_LCSSA_PH]], %[[EARLY_EXIT_LOOPEXIT]] ], [ [[L_LCSSA_PH5]], %[[EARLY_EXIT_LOOPEXIT4]] ]
; UNROLL4-NEXT:    ret ptr [[L_LCSSA]]
; UNROLL4:       [[LATCH_EXIT_UNR_LCSSA]]:
; UNROLL4-NEXT:    br label %[[LATCH_EXIT]]
; UNROLL4:       [[LATCH_EXIT]]:
; UNROLL4-NEXT:    ret ptr [[END]]
;
; NOUNROLL-LABEL: define ptr @multi_2_exiting_find_ptr_loop_diff_exit(
; NOUNROLL-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]]) #[[ATTR0]] {
; NOUNROLL-NEXT:  [[ENTRY:.*]]:
; NOUNROLL-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; NOUNROLL-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; NOUNROLL-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; NOUNROLL-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; NOUNROLL-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; NOUNROLL-NEXT:    br label %[[LOOP_HEADER:.*]]
; NOUNROLL:       [[LOOP_HEADER]]:
; NOUNROLL-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; NOUNROLL-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; NOUNROLL-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; NOUNROLL-NEXT:    br i1 [[C_1]], label %[[EARLY_EXIT:.*]], label %[[LOOP_LATCH]]
; NOUNROLL:       [[LOOP_LATCH]]:
; NOUNROLL-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; NOUNROLL-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; NOUNROLL-NEXT:    br i1 [[C_2]], label %[[LATCH_EXIT:.*]], label %[[LOOP_HEADER]]
; NOUNROLL:       [[EARLY_EXIT]]:
; NOUNROLL-NEXT:    [[L_LCSSA:%.*]] = phi ptr [ [[L]], %[[LOOP_HEADER]] ]
; NOUNROLL-NEXT:    ret ptr [[L_LCSSA]]
; NOUNROLL:       [[LATCH_EXIT]]:
; NOUNROLL-NEXT:    ret ptr [[END]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %start, i64 8) ]
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 8
  %end = load ptr, ptr %gep.end, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load ptr, ptr %ptr.iv, align 8
  %c.1 = icmp eq ptr %l, %tgt
  br i1 %c.1, label %early.exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 8
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %latch.exit, label %loop.header

early.exit:
  ret ptr %l

latch.exit:
  ret ptr %end
}


define i1 @multi_2_exiting_find_i8_loop_too_large(ptr %vec, i8 %tgt) {
; COMMON-LABEL: define i1 @multi_2_exiting_find_i8_loop_too_large(
; COMMON-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0:[0-9]+]] {
; COMMON-NEXT:  [[ENTRY:.*]]:
; COMMON-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; COMMON-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; COMMON-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; COMMON-NEXT:    br label %[[LOOP_HEADER:.*]]
; COMMON:       [[LOOP_HEADER]]:
; COMMON-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; COMMON-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; COMMON-NEXT:    [[UDIV:%.*]] = udiv i8 [[L]], [[TGT]]
; COMMON-NEXT:    [[UDIV_2:%.*]] = udiv i8 [[UDIV]], 10
; COMMON-NEXT:    [[C_1:%.*]] = icmp eq i8 [[UDIV_2]], 2
; COMMON-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; COMMON:       [[LOOP_LATCH]]:
; COMMON-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; COMMON-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; COMMON-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; COMMON:       [[EXIT]]:
; COMMON-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; COMMON-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; COMMON-NEXT:    ret i1 [[C_3]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  %udiv = udiv i8 %l, %tgt
  %udiv.2 = udiv i8 %udiv, 10
  %c.1 = icmp eq i8 %udiv.2, 2
  br i1 %c.1, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3
}


define i1 @multi_3_exiting_find_ptr_loop(ptr %vec, ptr %tgt, ptr %tgt2) {
; COMMON-LABEL: define i1 @multi_3_exiting_find_ptr_loop(
; COMMON-SAME: ptr [[VEC:%.*]], ptr [[TGT:%.*]], ptr [[TGT2:%.*]]) #[[ATTR0]] {
; COMMON-NEXT:  [[ENTRY:.*]]:
; COMMON-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; COMMON-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[START]], i64 8) ]
; COMMON-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 8
; COMMON-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; COMMON-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; COMMON-NEXT:    br label %[[LOOP_HEADER:.*]]
; COMMON:       [[LOOP_HEADER]]:
; COMMON-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; COMMON-NEXT:    [[L:%.*]] = load ptr, ptr [[PTR_IV]], align 8
; COMMON-NEXT:    [[C_1:%.*]] = icmp eq ptr [[L]], [[TGT]]
; COMMON-NEXT:    [[C_2:%.*]] = icmp eq ptr [[L]], [[TGT2]]
; COMMON-NEXT:    [[OR_COND:%.*]] = select i1 [[C_1]], i1 true, i1 [[C_2]]
; COMMON-NEXT:    br i1 [[OR_COND]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; COMMON:       [[LOOP_LATCH]]:
; COMMON-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 8
; COMMON-NEXT:    [[C_3:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; COMMON-NEXT:    br i1 [[C_3]], label %[[EXIT]], label %[[LOOP_HEADER]]
; COMMON:       [[EXIT]]:
; COMMON-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; COMMON-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[END]], i64 8) ]
; COMMON-NEXT:    [[C_4:%.*]] = icmp eq ptr [[RES]], [[END]]
; COMMON-NEXT:    ret i1 [[C_4]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %start, i64 8) ]
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 8
  %end = load ptr, ptr %gep.end, align 8
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load ptr, ptr %ptr.iv, align 8
  %c.1 = icmp eq ptr %l, %tgt
  br i1 %c.1, label %exit, label %then

then:
  %c.2 = icmp eq ptr %l, %tgt2
  br i1 %c.2, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 8
  %c.3 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.3, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %ptr.iv, %then], [ %end, %loop.latch ]
  call void @llvm.assume(i1 true) [ "align"(ptr %end, i64 8) ]
  %c.4 = icmp eq ptr %res, %end
  ret i1 %c.4
}


define i1 @multi_2_exiting_find_i8_loop_switch(ptr %vec, i8 %tgt) {
; COMMON-LABEL: define i1 @multi_2_exiting_find_i8_loop_switch(
; COMMON-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR0]] {
; COMMON-NEXT:  [[ENTRY:.*]]:
; COMMON-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; COMMON-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; COMMON-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; COMMON-NEXT:    br label %[[LOOP_HEADER:.*]]
; COMMON:       [[LOOP_HEADER]]:
; COMMON-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; COMMON-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; COMMON-NEXT:    switch i8 [[L]], label %[[LOOP_LATCH]] [
; COMMON-NEXT:      i8 0, label %[[EXIT_1:.*]]
; COMMON-NEXT:      i8 1, label %[[EXIT_2:.*]]
; COMMON-NEXT:      i8 2, label %[[EXIT:.*]]
; COMMON-NEXT:    ]
; COMMON:       [[LOOP_LATCH]]:
; COMMON-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; COMMON-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; COMMON-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; COMMON:       [[EXIT]]:
; COMMON-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; COMMON-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; COMMON-NEXT:    ret i1 [[C_3]]
; COMMON:       [[EXIT_1]]:
; COMMON-NEXT:    ret i1 false
; COMMON:       [[EXIT_2]]:
; COMMON-NEXT:    ret i1 true
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  switch i8 %l, label %loop.latch [
  i8 0, label %exit.1
  i8 1, label %exit.2
  i8 2, label %exit ]

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3

exit.1:
  ret i1 0

exit.2:
  ret i1 1
}


define i1 @multi_2_exiting_find_i8_loop_small_max_tc(ptr %vec, i8 %tgt, i5 %n5) {
; COMMON-LABEL: define i1 @multi_2_exiting_find_i8_loop_small_max_tc(
; COMMON-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]], i5 [[N5:%.*]]) #[[ATTR0]] {
; COMMON-NEXT:  [[ENTRY:.*:]]
; COMMON-NEXT:    [[C_0:%.*]] = icmp sgt i5 [[N5]], 0
; COMMON-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; COMMON-NEXT:    br i1 [[C_0]], label %[[LOOP_PH:.*]], label %[[EXIT:.*]]
; COMMON:       [[LOOP_PH]]:
; COMMON-NEXT:    [[N64:%.*]] = zext i5 [[N5]] to i64
; COMMON-NEXT:    [[END:%.*]] = getelementptr inbounds nuw i8, ptr [[START]], i64 [[N64]]
; COMMON-NEXT:    br label %[[LOOP_HEADER:.*]]
; COMMON:       [[LOOP_HEADER]]:
; COMMON-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[LOOP_PH]] ]
; COMMON-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], %[[LOOP_LATCH]] ], [ 0, %[[LOOP_PH]] ]
; COMMON-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; COMMON-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; COMMON-NEXT:    br i1 [[C_1]], label %[[LOOP_EXIT:.*]], label %[[LOOP_LATCH]]
; COMMON:       [[LOOP_LATCH]]:
; COMMON-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; COMMON-NEXT:    [[IV_NEXT]] = add nuw nsw i64 [[IV]], 1
; COMMON-NEXT:    [[C_2:%.*]] = icmp eq i64 [[IV_NEXT]], [[N64]]
; COMMON-NEXT:    br i1 [[C_2]], label %[[LOOP_EXIT]], label %[[LOOP_HEADER]]
; COMMON:       [[LOOP_EXIT]]:
; COMMON-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; COMMON-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; COMMON-NEXT:    ret i1 [[C_3]]
; COMMON:       [[EXIT]]:
; COMMON-NEXT:    ret i1 false
;
entry:
  %c.0 = icmp sgt i5 %n5, 0
  %start = load ptr, ptr %vec, align 8
  br i1 %c.0, label %loop.ph, label %exit

loop.ph:
  %n64 = zext i5 %n5 to i64
  %end = getelementptr inbounds nuw i8, ptr %start, i64 %n64
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %loop.ph ]
  %iv = phi i64 [ %iv.next, %loop.latch ], [ 0, %loop.ph ]
  %l = load i8, ptr %ptr.iv, align 8
  %c.1 = icmp eq i8 %l, %tgt
  br i1 %c.1, label %loop.exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %iv.next = add nuw nsw i64 %iv, 1
  %c.2 = icmp eq i64 %iv.next, %n64
  br i1 %c.2, label %loop.exit, label %loop.header

loop.exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3

exit:
  ret i1 false
}


define i1 @multi_2_exiting_find_i8_loop_invalid_insn(ptr %vec, i8 %tgt) #0 {
; COMMON-LABEL: define i1 @multi_2_exiting_find_i8_loop_invalid_insn(
; COMMON-SAME: ptr [[VEC:%.*]], i8 [[TGT:%.*]]) #[[ATTR1:[0-9]+]] {
; COMMON-NEXT:  [[ENTRY:.*]]:
; COMMON-NEXT:    [[START:%.*]] = load ptr, ptr [[VEC]], align 8
; COMMON-NEXT:    [[GEP_END:%.*]] = getelementptr inbounds nuw i8, ptr [[VEC]], i64 1
; COMMON-NEXT:    [[END:%.*]] = load ptr, ptr [[GEP_END]], align 8
; COMMON-NEXT:    br label %[[LOOP_HEADER:.*]]
; COMMON:       [[LOOP_HEADER]]:
; COMMON-NEXT:    [[PTR_IV:%.*]] = phi ptr [ [[PTR_IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ], [ [[START]], %[[ENTRY]] ]
; COMMON-NEXT:    [[L:%.*]] = load i8, ptr [[PTR_IV]], align 8
; COMMON-NEXT:    [[DEINTER:%.*]] = call { <vscale x 16 x i8>, <vscale x 16 x i8> } @llvm.vector.deinterleave2.nxv32i8(<vscale x 32 x i8> poison)
; COMMON-NEXT:    [[C_1:%.*]] = icmp eq i8 [[L]], [[TGT]]
; COMMON-NEXT:    br i1 [[C_1]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; COMMON:       [[LOOP_LATCH]]:
; COMMON-NEXT:    [[PTR_IV_NEXT]] = getelementptr inbounds nuw i8, ptr [[PTR_IV]], i64 1
; COMMON-NEXT:    [[C_2:%.*]] = icmp eq ptr [[PTR_IV_NEXT]], [[END]]
; COMMON-NEXT:    br i1 [[C_2]], label %[[EXIT]], label %[[LOOP_HEADER]]
; COMMON:       [[EXIT]]:
; COMMON-NEXT:    [[RES:%.*]] = phi ptr [ [[PTR_IV]], %[[LOOP_HEADER]] ], [ [[END]], %[[LOOP_LATCH]] ]
; COMMON-NEXT:    [[C_3:%.*]] = icmp eq ptr [[RES]], [[END]]
; COMMON-NEXT:    ret i1 [[C_3]]
;
entry:
  %start = load ptr, ptr %vec, align 8
  %gep.end = getelementptr inbounds nuw i8, ptr %vec, i64 1
  %end = load ptr, ptr %gep.end, align 8
  br label %loop.header

loop.header:
  %ptr.iv = phi ptr [ %ptr.iv.next, %loop.latch ], [ %start, %entry ]
  %l = load i8, ptr %ptr.iv, align 8
  %deinter = call {<vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave2.nxv32i8(<vscale x 32 x i8> poison)
  %c.1 = icmp eq i8 %l, %tgt
  br i1 %c.1, label %exit, label %loop.latch

loop.latch:
  %ptr.iv.next = getelementptr inbounds nuw i8, ptr %ptr.iv, i64 1
  %c.2 = icmp eq ptr %ptr.iv.next, %end
  br i1 %c.2, label %exit, label %loop.header

exit:
  %res = phi ptr [ %ptr.iv, %loop.header ], [ %end, %loop.latch ]
  %c.3 = icmp eq ptr %res, %end
  ret i1 %c.3
}


declare void @llvm.assume(i1 noundef)
declare {<vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave2.nxv32i8(<vscale x 32 x i8>)

attributes #0 = { "target-features"="-sve,-sve2" }
