; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-simplifylib %s | FileCheck %s

target datalayout = "e-p:64:64-p1:64:64-p2:32:32-p3:32:32-p4:64:64-p5:32:32-p6:32:32-p7:160:256:256:32-p8:128:128-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-v2048:2048-n32:64-S32-A5-G1-ni:7:8:9"

declare float @_Z5log10f(float)
declare <2 x float> @_Z5log10Dv2_f(<2 x float>)
declare <3 x float> @_Z5log10Dv3_f(<3 x float>)
declare <4 x float> @_Z5log10Dv4_f(<4 x float>)
declare <8 x float> @_Z5log10Dv8_f(<8 x float>)
declare <16 x float> @_Z5log10Dv16_f(<16 x float>)

declare double @_Z5log10d(double)
declare <2 x double> @_Z5log10Dv2_d(<2 x double>)
declare <3 x double> @_Z5log10Dv3_d(<3 x double>)
declare <4 x double> @_Z5log10Dv4_d(<4 x double>)
declare <8 x double> @_Z5log10Dv8_d(<8 x double>)
declare <16 x double> @_Z5log10Dv16_d(<16 x double>)

declare half @_Z5log10Dh(half)
declare <2 x half> @_Z5log10Dv2_Dh(<2 x half>)
declare <3 x half> @_Z5log10Dv3_Dh(<3 x half>)
declare <4 x half> @_Z5log10Dv4_Dh(<4 x half>)
declare <8 x half> @_Z5log10Dv8_Dh(<8 x half>)
declare <16 x half> @_Z5log10Dv16_Dh(<16 x half>)

define float @test_log10_f32(float %arg) {
; CHECK-LABEL: define float @test_log10_f32
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @_Z5log10f(float [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @_Z5log10f(float %arg), !fpmath !0
  ret float %log10
}

define <2 x float> @test_log10_v2f32(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_log10_v2f32
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> %arg), !fpmath !0
  ret <2 x float> %log10
}

define <3 x float> @test_log10_v3f32(<3 x float> %arg) {
; CHECK-LABEL: define <3 x float> @test_log10_v3f32
; CHECK-SAME: (<3 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <3 x float> @_Z5log10Dv3_f(<3 x float> [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret <3 x float> [[LOG10]]
;
  %log10 = tail call <3 x float> @_Z5log10Dv3_f(<3 x float> %arg), !fpmath !0
  ret <3 x float> %log10
}

define <4 x float> @test_log10_v4f32(<4 x float> %arg) {
; CHECK-LABEL: define <4 x float> @test_log10_v4f32
; CHECK-SAME: (<4 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <4 x float> @_Z5log10Dv4_f(<4 x float> [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret <4 x float> [[LOG10]]
;
  %log10 = tail call <4 x float> @_Z5log10Dv4_f(<4 x float> %arg), !fpmath !0
  ret <4 x float> %log10
}

define <8 x float> @test_log10_v8f32(<8 x float> %arg) {
; CHECK-LABEL: define <8 x float> @test_log10_v8f32
; CHECK-SAME: (<8 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <8 x float> @_Z5log10Dv8_f(<8 x float> [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret <8 x float> [[LOG10]]
;
  %log10 = tail call <8 x float> @_Z5log10Dv8_f(<8 x float> %arg), !fpmath !0
  ret <8 x float> %log10
}

define <16 x float> @test_log10_v16f32(<16 x float> %arg) {
; CHECK-LABEL: define <16 x float> @test_log10_v16f32
; CHECK-SAME: (<16 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <16 x float> @_Z5log10Dv16_f(<16 x float> [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret <16 x float> [[LOG10]]
;
  %log10 = tail call <16 x float> @_Z5log10Dv16_f(<16 x float> %arg), !fpmath !0
  ret <16 x float> %log10
}

define float @test_log10_cr_f32(float %arg) {
; CHECK-LABEL: define float @test_log10_cr_f32
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @_Z5log10f(float [[ARG]])
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @_Z5log10f(float %arg)
  ret float %log10
}

define <2 x float> @test_log10_cr_v2f32(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_log10_cr_v2f32
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> [[ARG]])
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> %arg)
  ret <2 x float> %log10
}

define <3 x float> @test_log10_cr_v3f32(<3 x float> %arg) {
; CHECK-LABEL: define <3 x float> @test_log10_cr_v3f32
; CHECK-SAME: (<3 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <3 x float> @_Z5log10Dv3_f(<3 x float> [[ARG]])
; CHECK-NEXT:    ret <3 x float> [[LOG10]]
;
  %log10 = tail call <3 x float> @_Z5log10Dv3_f(<3 x float> %arg)
  ret <3 x float> %log10
}

define <4 x float> @test_log10_cr_v4f32(<4 x float> %arg) {
; CHECK-LABEL: define <4 x float> @test_log10_cr_v4f32
; CHECK-SAME: (<4 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <4 x float> @_Z5log10Dv4_f(<4 x float> [[ARG]])
; CHECK-NEXT:    ret <4 x float> [[LOG10]]
;
  %log10 = tail call <4 x float> @_Z5log10Dv4_f(<4 x float> %arg)
  ret <4 x float> %log10
}

define <8 x float> @test_log10_cr_v8f32(<8 x float> %arg) {
; CHECK-LABEL: define <8 x float> @test_log10_cr_v8f32
; CHECK-SAME: (<8 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <8 x float> @_Z5log10Dv8_f(<8 x float> [[ARG]])
; CHECK-NEXT:    ret <8 x float> [[LOG10]]
;
  %log10 = tail call <8 x float> @_Z5log10Dv8_f(<8 x float> %arg)
  ret <8 x float> %log10
}

define <16 x float> @test_log10_cr_v16f32(<16 x float> %arg) {
; CHECK-LABEL: define <16 x float> @test_log10_cr_v16f32
; CHECK-SAME: (<16 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <16 x float> @_Z5log10Dv16_f(<16 x float> [[ARG]])
; CHECK-NEXT:    ret <16 x float> [[LOG10]]
;
  %log10 = tail call <16 x float> @_Z5log10Dv16_f(<16 x float> %arg)
  ret <16 x float> %log10
}

define double @test_log10_f64(double %arg) {
; CHECK-LABEL: define double @test_log10_f64
; CHECK-SAME: (double [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call double @_Z5log10d(double [[ARG]])
; CHECK-NEXT:    ret double [[LOG10]]
;
  %log10 = tail call double @_Z5log10d(double %arg)
  ret double %log10
}

define <2 x double> @test_log10_v2f64(<2 x double> %arg) {
; CHECK-LABEL: define <2 x double> @test_log10_v2f64
; CHECK-SAME: (<2 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x double> @_Z5log10Dv2_d(<2 x double> [[ARG]])
; CHECK-NEXT:    ret <2 x double> [[LOG10]]
;
  %log10 = tail call <2 x double> @_Z5log10Dv2_d(<2 x double> %arg)
  ret <2 x double> %log10
}

define <3 x double> @test_log10_v3f64(<3 x double> %arg) {
; CHECK-LABEL: define <3 x double> @test_log10_v3f64
; CHECK-SAME: (<3 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <3 x double> @_Z5log10Dv3_d(<3 x double> [[ARG]])
; CHECK-NEXT:    ret <3 x double> [[LOG10]]
;
  %log10 = tail call <3 x double> @_Z5log10Dv3_d(<3 x double> %arg)
  ret <3 x double> %log10
}

define <4 x double> @test_log10_v4f64(<4 x double> %arg) {
; CHECK-LABEL: define <4 x double> @test_log10_v4f64
; CHECK-SAME: (<4 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <4 x double> @_Z5log10Dv4_d(<4 x double> [[ARG]])
; CHECK-NEXT:    ret <4 x double> [[LOG10]]
;
  %log10 = tail call <4 x double> @_Z5log10Dv4_d(<4 x double> %arg)
  ret <4 x double> %log10
}

define <8 x double> @test_log10_v8f64(<8 x double> %arg) {
; CHECK-LABEL: define <8 x double> @test_log10_v8f64
; CHECK-SAME: (<8 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <8 x double> @_Z5log10Dv8_d(<8 x double> [[ARG]])
; CHECK-NEXT:    ret <8 x double> [[LOG10]]
;
  %log10 = tail call <8 x double> @_Z5log10Dv8_d(<8 x double> %arg)
  ret <8 x double> %log10
}

define <16 x double> @test_log10_v16f64(<16 x double> %arg) {
; CHECK-LABEL: define <16 x double> @test_log10_v16f64
; CHECK-SAME: (<16 x double> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <16 x double> @_Z5log10Dv16_d(<16 x double> [[ARG]])
; CHECK-NEXT:    ret <16 x double> [[LOG10]]
;
  %log10 = tail call <16 x double> @_Z5log10Dv16_d(<16 x double> %arg)
  ret <16 x double> %log10
}

define half @test_log10_f16(half %arg) {
; CHECK-LABEL: define half @test_log10_f16
; CHECK-SAME: (half [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call half @_Z5log10Dh(half [[ARG]])
; CHECK-NEXT:    ret half [[LOG10]]
;
  %log10 = tail call half @_Z5log10Dh(half %arg)
  ret half %log10
}

define half @test_log10_f16_fast(half %arg) {
; CHECK-LABEL: define half @test_log10_f16_fast
; CHECK-SAME: (half [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call fast half @llvm.log10.f16(half [[ARG]])
; CHECK-NEXT:    ret half [[LOG10]]
;
  %log10 = tail call fast half @_Z5log10Dh(half %arg)
  ret half %log10
}

define <2 x half> @test_log10_v2f16(<2 x half> %arg) {
; CHECK-LABEL: define <2 x half> @test_log10_v2f16
; CHECK-SAME: (<2 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x half> @_Z5log10Dv2_Dh(<2 x half> [[ARG]])
; CHECK-NEXT:    ret <2 x half> [[LOG10]]
;
  %log10 = tail call <2 x half> @_Z5log10Dv2_Dh(<2 x half> %arg)
  ret <2 x half> %log10
}

define <3 x half> @test_log10_v3f16(<3 x half> %arg) {
; CHECK-LABEL: define <3 x half> @test_log10_v3f16
; CHECK-SAME: (<3 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <3 x half> @_Z5log10Dv3_Dh(<3 x half> [[ARG]])
; CHECK-NEXT:    ret <3 x half> [[LOG10]]
;
  %log10 = tail call <3 x half> @_Z5log10Dv3_Dh(<3 x half> %arg)
  ret <3 x half> %log10
}

define <4 x half> @test_log10_v4f16(<4 x half> %arg) {
; CHECK-LABEL: define <4 x half> @test_log10_v4f16
; CHECK-SAME: (<4 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <4 x half> @_Z5log10Dv4_Dh(<4 x half> [[ARG]])
; CHECK-NEXT:    ret <4 x half> [[LOG10]]
;
  %log10 = tail call <4 x half> @_Z5log10Dv4_Dh(<4 x half> %arg)
  ret <4 x half> %log10
}

define <8 x half> @test_log10_v8f16(<8 x half> %arg) {
; CHECK-LABEL: define <8 x half> @test_log10_v8f16
; CHECK-SAME: (<8 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <8 x half> @_Z5log10Dv8_Dh(<8 x half> [[ARG]])
; CHECK-NEXT:    ret <8 x half> [[LOG10]]
;
  %log10 = tail call <8 x half> @_Z5log10Dv8_Dh(<8 x half> %arg)
  ret <8 x half> %log10
}

define <16 x half> @test_log10_v16f16(<16 x half> %arg) {
; CHECK-LABEL: define <16 x half> @test_log10_v16f16
; CHECK-SAME: (<16 x half> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <16 x half> @_Z5log10Dv16_Dh(<16 x half> [[ARG]])
; CHECK-NEXT:    ret <16 x half> [[LOG10]]
;
  %log10 = tail call <16 x half> @_Z5log10Dv16_Dh(<16 x half> %arg)
  ret <16 x half> %log10
}

define float @test_log10_f32_nobuiltin_callsite(float %arg) {
; CHECK-LABEL: define float @test_log10_f32_nobuiltin_callsite
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @_Z5log10f(float [[ARG]]) #[[ATTR6:[0-9]+]], !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @_Z5log10f(float %arg) #0, !fpmath !0
  ret float %log10
}

define <2 x float> @test_log10_v2f32_nobuiltin_callsite(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_log10_v2f32_nobuiltin_callsite
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> [[ARG]]) #[[ATTR6]], !fpmath !0
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> %arg) #0, !fpmath !0
  ret <2 x float> %log10
}

define float @test_log10_cr_f32_nobuiltin_callsite(float %arg) {
; CHECK-LABEL: define float @test_log10_cr_f32_nobuiltin_callsite
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @_Z5log10f(float [[ARG]]) #[[ATTR6]]
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @_Z5log10f(float %arg) #0
  ret float %log10
}

define <2 x float> @test_log10_cr_v2f32_nobuiltin_callsite(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_log10_cr_v2f32_nobuiltin_callsite
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> [[ARG]]) #[[ATTR6]]
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> %arg) #0
  ret <2 x float> %log10
}

; "no-builtins" should be ignored
define float @test_log10_f32_nobuiltins(float %arg) #1 {
; CHECK-LABEL: define float @test_log10_f32_nobuiltins
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @_Z5log10f(float [[ARG]]) #[[ATTR6]], !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @_Z5log10f(float %arg) #0, !fpmath !0
  ret float %log10
}

define <2 x float> @test_log10_v2f32_nobuiltins(<2 x float> %arg) #1 {
; CHECK-LABEL: define <2 x float> @test_log10_v2f32_nobuiltins
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> [[ARG]]) #[[ATTR6]], !fpmath !0
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> %arg) #0, !fpmath !0
  ret <2 x float> %log10
}

define float @test_log10_cr_f32_nobuiltins(float %arg) #1 {
; CHECK-LABEL: define float @test_log10_cr_f32_nobuiltins
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @_Z5log10f(float [[ARG]]) #[[ATTR6]]
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @_Z5log10f(float %arg) #0
  ret float %log10
}

define <2 x float> @test_log10_cr_v2f32_nobuiltins(<2 x float> %arg) #1 {
; CHECK-LABEL: define <2 x float> @test_log10_cr_v2f32_nobuiltins
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> [[ARG]]) #[[ATTR6]]
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call <2 x float> @_Z5log10Dv2_f(<2 x float> %arg) #0
  ret <2 x float> %log10
}

define float @test_log10_f32_preserve_flags(float %arg) {
; CHECK-LABEL: define float @test_log10_f32_preserve_flags
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call nnan ninf float @llvm.log10.f32(float [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call nnan ninf float @_Z5log10f(float %arg), !fpmath !0
  ret float %log10
}

define <2 x float> @test_log10_v2f32_preserve_flags(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_log10_v2f32_preserve_flags
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call nnan nsz contract <2 x float> @llvm.log10.v2f32(<2 x float> [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call contract nsz nnan <2 x float> @_Z5log10Dv2_f(<2 x float> %arg), !fpmath !0
  ret <2 x float> %log10
}

define float @test_log10_f32_preserve_flags_md(float %arg) {
; CHECK-LABEL: define float @test_log10_f32_preserve_flags_md
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call nnan ninf float @llvm.log10.f32(float [[ARG]]), !fpmath !0, !foo !1
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call nnan ninf float @_Z5log10f(float %arg), !fpmath !0, !foo !1
  ret float %log10
}

define <2 x float> @test_log10_v2f32_preserve_flags_md(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_log10_v2f32_preserve_flags_md
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call nnan nsz contract <2 x float> @llvm.log10.v2f32(<2 x float> [[ARG]]), !fpmath !0, !foo !1
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call contract nsz nnan <2 x float> @_Z5log10Dv2_f(<2 x float> %arg), !fpmath !0, !foo !1
  ret <2 x float> %log10
}

define float @test_log10_cr_f32_preserve_flags(float %arg) {
; CHECK-LABEL: define float @test_log10_cr_f32_preserve_flags
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call ninf contract float @llvm.log10.f32(float [[ARG]])
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call ninf contract float @_Z5log10f(float %arg)
  ret float %log10
}

define <2 x float> @test_log10_cr_v2f32_preserve_flags(<2 x float> %arg) {
; CHECK-LABEL: define <2 x float> @test_log10_cr_v2f32_preserve_flags
; CHECK-SAME: (<2 x float> [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call nnan nsz <2 x float> @llvm.log10.v2f32(<2 x float> [[ARG]])
; CHECK-NEXT:    ret <2 x float> [[LOG10]]
;
  %log10 = tail call nnan nsz <2 x float> @_Z5log10Dv2_f(<2 x float> %arg)
  ret <2 x float> %log10
}

; Test the libm name, not a recognized opencl builtin.
declare float @log10f(float) #2
declare double @log10(double) #2

define float @test_libm_log10_f32(float %arg) {
; CHECK-LABEL: define float @test_libm_log10_f32
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @log10f(float [[ARG]])
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @log10f(float %arg)
  ret float %log10
}

define float @test_libm_log10_f32_fast(float %arg) {
; CHECK-LABEL: define float @test_libm_log10_f32_fast
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call fast float @log10f(float [[ARG]])
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call fast float @log10f(float %arg)
  ret float %log10
}

define float @test_libm_log10_f32_fpmath(float %arg) {
; CHECK-LABEL: define float @test_libm_log10_f32_fpmath
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call float @log10f(float [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call float @log10f(float %arg), !fpmath !0
  ret float %log10
}

define double @test_libm_log10_f64(double %arg) {
; CHECK-LABEL: define double @test_libm_log10_f64
; CHECK-SAME: (double [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call double @log10(double [[ARG]])
; CHECK-NEXT:    ret double [[LOG10]]
;
  %log10 = tail call double @log10(double %arg)
  ret double %log10
}

define double @test_libm_log10_f64_fast(double %arg) {
; CHECK-LABEL: define double @test_libm_log10_f64_fast
; CHECK-SAME: (double [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call fast double @log10(double [[ARG]])
; CHECK-NEXT:    ret double [[LOG10]]
;
  %log10 = tail call fast double @log10(double %arg)
  ret double %log10
}

define double @test_libm_log10_f64_fpmath(double %arg) {
; CHECK-LABEL: define double @test_libm_log10_f64_fpmath
; CHECK-SAME: (double [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call double @log10(double [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret double [[LOG10]]
;
  %log10 = tail call double @log10(double %arg), !fpmath !0
  ret double %log10
}

define float @test_log10_f32_fast_noinline(float %arg) {
; CHECK-LABEL: define float @test_log10_f32_fast_noinline
; CHECK-SAME: (float [[ARG:%.*]]) {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call fast float @_Z5log10f(float [[ARG]]) #[[ATTR7:[0-9]+]], !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call fast float @_Z5log10f(float %arg) #3, !fpmath !0
  ret float %log10
}

define float @test_log10_f32_fast_optsize(float %arg) #4 {
; CHECK-LABEL: define float @test_log10_f32_fast_optsize
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call fast float @llvm.log10.f32(float [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call fast float @_Z5log10f(float %arg), !fpmath !0
  ret float %log10
}

define float @test_log10_f32_fast_minsize(float %arg) #5 {
; CHECK-LABEL: define float @test_log10_f32_fast_minsize
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call fast float @llvm.log10.f32(float [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call fast float @_Z5log10f(float %arg), !fpmath !0
  ret float %log10
}

define float @test_log10_f32_nsz_contract_optsize(float %arg) #4 {
; CHECK-LABEL: define float @test_log10_f32_nsz_contract_optsize
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR2]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call nsz contract float @llvm.log10.f32(float [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call nsz contract float @_Z5log10f(float %arg), !fpmath !0
  ret float %log10
}

define float @test_log10_f32_nsz_contract_minsize(float %arg) #5 {
; CHECK-LABEL: define float @test_log10_f32_nsz_contract_minsize
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call nsz contract float @_Z5log10f(float [[ARG]]), !fpmath !0
; CHECK-NEXT:    ret float [[LOG10]]
;
  %log10 = tail call nsz contract float @_Z5log10f(float %arg), !fpmath !0
  ret float %log10
}

define half @test_log10_f16_fast_minsize(half %arg) #5 {
; CHECK-LABEL: define half @test_log10_f16_fast_minsize
; CHECK-SAME: (half [[ARG:%.*]]) #[[ATTR3]] {
; CHECK-NEXT:    [[LOG10:%.*]] = tail call fast half @llvm.log10.f16(half [[ARG]])
; CHECK-NEXT:    ret half [[LOG10]]
;
  %log10 = tail call fast half @_Z5log10Dh(half %arg)
  ret half %log10
}

define float @test_log10_f32_strictfp(float %arg) #6 {
; CHECK-LABEL: define float @test_log10_f32_strictfp
; CHECK-SAME: (float [[ARG:%.*]]) #[[ATTR4:[0-9]+]] {
; CHECK-NEXT:    [[LOG:%.*]] = tail call nsz float @_Z5log10f(float [[ARG]]) #[[ATTR4]]
; CHECK-NEXT:    ret float [[LOG]]
;
  %log = tail call nsz float @_Z5log10f(float %arg) #6
  ret float %log
}

attributes #0 = { nobuiltin }
attributes #1 = { "no-builtins" }
attributes #2 = { nounwind memory(none) }
attributes #3 = { noinline }
attributes #4 = { optsize }
attributes #5 = { minsize }
attributes #6 = { strictfp }

!0 = !{float 3.000000e+00}
!1 = !{i32 1234}
