/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5DEBUG_H
#define H5DEBUG_H

/** \page H5TOOL_DG_UG The HDF5 h5debug Tool
 *
 * Navigate back: \ref index "Main" / \ref UG / \ref CommandTools
 * <hr>
 *
 * \section sec_cltools_h5debug h5debug
 *
 * \subsection subsec_cltools_h5debug_intro Introduction
 *  With h5debug, you can debug an existing HDF5 file at a low level.
 *
 * \subsection subsec_cltools_h5debug_usage Usage
 *  <h4>h5debug filename [signature-addr [extra]*]</h4>
 *
 * \subsection subsec_cltools_h5debug_options Options
 * \li <strong>signature-addr</strong> Primary data structure to dump
 * \li <strong>extra</strong> Extra arguments for primary data structure
 *
 * Previous Chapter \ref sec_cltools_h5clear - Next Chapter \ref sec_cltools_h5delete
 *
 * <hr>
 * Navigate back: \ref index "Main" / \ref UG / \ref CommandTools
 *
 */

#endif /* H5DEBUG_H */
