/*
 *                         OpenSplice DDS
 *
 *   This software and documentation are Copyright 2006 to TO_YEAR PrismTech
 *   Limited, its affiliated companies and licensors. All rights reserved.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
#ifndef IDL_GENLITEHELPER_H
#define IDL_GENLITEHELPER_H

#include "c_typebase.h"

#include "idl_scope.h"
#include "idl_program.h"

#define IDL_GEN_PRINT_LINES 1

#ifdef IDL_GEN_PRINT_LINES
#define IDL_PRINTLINE(i)\
    idl_printIndent (i);\
    idl_fileOutPrintf (idl_fileCur(), "    /* Code generated by %s at line %d */\n",__FILE__,__LINE__);
#else
#define IDL_PRINTLINE(i)
#endif


const char *
idl_getLiteBasicTypeName(
    idl_typeBasic typeBasic);

const c_char *
idl_scopedLiteSequenceBasicTypeName (
    const idl_typeBasic typeBasic);

c_char *
idl_scopedLiteTypeName (
    const idl_typeSpec typeSpec);

#endif /* IDL_GENLITEHELPER_H */
