/*
 * Copyright (C) 2017 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#include <gtest/gtest.h>

#include <ignition/common/Console.hh>

#include "test_config.h"  // NOLINT(build/include)

#include "ignition/gui/Enums.hh"
#include "ignition/gui/DragDropModel.hh"

using namespace ignition;
using namespace gui;

/////////////////////////////////////////////////
TEST(DragDropModelTest, Mime)
{
  common::Console::SetVerbosity(4);

  auto model = new DragDropModel();
  ASSERT_TRUE(model != nullptr);

  auto it = new QStandardItem();
  ASSERT_TRUE(it != nullptr);

  it->setData("/example/URI", DataRole::URI_QUERY);
  model->insertRow(0, it);

  auto id = model->index(0, 0);

  QList<QModelIndex> ids;
  ids.push_back(id);

  EXPECT_EQ(model->mimeData(ids)->data("application/x-item"), "/example/URI");
}

