Java FACE API                                                            {#mainpage}
====================

[TOC]

A DDS Java implementation API for the Future Airborne Capability Environment (FACE) API

Getting started                                                                {#mainpage_gettingstarted}
===============

If you are new to the FACE API we would recommend that you start by looking at the documentation
provided by the opengroup: http://www.opengroup.org/face/information

A summary of examples, along with build/run instructions can be found on the
\subpage face_examples page.

In order to build and or run applications that use Java FACE the library `ddsface.jar` needs to be in the classPath.
This libraries can be found inside the `$OSPL_HOME/jar` directory.

API documentation                                                               {#mainpage_api}
=================

The namespaces below contain all of the major functionality of the Java FACE API.

- org::vortex::FACE

   + TS.java provides facilities for Initializing, Creating and Destroying a connection
      Getting Connection Parameters and Unregistering a callback.
   + DataTypeTS.java provides facilities for Sending and Receiving data. The DataType classes are generated by idlpp.


DataType generation:
--------------------
Idlpp can be used to generate the Java datatypes for the FACE api. The option -F can be used to generate the FACE specific datatypes.


Example command for code generation from the idl Foo.idl for standalone Java:

`idlpp -S -l java -F Foo.idl`

Logging:
--------
Default all errors that are reported by the FACE API are collected inside ospl-error.log. This behavior can be changed to directly logging to the commandline by setting the `OSPL_FACE_LOGGING` environment variable to true.

The logging can also be filtered by setting a log level. This level can be set by setting the `OSPL_FACE_LOGGING_LEVEL` environment value to one of the following values:
- SEVERE (highest value)
- WARNING
- INFO
- CONFIG
- FINE
- FINER
- FINEST (lowest value)
- ALL (log everything)

By default the level is ALL.

JavaDoc:
--------

A zipped version of the JavaDoc documentation for JavaFACE can be found inside the `$OSPL_HOME/docs/face/java` directory i.e. `ddsface-doc.jar`.

To use this jar inside Eclipse do the following:

1. Right click over the Project -> Build path -> Configure Build Path
2. In the new window, go to the "Libraries" tab.
3. Select the library `ddsface.jar` and expand it.
4. There are 4 child options. Select "Javadoc location" and click the "Edit" button on the right.
5. Now the `ddsface-doc.jar` can be added. press the "Validate" button to check everything is ok.

