/*
 *                         Vortex OpenSplice
 *
 *   This software and documentation are Copyright 2006 to TO_YEAR ADLINK
 *   Technology Limited, its affiliated companies and licensors. All rights
 *   reserved.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
#ifndef OSPL_DDS_CORE_DETAIL_MODULE_DOCS_HPP_
#define OSPL_DDS_CORE_DETAIL_MODULE_DOCS_HPP_

// Implementation

/**
 * @file
 * This file exists only to be fed to doxygen. There is quite
 * literally nothing else to see here.
 */

/**
 * @addtogroup isocpp_dcps ISO/IEC C++ API for DDS Data-centric Publish-Subscribe (DCPS)
 */
/** @{*/
/** @dir dds */
/** @}*/

/**
 * @addtogroup isocpp_dcps_domain Domain Module - ::dds::domain
 * @ingroup isocpp_dcps */
/** @{*/
/** @dir dds/domain */
/** @}*/


/**
 * @addtogroup isocpp_dcps_topic Topic Module- ::dds::topic
 * @ingroup isocpp_dcps */
/** @{*/
/** @dir dds/topic */
/** @}*/

/**
 * @addtogroup isocpp_dcps_pub Publication Module - ::dds::pub
 * @ingroup isocpp_dcps */
/** @{*/
/** @dir dds/pub */
/** @}*/


/**
 * @addtogroup isocpp_dcps_sub Subscription Module - ::dds::sub
 * @ingroup isocpp_dcps */
/** @{*/
/** @dir dds/sub */
/** @}*/

/**
 * @addtogroup isocpp_dcps_core Core / Common Module - ::dds::core
 * @ingroup isocpp_dcps */
/** @{*/
/** @dir dds/core */
/** @}*/


/**
 * @addtogroup examplesdcpsisocpp ISO/IEC C++ DCPS PSM Examples
 */
/** @{*/
/** @dir examples/common */
/** @}*/



/**
 * @ingroup isocpp_dcps
 */
namespace dds
{
/**
 * @ingroup isocpp_dcps_domain
 * @ingroup isocpp_dcps */
namespace domain
{
/** @ingroup isocpp_dcps_domain
 * @ingroup isocpp_dcps */
namespace qos
{
namespace detail {}
}
namespace detail {}
}
/**
 * @ingroup isocpp_dcps_topic
 * @ingroup isocpp_dcps */
namespace topic
{
/** @ingroup isocpp_dcps_topic
 * @ingroup isocpp_dcps */
namespace qos
{
namespace detail {}
}
namespace detail {}
}
/**
 * @ingroup isocpp_dcps_pub
 * @ingroup isocpp_dcps */
namespace pub
{
/** @ingroup isocpp_dcps_pub
 * @ingroup isocpp_dcps */
namespace qos
{
namespace detail {}
}
namespace detail {}
}
/**
 * @ingroup isocpp_dcps_sub
 * @ingroup isocpp_dcps */
namespace sub
{
/** @ingroup isocpp_dcps_sub
 * @ingroup isocpp_dcps */
namespace cond
{
namespace detail {}
}
/** @ingroup isocpp_dcps_sub
 * @ingroup isocpp_dcps */
namespace functors
{
namespace detail {}
}
/** @ingroup isocpp_dcps_sub
 * @ingroup isocpp_dcps */
namespace status {}
/** @ingroup isocpp_dcps_sub
 * @ingroup isocpp_dcps */
namespace qos
{
namespace detail {}
}
}
/**
 * @ingroup isocpp_dcps_core
 * @ingroup isocpp_dcps */
namespace core
{
/** @ingroup isocpp_dcps_core
 * @ingroup isocpp_dcps */
namespace policy
{
namespace detail {}
}
/** @ingroup isocpp_dcps_core
 * @ingroup isocpp_dcps */
namespace cond
{
namespace detail {}
}
/** @ingroup isocpp_dcps_core
 * @ingroup isocpp_dcps */
namespace status
{
namespace detail {}
}
namespace detail {}
}
}

// End of implementation

#endif /* OSPL_DDS_CORE_DETAIL_MODULE_DOCS_HPP_ */
