/*
 *                         Vortex OpenSplice
 *
 *   This software and documentation are Copyright 2006 to TO_YEAR ADLINK
 *   Technology Limited, its affiliated companies and licensors. All rights
 *   reserved.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
#include "idl_genPythonHelper.h"
#include "idl_genJavaHelper.h"
#include "os_stdlib.h"
#include "os_heap.h"

#include "idl_scope.h"
/*
 * Python keywords. This declaration is generated by the following Python script:

def python_keywords():
    import keyword
    print('static const char *python_keywords[%d] = {' % (len(keyword.kwlist)))
    for kw in keyword.kwlist:
        print('    "{}",'.format(kw))
    print('};')

python_keywords()

 */
static const char *python_keywords[33] = {
    "False",
    "None",
    "True",
    "and",
    "as",
    "assert",
    "break",
    "class",
    "continue",
    "def",
    "del",
    "elif",
    "else",
    "except",
    "finally",
    "for",
    "from",
    "global",
    "if",
    "import",
    "in",
    "is",
    "lambda",
    "nonlocal",
    "not",
    "or",
    "pass",
    "raise",
    "return",
    "try",
    "while",
    "with",
    "yield",
};

c_char *
idl_pythonId(
		const char *identifier)
{
	size_t i;

	for(i = 0; i < sizeof(python_keywords)/sizeof(char*); i ++) {
		if(strcmp(identifier,python_keywords[i]) == 0) {
			char *result = os_malloc(strlen(identifier) + 2);
			os_sprintf("%s_", identifier);
			return result;
		}
	}

	return os_strdup(identifier);
}

static c_char *
idl_scopePythonElementName (
    idl_scopeElement scope)
{
    return idl_scopeElementName(scope);
}


c_char *idl_scopeStackPython(
		idl_scope scope,
		const char *scopeSepp,
		const char *name)
{
    c_long si;
    c_long sz;
    c_char *scopeStack = NULL;
    c_char *Id;
    c_char *basename;

    assert (scopeSepp != NULL);
    basename = idl_scopeBasename(scope);
    scopeStack = idl_pythonId(basename);
    os_free(basename);

    for (si = 0, sz = idl_scopeStackSize(scope); si < sz; si++) {
        size_t slen;

        /* Translate the scope name to a Python identifier */
        Id = idl_pythonId(idl_scopePythonElementName(idl_scopeIndexed(scope, si)));
        /* allocate space for the current scope stack + the separator
         *and the next scope name
         */
        /* QAC EXPECT 5007; will not use wrapper */
        slen = strlen (scopeStack) + strlen (scopeSepp) + strlen (Id);
        scopeStack = os_realloc(scopeStack, slen + 1);
        /* Concatenate the separator */
        /* QAC EXPECT 5007; will not use wrapper */
        if (strlen(scopeStack)) {
            os_strcat(scopeStack, scopeSepp);
        }
        /* Concatenate the scope name */
        /* QAC EXPECT 5007; will not use wrapper */
        os_strcat (scopeStack, Id);
        os_free((void*)Id);
    }

    if (name) {
        /* A user identifier is specified */
        /* Translate the user identifier to a Java identifier */
        Id = idl_pythonId(name);
        /* allocate space for the current scope stack + the separator
         * and the user identifier
         */
        /* QAC EXPECT 5007; will not use wrapper */
        scopeStack = os_realloc(scopeStack, strlen(scopeStack)+strlen(scopeSepp)+strlen(Id)+1);
        /* Concatenate the separator */
        /* QAC EXPECT 5007; will not use wrapper */
        if (strlen(scopeStack)) {
            os_strcat(scopeStack, scopeSepp);
        }
        /* Concatenate the user identifier */
        /* QAC EXPECT 5007; will not use wrapper */
        os_strcat (scopeStack, Id);
        os_free((void*)Id);
    }

    /* return the scope stack representation */
    return scopeStack;

}

c_char *
idl_genPythonLiteralValueImage(
    c_value literal,
    c_type type)
{
    c_char * valueImg = NULL;

    if (literal.kind != V_BOOLEAN) {
        valueImg = idl_genJavaLiteralValueImage(literal, type);
    } else {
        valueImg = os_malloc(10);
        if (literal.is.Boolean) {
            snprintf(valueImg, 10, "True");
        } else {
            snprintf (valueImg, 10, "False");
        }
    }
    return valueImg;
}

