# Specify target name and target location.
TARGET_DLIB     := dbtisocpp2face
TARGET_LINK_DIR := $(OSPL_OUTER_HOME)/testsuite/lib/$(SPLICE_TARGET)

# Now include the generic rules for building isoCPP test applications.
include     $(OSPL_HOME)/setup/makefiles/test_idl_isocpp2.mak
include     $(OSPL_OUTER_HOME)/testsuite/dbt/api/dcps/isocpp2/common.mak

ISOCPP2_DIR     := $(OSPL_OUTER_HOME)/testsuite/dbt/api/dcps/isocpp2

ifneq (,$(or $(findstring win32,$(SPLICE_TARGET)), $(findstring win64,$(SPLICE_TARGET)), $(findstring wince,$(SPLICE_TARGET))))
   IDLPPFLAGS += -P DBT_API,dbt_api_if.h
   CPPFLAGS   += -DOSPL_BUILD_DBT_API
endif

CXXFLAGS += $(SHCFLAGS)

# If specific linker options for CXX are set, use those to overrule the SHLDFLAGS
ifneq (,$(SHLDCXXFLAGS))
SHLDFLAGS = $(SHLDCXXFLAGS)
endif

# Fine tune the Linker flags.
LDFLAGS  += $(SHLDFLAGS)
LDLIBS   += $(SHLDLIBS)

EXP_HEADERS := $(addprefix ../../include/$(SPLICE_TARGET)/,$(filter $(patsubst %.idl,%,$(EXP_IDL_FILES))%,$(IDL_H)))


../../include/$(SPLICE_TARGET):
	@mkdir -p ../../include/$(SPLICE_TARGET)

../../include/$(SPLICE_TARGET)/%.hpp : %.hpp
	@cp $< $@

../../include/$(SPLICE_TARGET)/%.h: %.h
	@cp $< $@

$(DEPENDENCIES): ../../include/$(SPLICE_TARGET) $(EXP_HEADERS)

