/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.pipeline;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JvmStreamsKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0003\u0007\b\tB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\n\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/ml/tools/model/pipeline/VFSNode;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "Companion", "Directory", "File", "Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$Directory;", "Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$File;", "ml-tools"})
public abstract class VFSNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;

    private VFSNode(String name) {
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public /* synthetic */ VFSNode(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$Companion;", "", "()V", "fromZipInputStream", "Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$Directory;", "zipInputStream", "Ljava/util/zip/ZipInputStream;", "ml-tools"})
    @SourceDebugExtension(value={"SMAP\nVFSNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VFSNode.kt\ncom/jetbrains/ml/tools/model/pipeline/VFSNode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n766#2:94\n857#2,2:95\n800#2,11:97\n1#3:108\n*S KotlinDebug\n*F\n+ 1 VFSNode.kt\ncom/jetbrains/ml/tools/model/pipeline/VFSNode$Companion\n*L\n75#1:94\n75#1:95,2\n78#1:97,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Directory fromZipInputStream(@NotNull ZipInputStream zipInputStream) {
            Intrinsics.checkNotNullParameter((Object)zipInputStream, (String)"zipInputStream");
            Directory root = new Directory("/", null, 2, null);
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                void $this$filterTo$iv$iv;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String[] stringArray = new String[]{"/"};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = ((CharSequence)it).length() > 0;
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List pathParts = (List)destination$iv$iv;
                Directory currentDir = null;
                currentDir = root;
                for (String part : CollectionsKt.dropLast((List)pathParts, (int)1)) {
                    Directory existingDir;
                    Directory directory;
                    Object v2;
                    block7: {
                        Iterator $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv = currentDir.getChildren();
                        boolean $i$f$filterIsInstance22 = false;
                        Iterable element$iv$iv = $this$filterIsInstance$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv$iv2 = iterator.next();
                            if (!(element$iv$iv2 instanceof Directory)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        Iterable $i$f$filterIsInstance22 = (List)destination$iv$iv2;
                        $this$filterIsInstanceTo$iv$iv = $i$f$filterIsInstance22.iterator();
                        while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                            Object t = $this$filterIsInstanceTo$iv$iv.next();
                            Directory it = (Directory)t;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)part)) continue;
                            v2 = t;
                            break block7;
                        }
                        v2 = null;
                    }
                    if ((directory = (existingDir = (Directory)v2)) == null) {
                        Directory directory2;
                        Directory it = directory2 = new Directory(part, null, 2, null);
                        boolean bl = false;
                        currentDir.getChildren().add(it);
                        directory = directory2;
                    }
                    currentDir = directory;
                }
                if (!entry.isDirectory()) {
                    byte[] content = ByteStreamsKt.readBytes((InputStream)zipInputStream);
                    currentDir.getChildren().add(new File((String)CollectionsKt.last((List)pathParts), content));
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
            return root;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bJ\u0013\u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$Directory;", "Lcom/jetbrains/ml/tools/model/pipeline/VFSNode;", "name", "", "children", "", "(Ljava/lang/String;Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "follow", "path", "Ljava/nio/file/Path;", "get", "getDirectory", "getDirectoryOrNull", "getFile", "Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$File;", "ml-tools"})
    @SourceDebugExtension(value={"SMAP\nVFSNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VFSNode.kt\ncom/jetbrains/ml/tools/model/pipeline/VFSNode$Directory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,93:1\n1#2:94\n*E\n"})
    public static final class Directory
    extends VFSNode {
        @NotNull
        private final List<VFSNode> children;

        public Directory(@NotNull String name, @NotNull List<VFSNode> children) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            super(name, null);
            this.children = children;
        }

        public /* synthetic */ Directory(String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                list = new ArrayList();
            }
            this(string, list);
        }

        @NotNull
        public final List<VFSNode> getChildren() {
            return this.children;
        }

        @Nullable
        public final VFSNode get(@NotNull String name) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Iterable iterable = this.children;
                for (Object t : iterable) {
                    VFSNode it = (VFSNode)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final VFSNode follow(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            VFSNode node = this;
            for (Path element : path) {
                if (!(node instanceof Directory)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Intrinsics.checkNotNull((Object)element);
                if (this.get(PathsKt.getName((Path)element)) != null) continue;
                throw new FileNotFoundException("When following the path " + path + ", " + element + " does not exist");
            }
            return node;
        }

        @NotNull
        public final Directory getDirectory(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            VFSNode node = this.get(name);
            if (!(node instanceof Directory)) {
                if (node instanceof File) {
                    throw new FileNotFoundException("Not a directory: " + name);
                }
                throw new FileNotFoundException("Not found: " + name);
            }
            return (Directory)node;
        }

        @Nullable
        public final Directory getDirectoryOrNull(@NotNull String name) {
            Directory directory;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            VFSNode node = this.get(name);
            if (node instanceof Directory) {
                directory = (Directory)node;
            } else {
                if (node instanceof File) {
                    throw new FileNotFoundException("Not found: " + name);
                }
                directory = null;
            }
            return directory;
        }

        @NotNull
        public final File getFile(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            VFSNode node = this.get(name);
            if (!(node instanceof File)) {
                if (node instanceof Directory) {
                    throw new FileNotFoundException("Not a directory: " + name);
                }
                throw new FileNotFoundException("Not found: " + name + ", available: " + this.children);
            }
            return (File)node;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R!\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/ml/tools/model/pipeline/VFSNode$File;", "Lcom/jetbrains/ml/tools/model/pipeline/VFSNode;", "name", "", "content", "", "(Ljava/lang/String;[B)V", "asJson", "Lkotlinx/serialization/json/JsonElement;", "getAsJson$annotations", "()V", "getAsJson", "()Lkotlinx/serialization/json/JsonElement;", "asJson$delegate", "Lkotlin/Lazy;", "getContent", "()[B", "ml-tools"})
    public static final class File
    extends VFSNode {
        @NotNull
        private final byte[] content;
        @NotNull
        private final Lazy asJson$delegate;

        public File(@NotNull String name, @NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(name, null);
            this.content = content;
            this.asJson$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JsonElement>(this){
                final /* synthetic */ File this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final JsonElement invoke() {
                    JsonElement jsonElement;
                    Closeable closeable = new ByteArrayInputStream(this.this$0.getContent());
                    Throwable throwable = null;
                    try {
                        ByteArrayInputStream it = (ByteArrayInputStream)closeable;
                        boolean bl = false;
                        Json $this$decodeFromStream$iv = (Json)Json.Default;
                        boolean $i$f$decodeFromStream = false;
                        SerializersModule serializersModule = $this$decodeFromStream$iv.getSerializersModule();
                        KType kType = Reflection.typeOf(JsonElement.class);
                        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                        jsonElement = (JsonElement)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType)), (InputStream)it);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return jsonElement;
                }
            }));
        }

        @NotNull
        public final byte[] getContent() {
            return this.content;
        }

        @NotNull
        public final JsonElement getAsJson() {
            Lazy lazy = this.asJson$delegate;
            return (JsonElement)lazy.getValue();
        }

        public static /* synthetic */ void getAsJson$annotations() {
        }
    }
}

