%{
#include <stdio.h>
#include <string.h>

#define YYSTYPE char *

int yydebug=0;

void yyerror(const char *str)
{
	fprintf(stderr,"errore: %s\n",str);
}

int yywrap()
{
	return 1;
}

main()
{
	yyparse();
}

%}

%token PAROLA NOMEFILE DOPPIOAPICE APERTAGRAFFA CHIUSAGRAFFA PUNTOEVIRGOLA ZONETOK FILETOK

%%

comandi:
       	|
	comandi comando PUNTOEVIRGOLA
	;


comando:
       	imposta_zone
	;

imposta_zone:
	ZONETOK nomefradoppiapici contenutozone
	{
		printf("Zone completa trovata per '%s'\n",$2);
	}
	;

contenutozone:
	APERTAGRAFFA dichiarazionizone CHIUSAGRAFFA

nomefradoppiapici:
	DOPPIOAPICE NOMEFILE DOPPIOAPICE
        {
         	$$=$2;
        }
	;


dichiarazionizone:
		 	|
	dichiarazionizone dichiarazionezona PUNTOEVIRGOLA
	;

dichiarazionezona:
	     	dichiarazioni
	|
	FILETOK nomefradoppiapici
	{
		printf("Nome di file zone '%s' trovato\n",$2);
	}
	;

blocco:
      	APERTAGRAFFA dichiarazionizone CHIUSAGRAFFA PUNTOEVIRGOLA
	;

dichiarazioni:
	| dichiarazioni dichiarazione
	;

dichiarazione: PAROLA | blocco | nomefradoppiapici
