/***************************************************************************
                          knewaccount.cpp  -  description
                             -------------------
    begin                : Thu Aug 29 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: knewaccount.cpp,v 1.2 2002/09/04 02:04:16 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <kmessagebox.h>
 
#include "knewaccount.h"
#include "kbudget.h"
#include "kbudgetdoc.h"

KNewAccount::KNewAccount(KBudgetApp* parent)
  : KDialogBase(parent, "knewaccount", false, i18n("New Account"), Ok|Cancel), mainWin(parent)
{
  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QGridLayout* grid = new QGridLayout(page);
  
  QLabel* lb = new QLabel(i18n("Name:"), page);
  grid->addWidget(lb, 0, 0);
  name = new KLineEdit(page);
  grid->addWidget(name, 0, 1);
  
  lb = new QLabel(i18n("Type:"), page);
  grid->addWidget(lb, 1, 0);
  type = new KComboBox(page);
  grid->addWidget(type, 1, 1);
  
  lb = new QLabel(i18n("Initial balance:"), page);
  grid->addWidget(lb, 2, 0);
  initialBalance = new KDoubleNumInput(page);
  grid->addWidget(initialBalance, 2, 1);

  type->insertItem(i18n("Income"));
  type->insertItem(i18n("Expense"));
  type->insertItem(i18n("Cash"));

  initialBalance->setPrecision(2);
}

KNewAccount::~KNewAccount()
{
}

void KNewAccount::slotOk()
{
  QString acctName = name->text();
  int acctType = type->currentItem();
  float balance = (float)initialBalance->value();

  if ( !acctName.stripWhiteSpace().length() )
    KMessageBox::sorry(0, i18n("You must enter an account name to create an account."));
  else {
    KBudgetDoc* doc = mainWin->getDocument();
    doc->newAccount((Account::types)acctType, acctName, balance);
    KDialogBase::slotOk();
  }
}
