/***************************************************************************
                          kbudgetview.h  -  description
                             -------------------
    begin                : Sat Aug 10 16:03:35 CST 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: kbudgetview.h,v 1.13 2002/09/06 02:45:16 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBUDGETVIEW_H
#define KBUDGETVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <qdatetime.h>
#include <qtable.h>

#include "account.h"
#include "kbudgeteditor.h"

class KBudgetDoc;

/** The KBudgetView class provides the view widget for the KBudgetApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KBudgetView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KBudgetApp class to manipulate and display
 * the document structure provided by the KBudgetDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KBudgetView : public QVBox
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    KBudgetView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KBudgetView();

	/** sets the display to the month and year specified */
	void selectMonth(int month, int year);
	/** rebuilds the summary display */
	void rebuildSummary();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a KBudgetApp instance as a parent
     * widget to get to the window document pointer by calling the KBudgetApp::getDocument() method.
     *
     * @see KBudgetApp#getDocument
     */
    KBudgetDoc *getDocument() const;

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);

    /** returns the id of the currently selected account or -1 */
    int currentAccount() const;

  public slots:
	/** slot for "previous" button in period display */
	void slotPrevClick();
	/** slot for month combobox activate */
	void slotMonthActivate(int month);
	/** slot for year numinput change */
	void slotYearChange(int year);
	/** slot for "next" button in period display */
	void slotNextClick();
	/** updates the view */
	void slotAccountAddDel();
	/** called when an account is modified */
	void slotAccountChanged(int id);
	/** called when the table selection is changed */
	void slotSelectionChanged();
	/** rename the currently selected account */
	void slotRenameAccount();
	/** opens a context menu */
	void slotContextMenuRequested(int row, int col, const QPoint & pos);
	/** an account name is changed */
	void slotValueChanged(int row, int col);

  signals:
    /** set the enabled status for an account delete button */
    void accountSelectionStatus(bool);
	
  private:
    /** returns the position in the array of the account at row, or -2 if
      * the row is invalid, or -1 if the row doesn't contain an account. The
      * return value is (position << 2)+type (type being the array that the position
      * is in) */
    int accountAt(int row);
    
    /** foreground colour for the income category */
    QColor iColour;
    /** foreground colour for the expenses category */
    QColor eColour;
    /** foreground colour for the accounts category */
    QColor cColour;
  
	enum { VT_MONTH, VT_YEAR, VT_NONE } type;
	QDate from;
	QDate to;
	void cleanupPeriodDisplay();

	/** creates the summary display */
	void createSummary();
	/** add a header to the summary */
	void addSummaryHeader(int row, QString text/*, QColor color*/);
	/** add a regular row to the summary */
	void addSummaryRow(int row, QString text1, QString text2, QString text3, QString text4/*, QColor color*/);
	/** add a summary section */
	void createSection(int number, int &row);

	// widgets to display the current period and its controls
	QHBox* periodDisplay;
	QPushButton* prevButton;
	QLabel* spacer1;
	KComboBox* month;
	KIntNumInput* year;
	QLabel* spacer2;
	QPushButton* nextButton;

	// main display widgets
	QTable* dtab;

	// budget value editor
	KBudgetEditor* editor;

	// cached list of accounts
	QValueList<Account> accounts[3];
	/** currently selected account */
	int selAccount;
};

#endif // KBUDGETVIEW_H
