/***************************************************************************
                           generalwidgetimpl.cpp
                           ---------------------
    begin                : Sun Sep 6 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kdebug.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kfiledialog.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qlistview.h>
#include <qspinbox.h>
#include <qpushbutton.h>
#include "generalwidgetimpl.h"
#include "cfgdata.h"
#include "channelstore.h"
#include "sourcemanager.h"
#include "kdetv.h"

GeneralWidgetImpl::GeneralWidgetImpl(QWidget* parent, Kdetv* ktv, ConfigData* cfg)
    : GeneralWidget(parent),
      SettingsDialogPage(i18n("General"),
                         i18n("Configure General Options"),
                         "misc"),
      _ktv(ktv),
      _srcm(ktv->sourceManager()),
      _cfg(cfg)
{
    connect(_edit, SIGNAL( clicked() ),
            this, SLOT( slotEditClicked() ));
    connect(_fileList, SIGNAL( doubleClicked(QListViewItem*) ),
            this, SLOT( slotEditClicked() ));
    connect(_fileList, SIGNAL( selectionChanged() ),
            this, SLOT( slotSelectionChanged() ));
    _edit->setEnabled(false);
}

GeneralWidgetImpl::~GeneralWidgetImpl()
{
}

void GeneralWidgetImpl::setup()
{
    // _maxRes->setChecked(_cfg->maxResolution);
    _channelNumberingStart->setValue(_cfg->channelNumberingStart);
    _showSelected->setChecked(_cfg->showSelectedOnly);
    _keypressInterval->setValue(_cfg->maxKeypressInterval);
    _mouseUpIsHigherNumber->setChecked(_cfg->mouseWheelUpIsChUp);
    _mouseUpIsLowerNumber->setChecked(!_cfg->mouseWheelUpIsChUp);

    const QStringList& devs = _srcm->deviceList();
    _fileList->clear();

    for (QStringList::const_iterator it = devs.begin();
         it != devs.end();
         ++it) {
        _cfg->pluginConfigHandle()->setGroup(*it);
        new QListViewItem(_fileList, *it, _cfg->pluginConfigHandle()->readPathEntry("Channel File", _ktv->channels()->defaultFileName()));
    }
}

void GeneralWidgetImpl::defaults()
{
    const ConfigData& def = ConfigData::getDefaultConfig();

    // _maxRes->setChecked(def.maxResolution);
    _channelNumberingStart->setValue(def.channelNumberingStart);
    _showSelected->setChecked(def.showSelectedOnly);
    _keypressInterval->setValue(def.maxKeypressInterval);
    _mouseUpIsHigherNumber->setChecked(def.mouseWheelUpIsChUp);

    const QStringList& devs = _srcm->deviceList();
    _fileList->clear();

    for (QStringList::const_iterator it = devs.begin();
         it != devs.end();
         ++it) {
        new QListViewItem(_fileList, *it, _ktv->channels()->defaultFileName());
    }
}

void GeneralWidgetImpl::apply()
{
    // _cfg->maxResolution         = _maxRes->isChecked();
    _cfg->channelNumberingStart = _channelNumberingStart->value();
    _cfg->showSelectedOnly      = _showSelected->isChecked();
    _cfg->maxKeypressInterval   = _keypressInterval->value();
    _cfg->mouseWheelUpIsChUp    = _mouseUpIsHigherNumber->isChecked();

    bool changed = false;
    for (QListViewItemIterator it(_fileList);
         *it != 0;
         ++it) {
        _cfg->pluginConfigHandle()->setGroup((*it)->text(0));
        if (_cfg->pluginConfigHandle()->readPathEntry("Channel File", _ktv->channels()->defaultFileName()) != (*it)->text(1)) {
            changed = true;
        }
    }

    if (changed) {
        _ktv->saveChannels();
        for (QListViewItemIterator it(_fileList);
             *it != 0;
             ++it) {
            _cfg->pluginConfigHandle()->setGroup((*it)->text(0));
            _cfg->pluginConfigHandle()->writePathEntry("Channel File", (*it)->text(1));
            if ( (_ktv->sourceManager()->hasDevice())                &&
                 ((*it)->text(0) == _ktv->sourceManager()->device())    ) {
                _cfg->channelFile = (*it)->text(1);
            }
        }
        _ktv->reloadChannels();
    }
}

void GeneralWidgetImpl::slotEditClicked()
{
    if (0L == _fileList->selectedItem()) return;

    QString fn = KFileDialog::getOpenFileName(KGlobal::dirs()->saveLocation("kdetv"),
                                              QString("*"),
                                              this,
                                              i18n("Select Channel File"));
    if (!fn.isEmpty()) {
        _fileList->selectedItem()->setText(1, fn);
    }
}

void GeneralWidgetImpl::slotSelectionChanged()
{
    _edit->setEnabled(0L != _fileList->selectedItem());
}

#include "generalwidgetimpl.moc"
