/***************************************************************************
                          devicewidgetimpl.h  -  description
                             -------------------
    begin                : Mon Jun 3 2002
    copyright            : (C) 2002 by Kevin Hessels
    email                : khessels@shaw.ca
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef DEVICEWIDGETIMPL_H
#define DEVICEWIDGETIMPL_H

#include <devicewidget.h>

#include "pluginfactory.h"
#include "settingsdialogpage.h"

class ConfigData;
class Kdetv;
class SourceManager;


/**
 * @author Kevin Hessels and Dirk Ziegelmeier
 */

class DeviceWidgetImpl : public DeviceWidget, public SettingsDialogPage
{
    Q_OBJECT

public: 
    DeviceWidgetImpl(QWidget *, Kdetv *, ConfigData*);
    ~DeviceWidgetImpl();

    /** set Kdetv object to contain the currently selected device */
    void device(Kdetv *);
    /** Update the dialog to display the currently selected device, if it exists */
    void setCurrentDevice();

    virtual void setup();
    virtual void apply();
    virtual void defaults();


protected slots:
    void slotChangeSources(const QString &);


private:
    Kdetv*         _ktv;
    SourceManager* _srcm;
    ConfigData*    _cfg;
};

#endif
