// -*- c++ -*-
/***************************************************************************
                          channelwidgetimpl.h  -  description
                             -------------------
    begin                : Wed Jun 12 2002
    copyright            : (C) 2002 by Kevin Hessels
    email                : khessels@shaw.ca
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef CHANNELWIDGETIMPL_H
#define CHANNELWIDGETIMPL_H

#include <qlistview.h>

#include "channelstore.h"
#include "channelwidget.h"
#include "settingsdialogpage.h"

class Kdetv;
class SourceManager;
class Channel;

/**
 * @author Kevin Hessels, Dirk Ziegelmeier
 */

class ChannelListViewItem : public QObject, public QCheckListItem
{
    Q_OBJECT
public:
    ChannelListViewItem(KListView *, Channel*);
    ~ChannelListViewItem();

    int compare(QListViewItem *, int, bool) const;

    int rtti() const;

    Channel *c;

public slots:
    void updateFields();
};


/***************************************************************************/

class ConfigData;
class KConfig;

class ChannelWidgetImpl : public ChannelWidget, public SettingsDialogPage
{
    Q_OBJECT

public:
    ChannelWidgetImpl(QWidget *, Kdetv *, ConfigData *);
    ~ChannelWidgetImpl();


public slots:
    void updateChannels();

    void setup();
    void apply();
    void defaults();
    void cancel();

private:
    void createChannelList(ChannelStore *);

    void setItemInEditor( ChannelListViewItem * );
    ChannelListViewItem *getItemInEditor();

    ChannelListViewItem *_itemInEditor;
    ChannelStore *_cs;
    Kdetv* _ktv;
    SourceManager* _srcm;
    ConfigData* _cfg;

private slots:
    void slotListItemClicked();
    void slotRenumberClicked();
    void slotNewClicked();
    void slotChangeChannel();
    void slotEditClicked();
    void slotRenameClicked();
    void slotRemoveClicked();
    void slotMoveUpClicked();
    void slotMoveDownClicked();
    void slotRenameItem(QListViewItem*);
    void slotKillDoublesClicked();
    void slotPropertiesFinished();
};

#endif
