/* 
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <endian.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/mman.h>

#include <qimage.h>
#include <kdebug.h>

#include "v4ldevcamera.h"

//////////////////////////////////////////////////////////////////////////////
////////////////////////  Camera Implementation   ////////////////////////////
//////////////////////////////////////////////////////////////////////////////

V4LCamera::V4LCamera(int fd, const QString &name, int channels, int type, int minw, int minh, int maxw, int maxh) 
: V4LDev(fd, name, channels, type, minw, minh, maxw, maxh) {
	struct video_window vw;

	_isCamera = true;
	memset(&vw, 0, sizeof(struct video_window));
	int rc = ioctl(_fd, VIDIOCGWIN, &vw);
	if (rc >= 0) {
		vw.width = maxw;
		vw.height = maxh;
		vw.x = 0;
		vw.y = 0;
		vw.flags = 0;
		ioctl(_fd, VIDIOCSWIN, &vw);
		if (rc < 0) {
			kdDebug() << "VIDIOCSWIN: " << rc << endl;
		}
	} else {
		kdDebug() << "VIDIOCGWIN: " << rc << endl;
	}
}


V4LCamera::~V4LCamera() {
}



