/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>

#include "mainwindow.h"
#include <kdetv_version.h>

int main(int argc, char **argv)
{
    static KCmdLineOptions options[] = {
        { 0, 0, 0 }
    };

    KAboutData about("kdetv", I18N_NOOP("kdetv"),
                     KDETV_VERSION,
                     I18N_NOOP("kdetv: TV for KDE"),
                     KAboutData::License_GPL,
                     I18N_NOOP("(c) 2002-2004 The kdetv Developers"), 0,
                     "http://www.kwintv.org/");
    about.addAuthor("George Staikos",    "Primary author and maintainer",      "staikos@kde.org");
    about.addAuthor("Dirk Ziegelmeier",  "Developer and maintainer", 	      "dziegel@gmx.de");
    about.addAuthor("Richard Moore",     "GUI design, plugins",                "rich@kde.org");
    about.addAuthor("Kevin Hessels",     "Configuration dialog",               "khessels@shaw.ca");
    about.addAuthor("Stefan Hellwig",    "Webmaster, developer",               "stefan@stefanhellwig.de");
    about.addAuthor("Zsolt Rizsanyi",    "Infrared remote support, developer", "rizsanyi@users.sourceforge.net");
    about.addAuthor("Dawit Alemayehu",   "Developer",                          "adawit@kde.org");

    about.addCredit("Koos Vriezen",      "V4L plugin fixes",                   "koos.vriezen@xs4all.nl");
    about.addCredit("Hans-Peter Jansen", "Ideas and fixes",                    "hpj@urpla.net");

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication a;
//    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    MainWindow mw;
    mw.setCaption( i18n("kdetv") );

    a.setMainWidget( &mw );
    mw.show();

    int retval = a.exec();
    return retval;
}

