/***************************************************************************
                          search.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: search.cpp
	Last generated: Thu Jul 20 23:16:10 2000

 *********************************************************************/

#include "search.h"
#include <qwhatsthis.h>
#include <klocale.h>

#define Inherited SearchData


Search::Search(KaspaURL url, Sql *conn, QWidget* parent, const char* name):
	Inherited(parent, name) {
	_url=url;
	setTabOrder(search, start);
	setTabOrder(start, fulltext);
	setTabOrder(fulltext, exact);
	setTabOrder(exact, result);	
	QWhatsThis::add(search,		i18n("A input line to type in your query. The search matches substrings " \
																 "unless 'exact search' is checked."));
	QWhatsThis::add(start, 		i18n("Press this button to delete your database."));	
	QWhatsThis::add(fulltext,	i18n("Check this box to extend your search on the fulltext index."));
	QWhatsThis::add(result,		i18n("The results of the search double-click the entrys to open them " \
																 "or click with the right mouse button to open the context menu."));		
	QWhatsThis::add(exact,		i18n("Check this to match exactly the search string."));

  connect(result,   SIGNAL(open(Oid, const char *, bool)), this, SLOT(open(Oid, const char *, bool)));
	connect(search, SIGNAL(returnPressed()), this, SLOT(startSearch()));
  emit setCaption(i18n("Search"));
	try {
		base=new MyKaspaBase(conn);
		ASSERT(base);
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}

Search::~Search() { delete base; }

void Search::startSearch() {
	try {
		if(!strlen(search->text())) return;
		setWorkingGUI();

		QString w="(";
    QString e;
		if(exact->isChecked()) {
      w+="%1='";
      w+=esc4sql(search->text());
      w+="'";
    }
		else
    {
      e=" ~* '";

      QStringList tokens=QStringList::split(QRegExp("\\s+"), search->text());
      if(tokens.count()<1) return;

      for (QStringList::Iterator it = tokens.begin(); it != tokens.end(); ++it )
          w+="%1"+e+esc4sql((*it).latin1())+"' and ";

//		w+=esc4sql(search->text()); w+="'";

      w=w.left(w.length()-5);
    }
    w+=")";

		QString s("where "); s+=QString(w).replace(QRegExp("%1"),"part.title")+" or "+
        QString(w).replace(QRegExp("%1"),"part.memo")+" or "+
        QString(w).replace(QRegExp("%1"),"part.language");
		result->set(base->getPartTitles(s, true));

		s="where "+QString(w).replace(QRegExp("%1"),"publication.title")+" or "+
        QString(w).replace(QRegExp("%1"),"publication.memo")+" or "+
        QString(w).replace(QRegExp("%1"),"publication.subtitle")+" or "+
        QString(w).replace(QRegExp("%1"),"publication.editor")+" or "+
        QString(w).replace(QRegExp("%1"),"publication.howpublished")+" or "+
        QString(w).replace(QRegExp("%1"),"publication.hidingplace")+" or "+
        QString(w).replace(QRegExp("%1"),"publication.organization");
		result->append(base->getPublTitles(s));

		s="where "+QString(w).replace(QRegExp("%1"),"note.title")+" or "+
        QString(w).replace(QRegExp("%1"),"note.memo");
		result->append(base->getNoteTitles(s));

		s="where "+QString(w).replace(QRegExp("%1"),"author.lastname")+" or "+
        QString(w).replace(QRegExp("%1"),"author.memo")+" or "+
        QString(w).replace(QRegExp("%1"),"author.firstname")+" or "+
        QString(w).replace(QRegExp("%1"),"author.pseudonym")+" or "+
        QString(w).replace(QRegExp("%1"),"author.country");
		result->append(base->getAuthorNames(s));

		s="where "+QString(w).replace(QRegExp("%1"),"publisher.name");
		result->append(base->getPublisherNames(s));

		if(fulltext->isChecked()) {
      s="where "+QString(w).replace(QRegExp("%1"),"partdata.astext");
      result->append(base->getPartDataNames(s, true));
		}	

		setupGUI();
	} catch(KaspaErr& err) {
		handleWarning(err);
	}
}


void Search::open(Oid o, const char *data, bool w) {
	if(!strcmp(data, "note")) requestNote(o, w);
	if(!strcmp(data, "publication")) requestPublication(o, w);
	if(!strcmp(data, "part")) requestPart(o, w);
	if(!strcmp(data, "partmemo")) requestPartMemo(o, w);
	if(!strcmp(data, "author")) requestAuthor(o, w);
	if(!strcmp(data, "publisher")) requestPublisher(o, w);
	if(!strcmp(data, "bibliography")) requestBibliography(o, w);
	if(!strcmp(data, "partdata")) requestHTMLData(o, w);
}






