/***************************************************************************
                          parser.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: parser.h
	Last generated: Tue Jul 25 23:51:50 2000

 *********************************************************************/

#ifndef Parser_included
#define Parser_included

#include "parserdata.h"
#include <kprocess.h>
#include "kaspaurl.h"
#include <qstrlist.h>

class Parser : public ParserData
{
    Q_OBJECT

private:
		Parser(const Parser&);
		Parser& operator=(const Parser&);
		KaspaURL _url;
		char *p;
		QStrList masks;
		KProcess process;
		QString outbuf;
		int cutwords;

public:
		bool closeRequest() { if(process.isRunning()) return false; else return true; }
		virtual bool isValid() { return true; }
		virtual bool isWorking() { return process.isRunning(); }
		virtual bool isReadOnly() { return false; }
		const char *url() { return p; }
		void setInvalidGUI() { ParserData::setInvalidGUI(); lockGUI(); }
		void setWorkingGUI();
		void setReadWriteGUI();
		void setReadOnlyGUI();
		void setLimit(int limit);
		void setMasks(QStrList m);

		Parser(int limit, QStrList m, KaspaURL url, Sql *conn, QWidget* parent = 0L, const char* name = 0L);
		void start(bool rebuild);
	  virtual ~Parser();

public slots:
    virtual void cancelParsing() { 	process.kill(SIGTERM); }
    virtual void startParsing();
		void slotHandleExit(KProcess* p);
		void slotHandleStdout (KProcess *proc, char *buffer, int buflen);
};
#endif // Parser_included




