/***************************************************************************
                          filelinklistbox.cpp  -  description
                             -------------------
    begin                : Fri Aug 31 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filelinklistbox.h"
#include <qprogressdialog.h>
#include <qstrlist.h>
#include <klocale.h>
#include "partdatabase.h"
#include <qcursor.h>

FileLinkListBox::FileLinkListBox(QWidget *parent, const char *name ) : LinkListBox(parent,name) {
  setAcceptDrops(true);
  setSelectionMode(Extended);
	dndpop.insertItem(i18n("Copy into database"), 1000);
	dndpop.insertItem(i18n("Create reference"), 1001);
  pop.insertSeparator();
	pop.insertItem(i18n("Delete file"), this, SLOT(slotDeleteFiles()));
	pop.insertItem(i18n("Export files"), this, SLOT(slotExportFiles()));
}


FileLinkListBox::~FileLinkListBox(){
}


void FileLinkListBox::dragEnterEvent(QDragEnterEvent* e)
{
  e->accept(QUriDrag::canDecode(e));
}

void FileLinkListBox::slotDeleteFiles() {
 	emit deleteFiles();
}

void FileLinkListBox::slotExportFiles() {
 	emit exportFiles();
}

void FileLinkListBox::dropEvent(QDropEvent* e)
{
  QStrList list;
  list.setAutoDelete(true);
  // This should never happen, but anyway...
  if(!QUriDrag::decode(e, list))
    return;

  int sel=dndpop.exec(QCursor::pos());
  if(sel==-1) return;

  emit save();
  if(sel==1000)
    emit importFiles(list);
  else
    emit createReferences(list);
  emit reset();
}
