/***************************************************************************
                          str.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Sep 4 2000                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "str.h"
#include <math.h>
#include <alloc.h>

char *int2str(int i) {
  int size;
  if(i==0) size=2;
  else size=int(floor(log10(abs(i)))+2);
	char *buffer = (char *) malloc (size);
	assert(buffer);
	int r=snprintf(buffer, size, "%i", i);
	assert(r==size-1);
	return buffer;
}

char *uint2str(unsigned int i) {
  int size;
  if(i==0) size=2;
  else size=int(floor(log10(abs(i)))+2);
	char *buffer = (char *) malloc (size);
	assert(buffer);
	int r=snprintf(buffer, size, "%u", i);
	assert(r==size-1);
	return buffer;
}

char *mystrdup(const char *s) {
	char *t=new char[strlen(s)+1];
	strcpy(t, s);
	return t;
}

/************/

StrErr::StrErr(const char *s=0): KaspaErr(s) {};

/************/

Str::Str(){
	s = (char *)malloc(sizeof(char));
	*s=0;
}

Str::Str(const char *str){
	s = (char *)malloc(sizeof(char)*(strlen(str)+1));
	assert(s);
	strcpy(s, str);
}

Str::Str(Str& str) {
	s = (char *)malloc(sizeof(char)*(str.length()+1));
	assert(s);
	strcpy(s, str.data());
}

Str::~Str(){
	if(s) free(s);
}

bool Str::resize(int len) {
	char *t=(char *)realloc(s, len);
	if(t) s=t;
	return bool(t);
}

const char *Str::data() const {
	return s;
}

char& Str::operator[] (int i) {
	if(i>length()) throw StrErr("Index out of Range!");
	return s[i];
}

const char& Str::operator[] (int i) const {
	if(i>length()) throw StrErr("Index out of Range!");
	return s[i];
}

Str& Str::operator+= (const char *str) {
	if(!resize(length()+strlen(str)+1)) return *this;
	strcat(s, str);
	return *this;
}

Str& Str::operator+= (int i) {
	*this+=int2str(i);
	return *this;
}

Str& Str::operator+= (unsigned int i) {
	*this+=uint2str(i);
	return *this;
}


Str& Str::operator+= (char c) {
	int len=length();
	if(!resize(len+2)) return *this;
	s[len]=c;
	s[len+1]=0;
	return *this;
}

Str& Str::operator= (const Str &str) {
	if(this==&str) return *this;

	if(s) free(s);
	s=0L;
	str.copy(s);
	return *this;
}

Str& Str::operator= (const char *str) {
	if(s) free(s);
	s=0L;
	s = (char *)malloc(sizeof(char)*(strlen(str)+1));
	strcpy(s, str);
	return *this;
}

Str::operator const char *() const {
	return s;
}

int Str::length() const {
	return strlen(s);
}

void Str::copy(char *str) const {
	str=(char *)malloc(sizeof(char)*(length()+1));
	strcpy(str, s);
}

/************************/

bool operator==( const Str &s1, const Str &s2 ) {
	return strcmp(s1.data(),s2.data()) == 0;
}

bool operator==( const Str &s1, const char *s2 ) {
	return strcmp(s1.data(),s2) == 0;
}

bool operator==( const char *s1, const Str &s2 ) {
	return strcmp(s1,s2.data()) == 0;
}

bool operator!=( const Str &s1, const Str &s2 ) {
	return strcmp(s1.data(),s2.data()) != 0;
}

bool operator!=( const Str &s1, const char *s2 ) {
	return strcmp(s1.data(),s2) != 0;
}

bool operator!=( const char *s1, const Str &s2 ) {
	return strcmp(s1,s2.data()) != 0;
}



