/**
 * token.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef TOKEN_H
#define TOKEN_H

#include <kurl.h>

#include <qstringlist.h>
#include <qptrlist.h>
#include <qstring.h>

namespace KConfigEditor {

    class ConfItem;
    class ConfigurationView;

    //Here are the elements that one can find
    //in a config file.
    class Token
    {
    public:
        enum Type {
            String,
            Password,
            StringList,
            Font,
            Rect,
            Size,
            Color,
            Point,
            Int,
            UInt,
            Bool,
            Double,
            DateTime,
            Int64,
            UInt64,
            IntList,
            Enum,
            Path,
            Invalid
        };

    public:
        /**
         * Creates the token with the given name
         */
        Token( const KURL &url, bool readOnly = false );
        virtual ~Token();

        /**
         * Returns true if the token is a group
         */
        virtual bool isGroup() const { return false; }

        /**
         * Sets the name of this token, creates a Memento
         * user to undo this change and increments the modified
         * counter of this token.
         */
        virtual void setName( const QString & );
        virtual QString name() const;

        /**
         * Returns true if this token has been modified.
         */
        bool modified() const;

        void setReadOnly( bool );
        bool readOnly() const;

        void setImmutable( bool b );
        bool immutable() const;

        /**
         * Returns true if a token has unsaved changes
         */
        virtual bool hasPendingChanges() const = 0;
        /**
         * Prunes pending changes for this token.
         */
        virtual void prunePendingChanges() = 0;

        /**
         * Function attaches the given configuration element to
         * the gui.
         */
        virtual void attach( ConfigurationView *view ) = 0;
        ConfItem *view() const { return m_view; }

        /**
         * Restores token to its original state
         */
        virtual void restoreToken( const KURL &item, QStringList &paths ) = 0;

        /**
         * URL of this token.
         */
        KURL url() const { return m_url; }

    protected:
        KURL     m_url;
        bool     m_immutable;
        bool     m_readOnly;
        ConfItem *m_view;
        bool     m_modified;
    };

    namespace Utils
    {
        Token::Type stringToType( const QString &typeName );
    }
}

#endif
