/**
 * kdescriptgenerator.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "kdescriptgenerator.h"

#include "grouptoken.h"
#include "entrytoken.h"


using namespace KConfigEditor;

KDEScriptGenerator::KDEScriptGenerator()
{
}

QString KDEScriptGenerator::backupScript( const QDict<GroupToken> &topLevelGroups )
{
    QString contents;
    QDictIterator<GroupToken> itr( topLevelGroups );
    GroupToken *topGroup =0;

    while ( (topGroup=itr.current()) ) {
        if ( topGroup->hasPendingChanges() )
            contents += applicationBackup( topGroup, false );
        ++itr;
    }
    return contents;
}

QString KDEScriptGenerator::propagationScript( const QDict<GroupToken> &topLevelGroups )
{
    QString contents;
    QDictIterator<GroupToken> itr( topLevelGroups );
    GroupToken *topGroup =0;

    while ( (topGroup=itr.current()) ) {
        if ( topGroup->hasPendingChanges() )
            contents += applicationBackup( topGroup, true );
        ++itr;
    }
    return contents;
}

QString KDEScriptGenerator::fullBackupScript( const QDict<GroupToken> &topLevelGroups )
{
    Q_UNUSED( topLevelGroups );
    return QString( "FIXME" );
}

QString KDEScriptGenerator::applicationBackup( GroupToken *token, bool propagation )
{
    QString str;
    QTextStream ts( &str, IO_WriteOnly );

    ts << "var config = new KConfig( null, \"" << token->name() << "\");\n";

    QDictIterator<EntryToken> itr( token->childEntries() );
    while ( itr.current() ) {
        if ( itr.current()->modified() ) {
            QString value = (propagation)?itr.current()->valueAsString():
                            itr.current()->initialValueAsString();
            ts << "config.writeEntry( \"" << itr.current()->name() << "\", \""
               << value << "\" );\n";
        }
        ++itr;
    }

    QDictIterator<GroupToken> gitr( token->childGroups() );
    GroupToken *group = 0;
    while ( (group=gitr.current()) ) {
        if ( group->modified() ) {
            ts << "config.setGroup( \"" << group->name() << "\" );\n";
            QDictIterator<EntryToken> itr( token->modifiedEntries() );
            while ( itr.current() ) {
                QString value = (propagation)?itr.current()->valueAsString():
                                itr.current()->initialValueAsString();
                ts << "config.writeEntry( \"" << itr.current()->name() << "\", \""
                   << value << "\" );\n";
                ++itr;
            }
        }

        ++gitr;
    }
    return str;
}
