/**
 * subsystem.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KCONFIG_SUBSYSTEM_H
#define KCONFIG_SUBSYSTEM_H

#include "grouptoken.h"

#include <qobject.h>
#include <qguardedptr.h>
#include <qdict.h>

class QListView;
class QVariant;
class KURL;
class QListViewItem;

namespace KConfigEditor
{
    class ConfigurationView;
    class ProgressItem;

    class Subsystem : public QObject
    {
        Q_OBJECT
    public:
        /**
         * Returns the configuration subsystem this proxy handles.
         * the names are always all lowercase (e.g. gconf, kconfig)
         */
        virtual QString protocol() const =0;

        ProgressItem *progressItem() const;

        QDict<GroupToken> &topLevelGroups() { return m_topLevelGroup; }

    public slots:
        /**
         * Sets the value of the item with the given url to the specified
         * value.
         */
        virtual void setValue( const KURL &item, const QVariant &value ) =0;

        /**
         * Saves the given token
         */
        virtual void saveToken( EntryToken *token ) =0;

        /**
         * Restores the entry to its initial value
         */
        virtual void restoreEntry( const KURL &item );

        /**
         * Starts parsing process. The entries should incremenally be attaching to
         * the given configuration view.
         */
        virtual void parse( ConfigurationView *view ) =0;

        /**
         * Saves modified entries.
         */
        bool save();

        /**
         * Discard modification in the subsystem.
         */
        void discard();
    signals:
        /**
         * Emitted when the subsystem has finished parsing
         */
        void parsingFinished( Subsystem *sub );

    protected:
        /**
         * Called during the save() call on each top-level
         * group token which has unsaved changes.
         */
        virtual void saveConfig( GroupToken *token ) =0;
    protected:
        Subsystem( QObject *parent );

    protected:
        QDict<GroupToken>  m_topLevelGroup;
        mutable QGuardedPtr<ProgressItem> m_progressItem;
    };
}


#endif
