/**
 * kcfgcreator_part.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef KCFGCREATOR_PART_H
#define KCFGCREATOR_PART_H

#include <kparts/part.h>

class KAboutData;

namespace KCfgCreator
{
    class MainWidget;
}
using KCfgCreator::MainWidget;

class KCfgCreatorPart : public KParts::ReadWritePart
{
    Q_OBJECT
public:
    KCfgCreatorPart( QWidget *parentWidget, const char */*widgetName*/,
                     QObject *parent, const char *name, const QStringList& );
    ~KCfgCreatorPart();

    virtual void setReadWrite( bool rw );
    static KAboutData *createAboutData();

protected:
    virtual bool openFile();
    virtual bool saveFile();

protected:
    MainWidget *m_widget;
    static KAboutData *s_about;
};

#endif
