/**
 * kcfgcdialog.cpp
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "kcfgcdialog.h"
#include "kcfgcwidgetui.h"

#include <kmessagebox.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <klocale.h>

#include <qcheckbox.h>
#include <qvbox.h>
#include <qstringlist.h>

using namespace KCfgCreator;

static int accessToInt( const QString& access )
{
    if ( access == "public" ) {
        return 2;
    } else if ( access == "protected" ) {
        return 1;
    } else {
        return 0;
    }
}

KCfgcDialog::KCfgcDialog( KCfgcOptions& ops, QWidget* parent )
    : KDialogBase( parent, "kcfgcdialog", true, i18n("KCfgc Options"),
                   KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true ),
      m_options( ops )
{
    QVBox *page = makeVBoxMainWidget();
    m_ui = new KCfgcWidgetUI( page );

    m_ui->m_configEdit->setText( m_options.configName() );
    m_ui->m_kcfgEdit->setText( m_options.kcfgFile() );
    m_ui->m_namespaceEdit->setText( m_options.namespaceName() );
    m_ui->m_classEdit->setText( m_options.className() );
    m_ui->m_inheritsEdit->setText( m_options.inherits() );
    m_ui->m_singletonCheck->setChecked( m_options.singleton() );
    m_ui->m_memberCombo->setCurrentItem( accessToInt( m_options.memberVariables() ) );
    m_ui->m_includeFilesEdit->setText( m_options.includeFiles().join( "," ) );
    m_ui->m_mutatorsCheck->setChecked( m_options.mutators() );
    m_ui->m_accessorsCheck->setChecked( m_options.itemAccessors() );
    m_ui->m_textsCheck->setChecked( m_options.userTexts() );
    m_ui->m_enumsCheck->setChecked( m_options.globalEnums() );
}

void
KCfgcDialog::slotOk()
{
    if ( configName().isEmpty() || kclassName().isEmpty() ) {
        KMessageBox::information( this,
                     i18n( "Both 'Config filename' and 'Class name' entries have to be filled." ),
                                  i18n( "Missing Entries" ) );
        return;
    }

    if ( m_options.kcfgFile() != kcfgFile() ) {
        QString name = kcfgFile();
        if ( name.isEmpty() ) {
            if ( configName().endsWith( "rc" ) )
                name = configName().left( configName().length() - 2 );
            else if ( configName().endsWith( ".rc" ) )
                name = configName().left( configName().length() - 3 );
            else
                name = configName();
        }
        name += ".kcfg";
        m_options.setKCfgFile( name );
    }

    QString entry = m_ui->m_configEdit->text();
    if ( entry != m_options.configName() )
        m_options.setConfigName( entry );

    entry = m_ui->m_namespaceEdit->text();
    if ( entry != m_options.namespaceName() )
        m_options.setNamespaceName( entry );

    entry = m_ui->m_classEdit->text();
    if ( entry != m_options.className() )
        m_options.setClassName( entry );

    entry = m_ui->m_inheritsEdit->text();
    if ( entry != m_options.inherits() )
        m_options.setInherits( entry );

    bool bentry = m_ui->m_singletonCheck->isChecked();
    if ( bentry != m_options.singleton() )
        m_options.setSingleton( bentry );

    entry = m_ui->m_memberCombo->currentText();
    if ( entry != m_options.memberVariables() &&
         ( entry == "public" || entry == "protected" || entry == "private" ) )
        m_options.setMemberVariables( entry );

    QStringList l = QStringList::split( ",", m_ui->m_includeFilesEdit->text() );
    if ( l != m_options.includeFiles() )
        m_options.setIncludeFiles( l );

    bentry = m_ui->m_mutatorsCheck->isChecked();
    if ( bentry != m_options.mutators() )
        m_options.setMutators( bentry );

    bentry = m_ui->m_accessorsCheck->isChecked();
    if ( bentry != m_options.itemAccessors() )
        m_options.setItemAccessors( bentry );

    bentry = m_ui->m_textsCheck->isChecked();
    if ( bentry != m_options.userTexts() )
        m_options.setUserText( bentry );

    bentry = m_ui->m_enumsCheck->isChecked();
    if ( bentry != m_options.globalEnums() )
        m_options.setGlobalEnums( bentry );

    KDialogBase::slotOk();
}

QString
KCfgcDialog::kcfgFile() const
{
    return m_ui->m_kcfgEdit->text();
}

QString
KCfgcDialog::kclassName() const
{
    return m_ui->m_classEdit->text();
}

QString
KCfgcDialog::configName() const
{
    return m_ui->m_configEdit->text();
}

#include "kcfgcdialog.moc"
