/**
 * creator.cpp
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "creator.h"
#include "mainwidget.h"

#include <kstdaction.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>

namespace KCfgCreator
{

Creator::Creator()
    : KMainWindow( 0, "KCfgCreatorWindow" )
{
    m_mainWidget = new MainWidget( this );
    setCentralWidget( m_mainWidget );

    initActions();
    createGUI( "kcfgcreatorui.rc" );
}

void Creator::initActions()
{
    KStdAction::openNew( m_mainWidget, SLOT(newConfig()), actionCollection(), "open_new" );

    new KAction( i18n( "&Parse File..." ), "fileopen",
                 0, m_mainWidget, SLOT(parseFile()),
                 actionCollection(), "parse_file" );
    new KAction( i18n( "&Import KConfig File..." ), "fileimport",
                 0, m_mainWidget, SLOT(fromRcFile()),
                 actionCollection(), "from_rc_file" );

    KStdAction::save( m_mainWidget, SLOT(save()), actionCollection(), "save" );
    KStdAction::quit( this, SLOT(close()), actionCollection() );


    new KAction( i18n( "&Add Entry..." ), "add_group",
                 0, m_mainWidget, SLOT(addEntry()),
                 actionCollection(), "add_group" );
    new KAction( i18n( "&Add Entry..." ), "add_entry",
                 0, m_mainWidget, SLOT(addEntry()),
                 actionCollection(), "add_entry" );
    new KAction( i18n( "&Remove Entry" ), "remove_entry",
                 0, m_mainWidget, SLOT(removeEntry()),
                 actionCollection(), "remove_entry" );
}

void Creator::openURL( const KURL& url )
{
    QString path = url.path();

    if ( path.endsWith( "rc" ) )
        m_mainWidget->openRCFile( url );
    else if ( path.endsWith( "kcfg" ) )
        m_mainWidget->openKCfgFile( url );
    else if ( path.endsWith( "kcfgc" ) )
        m_mainWidget->openKCfgcFile( url );
}

}

#include "creator.moc"
