/***************************************************************************
                          fileconf.cpp  -  description
                             -------------------
    begin                : Tue May 2 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@kpage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          fileconf.cpp  -  description
                             -------------------
    begin                : Sun Jan 23 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "fileconf.h"

FileConf::FileConf(QWidget *parent, const char *name )
		: QFrame(parent,name)
{
	QFont fnt("helvetica",12, QFont::Bold);
	fnt.setUnderline(true);
	
	QButtonGroup *inExFiles = new QButtonGroup(this);
	inExFiles->setBackgroundColor(white);
	inExFiles->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
	inExFiles->setGeometry(5,25,335,58);
	
	getBut = new QCheckBox(i18n("Get only selected filetypes"), inExFiles);
	getBut->setGeometry(5,5,325,20);
	getBut->setBackgroundColor(white);
	getBut->setChecked(true);
	getBut->hide();
	connect(getBut, SIGNAL(clicked()), this, SLOT(checkGetRejBut()));

	rejBut = new QCheckBox(i18n("Reject selected filetypes"), inExFiles);
	rejBut->setGeometry(5,30,325,20);
	rejBut->setBackgroundColor(white);
	rejBut->hide();
	connect(rejBut, SIGNAL(clicked()), this, SLOT(checkGetRejBut()));

	imgFrame = new ImageSel(this);
	imgFrame->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	imgFrame->setGeometry(5,85,80,145);
	imgFrame->setBackgroundColor(white);
	imgFrame->hideItems();

	 QLabel *imgLab = new QLabel(i18n("Images:"),imgFrame);
	 imgLab->setFont(fnt);
	 imgLab->setBackgroundColor(white);
	 imgLab->setGeometry(10,2,80,20);

	txtFrame = new TextSel(this);
	txtFrame->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	txtFrame->setGeometry(90,85,80,145);
	txtFrame->setBackgroundColor(white);
	txtFrame->hideItems();

	 QLabel *txtLab = new QLabel(i18n("Text Files:"),txtFrame);
	 txtLab->setFont(fnt);
	 txtLab->setBackgroundColor(white);
	 txtLab->setGeometry(10,2,80,20);
	
	audFrame = new AudioSel(this);
	audFrame->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	audFrame->setGeometry(175,85,80,145); // 25 , 205
	audFrame->setBackgroundColor(white);
	audFrame->hideItems();

	 QLabel *audLab = new QLabel(i18n("Audio:"),audFrame);
	 audLab->setFont(fnt);
	 audLab->setBackgroundColor(white);
	 audLab->setGeometry(10,2,101,21);

	vidFrame = new VideoSel(this);
	vidFrame->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	vidFrame->setGeometry(260,85,80,145);
	vidFrame->setBackgroundColor(white);
	vidFrame->hideItems();

	 QLabel *vidLab = new QLabel(i18n("Video:"),vidFrame);
	 vidLab->setFont(fnt);
	 vidLab->setBackgroundColor(white);
	 vidLab->setGeometry(10,2,80,20);

	othFrame = new OtherSel(this);
	othFrame->setFrameStyle(QFrame::WinPanel | QFrame::Sunken);
	othFrame->setGeometry(345,25,215,205);
	othFrame->setBackgroundColor(white);
	othFrame->hideItems();

	 QLabel *othLab = new QLabel(i18n("Other:"),othFrame);
	 othLab->setFont(fnt);
	 othLab->setBackgroundColor(white);
	 othLab->setGeometry(10,2,80,20);
}

FileConf::~FileConf()
{
}

QString FileConf::whatToGet()
{
	QString tmp, tmp2;
	tmp = "";
	if ( imgFrame->jpgBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "jpg";
	}
	if ( imgFrame->jpegBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "jpeg";
	}
	if ( imgFrame->gifBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "gif";
	}
	if ( imgFrame->bmpBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "bmp";
	}
	if ( imgFrame->pngBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "png";
	}
	if ( imgFrame->xpmBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "xpm";
	}
	if ( imgFrame->pnmBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "pnm";
	}
	
	if ( audFrame->wavBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "wav";
	}
	if ( audFrame->midBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "mid";
	}
	if ( audFrame->sndBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "snd";
	}
	if ( audFrame->mp2Box->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "mp2";
	}
	if ( audFrame->mp3Box->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "mp3";
	}
	if ( audFrame->aiffBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "aiff";
	}
	if ( audFrame->ramBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "ram";
	}
	
	if ( vidFrame->movBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "mov";
	}
	if ( vidFrame->mpgBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "mpg";
	}
	if ( vidFrame->mpegBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "mpeg";
	}
	if ( vidFrame->rmBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "rm";
	}
	if ( vidFrame->aviBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "avi";
	}
	if ( vidFrame->qtBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "qt";
	}
	
	if ( txtFrame->txtBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "txt";
	}
	if ( txtFrame->docBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "doc";
	}
	if ( txtFrame->htmlBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "html";
	}
	if ( txtFrame->htmBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "htm";
	}
	if ( txtFrame->shtmlBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "shtml";
	}
	if ( txtFrame->aspBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "asp";
	}
	if ( txtFrame->pdfBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "pdf";
	}

	if ( othFrame->zipBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "zip";
	}
	if ( othFrame->bz2Box->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "bz2";
	}
	if ( othFrame->gzBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "gz";
	}
	if ( othFrame->exeBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "exe";
	}
	if ( othFrame->rpmBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "rpm";
	}
	if ( othFrame->rarBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "rar";
	}
	if ( othFrame->tarBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "tar";
	}
	if ( othFrame->debBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "deb";
	}
	if ( othFrame->aceBox->isChecked() ) {
		if ( !tmp.isEmpty())
			tmp += ",";
		tmp += "ace";
	}
	for ( int i=1 ; i <= 18 ; i++ ) {
		tmp2 = othFrame->newftLine[i]->text();
		if  (( !tmp2.isEmpty() )&&( othFrame->newftBox[i]->isChecked() )) {
			if ( !tmp.isEmpty())
				tmp += ",";
			tmp += tmp2;
		}
	}
	return tmp;
}

void FileConf::checkGetRejBut()
{
	if ( this->sender() == getBut ) {
		rejBut->setChecked(false);
		getBut->setChecked(true);
	} else {
		rejBut->setChecked(true);
		getBut->setChecked(false);
	}
}