/***************************************************************************
                          kwgwizard.cpp  -  description
                             -------------------
    begin                : Mon Feb 7 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwgwizard.h"
#include "../../pics/wizpic.xpm"

KWGWizard::KWGWizard(QWidget * parent, const char * name, bool modal, WFlags f)
		 : QDialog(parent,name,modal)
{
	QFrame *picFrame = new QFrame(this);
	picFrame->setBackgroundPixmap(QPixmap((const char**)wizpic_xpm));
	picFrame->setFrameStyle( QFrame::Panel | QFrame::Sunken );
	picFrame->setGeometry(3,10,149,230);

	QFrame *butFrame = new QFrame(this);
	butFrame->setLineWidth(2);
	butFrame->setFrameStyle( QFrame::HLine | QFrame::Sunken );
	butFrame->setGeometry(3,245,596,2);

	backBut = new MyPushButton(i18n("<&Back"), this);
	backBut->setGeometry(340,255,80,20);
	connect(backBut, SIGNAL(clicked()), this, SLOT(goBack()));

	nextBut = new MyPushButton(i18n("&Next>"), this);
	nextBut->setGeometry(425,255,80,20);
	nextBut->setEnabled(false);

	cancelBut = new MyPushButton(i18n("Cancel"), this);
	cancelBut->setGeometry(510,255,80,20);

	initWizard();
	showWizPage1();
}

KWGWizard::~KWGWizard()
{
}

void KWGWizard::initWizard()
{
	wizPage1 = new WizPage1(this);
	wizPage1->setGeometry(155,5,445,240);
	wizPage1->hide();

	wizPage2 = new WizPage2(this);
	wizPage2->setGeometry(155,5,445,240);
	wizPage2->hide();
	
	wizPage3 = new WizPage3(this);
	wizPage3->setGeometry(155,5,445,240);
	wizPage3->hide();

	wizPage4 = new WizPage4(this);
	wizPage4->setGeometry(155,5,445,240);
	wizPage4->hide();

	wizPage5 = new WizPage5(this);
	wizPage5->setGeometry(155,5,445,240);
	wizPage5->hide();

	wizPage6 = new WizPage6(this);
	wizPage6->setGeometry(155,5,445,240);
	wizPage6->hide();
}

void KWGWizard::showWizPage1()
{
	backBut->setEnabled(false);
	connect(wizPage1->pnameLine, SIGNAL(textChanged(const char*)),
		   this, SLOT(getCaption(const char*)));
	connect(wizPage1->pfolderLine, SIGNAL(textChanged(const char*)),
		   this, SLOT(getFolder(const char*)));
	connect(nextBut, SIGNAL(clicked()), this, SLOT(nextPage()));
	wizPage1->pnameLine->setFocus();
	wizPage1->show();
}

void KWGWizard::showWizPage2()
{
	// This is checking the settings of wizPage1
	if ( !checkFolder() )
		return;
	wizPage1->hide();

	// Now, wizPage2 must be shown ...
	connect( wizPage2->agentLine, SIGNAL(textChanged(const char*)), this, SLOT(enableNext(const char*)));
	connect( wizPage2->agentCombo, SIGNAL(activated(int)), this, SLOT(enableNext(int)));
	connect( wizPage2->agentCombo, SIGNAL(activated(int)), this, SLOT(enableAgentLine(int)));
	wizPage2->mirrorBut->setFocus();
	wizPage2->show();

	// The possibility to go back ...
	backBut->setEnabled(true);
}

void KWGWizard::showWizPage3()
{
	QString tmp, tmp2;
	wizPage2->hide();
	if ( wizPage2->mirrorBut->isChecked() ) {
		wizPage3->mirFrame->show();
		wizPage3->fileFrame->hide();
		wizPage3->listFrame->hide();
		wizPage3->urlLine[0]->setFocus();
		tmp =wizPage3->urlLine[0]->text();
		if ( tmp.isEmpty() )
			nextBut->setEnabled(false);
		connect(wizPage3->urlLine[0], SIGNAL(textChanged(const char*)),
			this, SLOT(enableNext(const char*)));
	} else if ( wizPage2->singleBut->isChecked() ) {
		wizPage3->fileFrame->show();
		wizPage3->mirFrame->hide();
		wizPage3->listFrame->hide();
		wizPage3->urlLine[1]->setFocus();
		tmp =wizPage3->urlLine[1]->text();
		tmp2 =wizPage3->fileLine[1]->text();
		if (( tmp.isEmpty() )||( tmp2.isEmpty() ))
			nextBut->setEnabled(false);
		connect(wizPage3->urlLine[1], SIGNAL(textChanged(const char*)),
			this, SLOT(enableNext(const char*)));
		connect(wizPage3->fileLine[1], SIGNAL(textChanged(const char*)),
			this, SLOT(enableNext(const char*)));
	} else {
		nextBut->setEnabled(false);
		wizPage3->listFrame->show();
		wizPage3->mirFrame->hide();
		wizPage3->fileFrame->hide();
		wizPage3->sitelistBut->setFocus();
		connect( wizPage3, SIGNAL(listCompleted()), this, SLOT(enableNext()));
		if ( wizPage3->hasSiteList ) {
			for ( int i=0 ; i <= wizPage3->listWidg->addNum ; i++ ) {
				tmp = wizPage3->listWidg->siteLine[i]->text();
				if ( !tmp.isEmpty() )
					nextBut->setEnabled(true);
			}
		}
	}

	wizPage3->show();
}

void KWGWizard::showWizPage4()
{
	wizPage3->hide();

	wizPage4->show();
}

void KWGWizard::showWizPage5()
{
	if (( comeFrom == 0 )||( comeFrom == 2 ))
		wizPage4->hide();
	else
		wizPage3->hide();
	wizPage5->show();
}

void KWGWizard::showWizPage6()
{
	wizPage5->hide();
	wizPage6->show();
	nextBut->hide();
	finishBut = new MyPushButton(i18n("&Finish"), this);
	finishBut->setGeometry(425,255,80,20);
	connect(finishBut, SIGNAL(clicked()), this, SLOT(finishWiz()));
	finishBut->show();
}

bool KWGWizard::checkFolder()
{
	QString tmp ( wizPage1->pfolderLine->text() );
	QDir pdir (tmp);
	if ( !pdir.exists() ) {
		switch (QMessageBox::warning(this, i18n("Wrong folder"),
					i18n("The projectfolder you have entered\n"
					"doesn't exist !\n"
					"Should I try to create it now ?"),
					i18n("Yes"), i18n("No"),0,0,1) )
		{
			case 0:
				pdir.mkdir(tmp);
				if ( !pdir.exists() ) {
					QMessageBox::warning(this, i18n("Error"),
							i18n("It seems, that you have no permissions,\n"
							"to create the projectfolder, or the path, you've given\n"
							"is wrong !\n"
							"Please try again !"));
					return false;
				}
				break;
			case 1:
				return false;
		}
	}
	if ( !pdir.isReadable() ) {
		QMessageBox::warning(this, i18n("Error"),
				i18n("It seems, that you have no permissions,\n"
				"to use the folder you've given !\n"
				"Please try again !"));
		return false;
	}
	return true;
}

void KWGWizard::closeEvent( QCloseEvent *ce)
{
}

void KWGWizard::getCaption(const char *txt)
{
	QString tmp ("Project Wizard - ");
	QString tmp2;
	tmp += txt;
	this->setCaption(tmp);

	tmp = txt;
	tmp2 = wizPage1->pfolderLine->text();
	if (( !tmp.isEmpty() )&&( !tmp2.isEmpty() )) {
		nextBut->setEnabled(true);
	} else {
		nextBut->setEnabled(false);
	}
}

void KWGWizard::getFolder(const char *txt)
{
	QString tmp, tmp2;
	tmp = txt;
	tmp2 = wizPage1->pnameLine->text();
	if (( !tmp.isEmpty() )&&( !tmp2.isEmpty() )) {
		nextBut->setEnabled(true);
	} else {
		nextBut->setEnabled(false);
	}
}

void KWGWizard::nextPage()
{
	if ( wizPage1->isVisible() ) {
		showWizPage2();
		enableNext(wizPage2->agentLine->text());
	} else if ( wizPage2->isVisible() ) {
		showWizPage3();
	} else if ( wizPage3->isVisible() ) {
		if ( wizPage3->mirFrame->isVisible() ) {
			comeFrom = 0;
			showWizPage4();
		} else if ( wizPage3->listFrame->isVisible() ) {
			comeFrom = 2;
			showWizPage4();
		} else {
			comeFrom = 1;
			showWizPage5();
		}
	} else if ( wizPage4->isVisible() ) {
		showWizPage5();
	} else if ( wizPage5->isVisible() ) {
		showWizPage6();
	}
}

void KWGWizard::goBack()
{
	if ( wizPage2->isVisible() ) {
		wizPage2->hide();
		wizPage1->show();
		nextBut->setEnabled(true);
		backBut->setEnabled(false);
	} else if ( wizPage3->isVisible() ) {
		nextBut->setEnabled(true);
		wizPage3->hide();
		wizPage2->show();
	} else if ( wizPage4->isVisible() ) {
		wizPage4->hide();
		wizPage3->show();
	} else if ( wizPage5->isVisible() ) {
		if (( comeFrom == 0 )||( comeFrom == 2 )) {
			wizPage5->hide();
			wizPage4->show();
		} else {
			wizPage5->hide();
			wizPage3->show();
		}
	} else if ( wizPage6->isVisible() ) {
		wizPage6->hide();
		wizPage5->show();
		nextBut->show();
		delete(finishBut);
	}
}

void KWGWizard::enableNext(const char *txt)
{
	QString tmp, tmp2;
	tmp = txt;
	if ( this->sender() == wizPage2->agentLine ) {
		tmp = tmp.stripWhiteSpace();
		if (( wizPage2->agentCombo->currentItem() == 6 )&&( tmp.isEmpty() )) {
			nextBut->setEnabled(false);
		} else {
			nextBut->setEnabled(true);
		}
	} else if ( this->sender() == wizPage3->urlLine[0] ) {
		if ( tmp.isEmpty() ) {
			nextBut->setEnabled(false);
		} else {
			nextBut->setEnabled(true);
		}
	} else if ( this->sender() == wizPage3->urlLine[1] ) {
		tmp2 = wizPage3->fileLine[1]->text();
		if (( tmp.isEmpty() )||( tmp2.isEmpty() )) {
			nextBut->setEnabled(false);
		} else {
			nextBut->setEnabled(true);
		}
	} else if ( this->sender() == wizPage3->fileLine[1] ) {
		tmp2 = wizPage3->fileLine[1]->text();
		if (( tmp.isEmpty() )||( tmp2.isEmpty() )) {
			nextBut->setEnabled(false);
		} else {
			nextBut->setEnabled(true);
		}
	}
}

void KWGWizard::enableNext(int index)
{
	if ( index != 6 )
		nextBut->setEnabled(true);
}

void KWGWizard::enableNext()
{
	nextBut->setEnabled(true);
}

void KWGWizard::enableAgentLine(int index)
{
	QString tmp;
	tmp = wizPage2->agentLine->text();
	if ( index == 6 ) {
		wizPage2->agentLine->show();
//		wizPage2->agentLine->setText(i18n("Insert Agent here ..."));
		if ( tmp.isEmpty() )
			nextBut->setEnabled(false);
		wizPage2->agentLine->setFocus();
		wizPage2->agentLine->selectAll();
	} else {
		wizPage2->agentLine->hide();
		wizPage2->agentLine->setText("");
	}
}

void KWGWizard::finishWiz()
{
	emit finished();
}