/***************************************************************************
                          othersel.cpp  -  description
                             -------------------
    begin                : Fri Jan 21 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "othersel.h"

OtherSel::OtherSel(QWidget *parent, const char *name )
		: QFrame(parent,name)
{
	numFt = 0;
	ftX = 145;
	ftY = 90;
	zipBox = new QCheckBox(".zip", this);
	zipBox->setGeometry(5,25,70,15);
	zipBox->setBackgroundColor(white);
	
	gzBox = new QCheckBox(".gz", this);
	gzBox->setGeometry(75,25,70,15);
	gzBox->setBackgroundColor(white);

	tarBox = new QCheckBox(".tar", this);
	tarBox->setGeometry(145,25,70,15);
	tarBox->setBackgroundColor(white);

	bz2Box = new QCheckBox(".bz2", this);
	bz2Box->setGeometry(5,40,70,15);
	bz2Box->setBackgroundColor(white);

	rpmBox = new QCheckBox(".rpm", this);
	rpmBox->setGeometry(75,40,70,15);
	rpmBox->setBackgroundColor(white);

	debBox = new QCheckBox(".deb", this);
	debBox->setGeometry(145,40,70,15);
	debBox->setBackgroundColor(white);

	exeBox = new QCheckBox(".exe", this);
	exeBox->setGeometry(5,55,70,15);
	exeBox->setBackgroundColor(white);

	rarBox = new QCheckBox(".rar", this);
	rarBox->setGeometry(75,55,70,15);
	rarBox->setBackgroundColor(white);

	aceBox = new QCheckBox(".ace", this);
	aceBox->setGeometry(145,55,70,15);
	aceBox->setBackgroundColor(white);

	QFont fnt("helvetica",10,QFont::Bold);
	fnt.setUnderline(true);

	addLab = new QLabel(i18n("Here you can add some other\nfiletypes:"), this);
	addLab->setFont(fnt);
	addLab->setBackgroundColor(white);
	addLab->setGeometry(5,70,210,35);
	addLab->hide();

	for (int i=1; i <= 18; i++) {
		newftBox[i] = new QCheckBox(this);
		if ( ftX == 145 ) {
			ftX = 5;
			ftY = ftY+15;
		} else if ( ftX == 5 ){
			ftX = 75;
		} else {
			ftX = 145;
		}
		newftBox[i]->setBackgroundColor(white);
		newftBox[i]->setGeometry(ftX,ftY,50,15);
		connect(newftBox[i], SIGNAL(clicked()), this, SLOT(takeNewFileType()));
		newftLine[i] = new QLineEdit(this);
		if ( i == 1 ) {
		  newftLine[i]->insert(".tgz");
		 }
		newftLine[i]->setMaxLength(6);
		newftLine[i]->setCursorPosition(0);
		newftLine[i]->setFocus();
		newftLine[i]->setGeometry(newftBox[i]->pos().x()+17,newftBox[i]->pos().y(),45,18);
		connect(newftLine[i], SIGNAL(returnPressed()), this, SLOT(addNewFileType()));
		connect(newftLine[i], SIGNAL(textChanged(const char *)), this,
							  SLOT(checkNewFileType(const char *)));
	}
}

OtherSel::~OtherSel()
{
}

void OtherSel::hideItems()
{
	zipBox->hide();
	gzBox->hide();
	tarBox->hide();
	rarBox->hide();
	aceBox->hide();
	bz2Box->hide();
	debBox->hide();
	exeBox->hide();
	rpmBox->hide();
	addLab->hide();
	for (int i=1; i <=18 ; i++ ) {
		newftBox[i]->hide();
		newftLine[i]->hide();
	}
}

void OtherSel::showItems()
{
	zipBox->show();
	gzBox->show();
	tarBox->show();
	rarBox->show();
	aceBox->show();
	bz2Box->show();
	debBox->show();
	exeBox->show();
	rpmBox->show();
	addLab->show();
	for (int i=1; i <=18 ; i++ ) {
		newftBox[i]->show();
		newftLine[i]->show();
	}
}

void OtherSel::addNewFileType()
{
	QString txt;
	for ( int i=1; i <= 24; i++) {
		if ( this->sender() == newftLine[i] ) {
			txt = newftLine[i]->text();
			if ( !txt.isEmpty() )
			newftBox[i]->setChecked(true);
		}
	}
}

void OtherSel::checkNewFileType(const char *tx)
{
	QString txt;
	for ( int i=1; i <= 24; i++) {
		if ( this->sender() == newftLine[i] ) {
			txt = newftLine[i]->text();
			if ( txt.isEmpty() )
				newftBox[i]->setChecked(false);
			else
				newftBox[i]->setChecked(true);
		}
	}
}

void OtherSel::takeNewFileType()
{
	QString txt;
	for ( int i=1; i <= 24; i++) {
		if ( this->sender() == newftBox[i] ) {
			txt = newftLine[i]->text();
			if ( txt.isEmpty() )
			newftBox[i]->setChecked(false);
		}
	}
}