/***************************************************************************
                          optionsDialogData.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpixmap.h>
#include <qlayout.h>
#include "optionsDialog.h"

#include <qlabel.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qcombo.h>

void optionsDialog::initDialog()
{

    buttonHelp = new QPushButton( this, "buttonHelp" );
    buttonHelp->setGeometry( QRect( 12, 451, 80, 26 ) );
    buttonHelp->setProperty( "text", tr( "&Help" ) );
    buttonHelp->setProperty( "autoDefault", QVariant( TRUE, 0 ) );

    listBox = new QListBox( this, "listBox" );
    listBox->insertItem( tr( "Main" ) );
    listBox->insertItem( tr( "FTP" ) );
    listBox->insertItem( tr( "HTTP" ) );
    listBox->setGeometry( QRect( 11, 11, 97, 433 ) );
    listBox->setProperty( "sizePolicy", QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)7, listBox->sizePolicy().hasHeightForWidth() ) );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setGeometry( QRect( 650, 10, 80, 26 ) );
    buttonOk->setProperty( "text", tr( "&OK" ) );
    buttonOk->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    buttonOk->setProperty( "default", QVariant( TRUE, 0 ) );

    tabWidget = new QTabWidget( this, "tabWidget" );
    tabWidget->setGeometry( QRect( 110, 50, 630, 400 ) );

    Widget2 = new QWidget( tabWidget, "Widget2" );

    Ftp_CheckBox = new QCheckBox( Widget2, "Ftp_CheckBox" );
    Ftp_CheckBox->setGeometry( QRect( 30, 80, 78, 20 ) );
    Ftp_CheckBox->setProperty( "text", tr( "Use FTP" ) );

    IconsCheckBox = new QCheckBox( Widget2, "IconsCheckBox" );
    IconsCheckBox->setGeometry( QRect( 30, 120, 130, 20 ) );
    IconsCheckBox->setProperty( "text", tr( "Use Icons on Buttons" ) );

    Http_CheckBox = new QCheckBox( Widget2, "Http_CheckBox" );
    Http_CheckBox->setGeometry( QRect( 30, 160, 210, 20 ) );
    Http_CheckBox->setProperty( "text", tr( "Use pg index instead of ftp library index" ) );

    
    cb_queryExit= new QCheckBox( Widget2, "cb_queryExit" );
    cb_queryExit->setGeometry( QRect( 30, 200, 210, 20 ) );
    cb_queryExit->setProperty( "text", tr( "Query before exit." ) );

    ComboBoxStyle = new QComboBox( FALSE, Widget2, "ComboBoxStyle" );
    ComboBoxStyle->insertItem( tr( "stylePlatinum") );
    ComboBoxStyle->insertItem( tr( "styleWindows") );
    ComboBoxStyle->insertItem( tr( "styleCDE") );
    ComboBoxStyle->insertItem( tr( "styleMotif") );
    ComboBoxStyle->insertItem( tr( "styleMotifPlus") );
    ComboBoxStyle->insertItem( tr( "styleWood") );
    ComboBoxStyle->insertItem( tr( "styleSgi") );
    ComboBoxStyle->insertItem( tr( "stylePlatinumPlus") );
    ComboBoxStyle->insertItem( tr( "styleMetal") );
#if defined(_WS_X11_)
    ComboBoxStyle->insertItem( tr( "styleLace") );
    ComboBoxStyle->insertItem( tr( " styleLacePlus") );
#endif
    ComboBoxStyle->setGeometry( QRect( 30, 240, 210, 20 ) );



    tabWidget->insertTab( Widget2, tr( "Main" ) );

    Widget3 = new QWidget( tabWidget, "Widget3" );

    TextLabel2 = new QLabel( Widget3, "TextLabel2" );
    TextLabel2->setGeometry( QRect( 10, 50, 191, 20 ) );
    TextLabel2->setProperty( "text", tr( "Choose from these fine ftp servers:" ) );

    TextLabel3 = new QLabel( Widget3, "TextLabel3" );
    TextLabel3->setGeometry( QRect( 10, 10, 461, 21 ) );
    TextLabel3->setProperty( "text", tr( "Current ftp server:" ) );

    ftp_QListBox_1 = new QListBox( Widget3, "ftp_QListBox_1" );
    ftp_QListBox_1->setGeometry( QRect( 10, 80, 600, 255 ) );

    ftp_DownloadButton = new QPushButton( Widget3, "ftp_DownloadButton" );
    ftp_DownloadButton->setGeometry( QRect( 530, 340, 70, 30 ) );
    ftp_DownloadButton->setProperty( "text", tr( "&Download" ) );
    tabWidget->insertTab( Widget3, tr( "FTP" ) );

    tab = new QWidget( tabWidget, "tab" );

    TextLabel3_3 = new QLabel( tab, "TextLabel3_3" );
    TextLabel3_3->setGeometry( QRect( 10, 10, 461, 21 ) );
    TextLabel3_3->setProperty( "text", tr( "Current http browser:" ) );

    TextLabel4 = new QLabel( tab, "TextLabel4" );
    TextLabel4->setGeometry( QRect( 10, 50, 271, 21 ) );
    TextLabel4->setProperty( "text", tr( "Select a web browser:" ) );

    TextLabel5 = new QLabel( tab, "TextLabel5" );
    TextLabel5->setGeometry( QRect( 320, 50, 130, 20 ) );
    TextLabel5->setProperty( "text", tr( "HTTP Servers" ) );

    PushButton_Browse = new QPushButton( tab, "PushButton_Browse" );
    PushButton_Browse->setGeometry( QRect( 530, 10, 70, 30 ) );
    PushButton_Browse->setProperty( "text", tr( "Browse" ) );

    ComboBox1 = new QComboBox( FALSE, tab, "ComboBox1" );
    ComboBox1->insertItem( tr( "http://sailor.gutenberg.org" ) );
    ComboBox1->insertItem( tr( "http://www.prairienet.org/pg" ) );
    ComboBox1->setGeometry( QRect( 320, 80, 241, 31 ) );

    http_ListBox1 = new QListBox( tab, "http_ListBox1" );
    http_ListBox1->setGeometry( QRect( 10, 80, 280, 110 ) );
    tabWidget->insertTab( tab, tr( "HTTP" ) );

    initConnections();

 local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";
 config = new CConfigFile( local_library+"gutenbrowserrc");

}

void optionsDialog::initConnections()
{
//    connect(listBox, SIGNAL( selected(int) ), SLOT( listBoxMainSel( int)));
    connect(listBox, SIGNAL( highlighted(int) ), SLOT( listBoxMainSel( int)));
      // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );

//  connect( s_Browser, SIGNAL( activated(const QString&)), SLOT( goBrowser(const QString&) ) );
    connect( Http_CheckBox, SIGNAL( clicked()), SLOT( httpCheckB()) );
    connect( IconsCheckBox, SIGNAL( clicked()), SLOT( iconCheckB()) );
    connect( Ftp_CheckBox, SIGNAL( clicked()), SLOT( FtpCheckB()) );

// ftpsiteDlg
    connect( ftp_DownloadButton, SIGNAL( released() ),this, SLOT( getSite() ));
    connect( ftp_QListBox_1, SIGNAL( doubleClicked (  QListBoxItem *)),this, SLOT( getSelection(  QListBoxItem *)) );

//browserDialog
    connect( http_ListBox1, SIGNAL(selected ( int)),this, SLOT(select_title(int)) );
    connect( PushButton_Browse, SIGNAL( clicked() ), SLOT( BrowseSelected() ) );
    listBox->setSelected( 0,true);

//    connect( tabWidget, SIGNAL( currentChanged(QWidget*) ), SLOT( onTab(QWidget*) ) );
    connect(ComboBoxStyle,SIGNAL(activated(int)),this,SLOT(setStyle(int)));

    connect(cb_queryExit,SIGNAL(clicked()),SLOT( slotQueryExit()) );
}

void optionsDialog::listBoxMainSel( int index){
tabWidget->setCurrentPage( index);
}
