/***************************************************************************
                          openetextdata.cpp  -  description
                             -------------------
    begin                : Sat Dec 4 1999
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "openetext.h"
#include <qtooltip.h>
#include "CConfigFile.h"

void  OpenEtext::initDialog(){
  this->resize(370,490);
  this->setMinimumSize(0,0);
  this->setCaption("gutenbrowser local library");

  local_library = (QDir::homeDirPath ()) +"/.gutenbrowser/";

#if defined(_WS_WIN_)
    if( local_library.find( "//", 0, TRUE) != -1)
      local_library.replace( local_library.find( "//", 0, TRUE) , 2, "/");
#endif

  local_index = local_library +"PGWHOLE.TXT";

  config = new CConfigFile( local_library+"gutenbrowserrc");
  config->read();

  QListBox_1= new QListBox(this,"ListBox");
  QListBox_1->setGeometry(10,60,350,420);
  QListBox_1->setMinimumSize(0,0);
  QListBox_1->setAutoUpdate( TRUE );

  OpenButton = new QPushButton( this, "OpenButton" );
    OpenButton->setGeometry( 10, 10, 60, 22 );
    OpenButton->setMinimumSize( 0, 0 );
    OpenButton->setFocusPolicy( QWidget::TabFocus );
//  OpenButton->setBackgroundMode( QWidget::PaletteBackground );
//  OpenButton->setFontPropagation( QWidget::NoChildren );
//  OpenButton->setPalettePropagation( QWidget::NoChildren );
//  OpenButton->setPixmap( "/usr/share/gutenbrowser/pix/openbook.xpm");
  OpenButton->setText("&Open");
  OpenButton->setAutoRepeat( FALSE );
  OpenButton->setAutoResize( FALSE );
  OpenButton->setToggleButton( FALSE );
  OpenButton->setDefault( FALSE );
  OpenButton->setAutoDefault( FALSE );
  OpenButton->setIsMenuButton( FALSE );


  OpenFileButton = new QPushButton( this, "addButton" );
    OpenFileButton->setGeometry( 75, 10, 60, 22 );
    OpenFileButton->setMinimumSize( 0, 0 );
//  OpenFileButton->setFocusPolicy( QWidget::TabFocus );
//  OpenFileButton->setBackgroundMode( QWidget::PaletteBackground );
//  OpenFileButton->setFontPropagation( QWidget::NoChildren );
//  OpenFileButton->setPalettePropagation( QWidget::NoChildren );
//  OpenFileButton->setPixmap(  "/usr/share/gutenbrowser/pix/fileopen.xpm");
  OpenFileButton->setText("&Add Titles");
  OpenFileButton->setAutoRepeat( FALSE );
  OpenFileButton->setAutoResize( FALSE );
  OpenFileButton->setToggleButton( FALSE );
  OpenFileButton->setDefault( FALSE );
  OpenFileButton->setAutoDefault( FALSE );
  OpenFileButton->setIsMenuButton( FALSE );

  RemoveButton = new QPushButton( this, "removeButton" );
    RemoveButton->setGeometry( 140, 10, 60, 22 );
    RemoveButton->setMinimumSize( 0, 0 );
    RemoveButton->setFocusPolicy( QWidget::TabFocus );
//  RemoveButton->setBackgroundMode( QWidget::PaletteBackground );
//  RemoveButton->setFontPropagation( QWidget::NoChildren );
//  RemoveButton->setPalettePropagation( QWidget::NoChildren );
//  RemoveButton->setPixmap( "/usr/share/gutenbrowser/pix/delete.xpm");
  RemoveButton->setText("&Remove");
  RemoveButton->setAutoRepeat( FALSE );
  RemoveButton->setAutoResize( FALSE );
  RemoveButton->setToggleButton( FALSE );
  RemoveButton->setDefault( FALSE );
  RemoveButton->setAutoDefault( FALSE );
  RemoveButton->setIsMenuButton( FALSE );

  QPushButton * scanButton;
  scanButton= new QPushButton( this, "scanButton" );
    scanButton->setGeometry( 205, 10, 60, 22 );
    scanButton->setMinimumSize( 0, 0 );
    scanButton->setFocusPolicy( QWidget::TabFocus );
//  RemoveButton->setBackgroundMode( QWidget::PaletteBackground );
//  RemoveButton->setFontPropagation( QWidget::NoChildren );
//  RemoveButton->setPalettePropagation( QWidget::NoChildren );
//  RemoveButton->setPixmap( "/usr/share/gutenbrowser/pix/delete.xpm");
  scanButton->setText("&Sort");
  scanButton->setAutoRepeat( FALSE );
  scanButton->setAutoResize( FALSE );
  scanButton->setToggleButton( FALSE );
  scanButton->setDefault( FALSE );
  scanButton->setAutoDefault( FALSE );
  scanButton->setIsMenuButton( FALSE );


  QPushButton_Cancel= new QPushButton(this,"CancelBtn");
  QPushButton_Cancel->setGeometry(300,10,60,22);
  QPushButton_Cancel->setMinimumSize(0,0);
  QPushButton_Cancel->setText("&Cancel");
//  QPushButton_Cancel->setPixmap(  "/usr/share/gutenbrowser/pix/exit.xpm");
 QPushButton_Cancel->setAutoRepeat( FALSE );
  QPushButton_Cancel->setAutoResize( FALSE );
  QPushButton_Cancel->setToggleButton( FALSE );
  QPushButton_Cancel->setDefault( FALSE );
  QPushButton_Cancel->setAutoDefault( FALSE );
  QPushButton_Cancel->setIsMenuButton( FALSE );


  QLabel_1= new QLabel(this,"label");
  QLabel_1->setGeometry(10,40,210,15);
  QLabel_1->setMinimumSize(0,0);

  QToolTip::add( OpenButton, (tr("Open currently selected Etext.")) );
  QToolTip::add( OpenFileButton, (tr("Add a title, or titles to the list.")) );
  QToolTip::add( RemoveButton, (tr("Remove the selected title, and try to delete the file.")) );
  QToolTip::add( QPushButton_Cancel, (tr("Cancel and go away")) );

    connect( OpenButton, SIGNAL(released()), SLOT( OpenTitle()) );
    connect( OpenFileButton, SIGNAL(released()), SLOT(open()) );
    connect( RemoveButton, SIGNAL(released()), SLOT(remove()) );
    connect( scanButton, SIGNAL(released()), SLOT( scan()) );



}
