/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PIECEWIDGET_H
#define PIECEWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class KPuzzleView;
class KPuzzleApp;

#include <qpoint.h>
#include <qpixmap.h>
#include <qevent.h>

class CPieceWidget : public QWidget
{
	Q_OBJECT
 public:
	CPieceWidget(QWidget *parent);
        void setApp(KPuzzleApp* app) { _app = app; }
	virtual ~CPieceWidget();

// Data
 public:
	QPixmap* currentPiece() const;

 protected:
	KPuzzleApp* _app;


// Implementation
 public:

 protected:
// Where in this widget should the piece be drawn (for centering)
	QRect getPieceDrawRect() const;
	virtual void paintEvent(QPaintEvent* event);

 public slots:
	void slotNextClicked();
        void slotPrevClicked();
	void slotTurn1Clicked();
	void slotTurn2Clicked();
};

#endif // PIECEWIDGET_H
