/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PREFS_H
#define PREFS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdialog.h>

#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qlayout.h>

class CPrefsDialog : public QDialog
{
	Q_OBJECT
 public:
	CPrefsDialog(QWidget* parent);
	virtual ~CPrefsDialog();

	void setValues();
	void retrieveValues();

 public:
	bool _usePieceMask;
	bool _turnPiecesAround;
        bool _rightKeyPansAround;
        bool _showMainPixmap;
	int _imageLoading;

 protected:
	QCheckBox* _mask;
	QCheckBox* _turn;
        QCheckBox* _right;
        QCheckBox* _main;
	QButtonGroup* _loading;

	QRadioButton* _ilOnUse;
	QRadioButton* _ilKeep;
	QRadioButton* _ilPreload;

	QVBoxLayout* _elements;
        QVBoxLayout* _group;
	QHBoxLayout* _buttons;

	QPushButton* _ok;
	QPushButton* _cancel;
        QPushButton* _help;

 protected slots:
        void slotHelp();
};

#endif // PREFS_H
