/****************************************************************************************
 * Copyright (c) 2012 Jasneet Singh Bhatti <jazneetbhatti@gmail.com>                    *
 * This program is free software; you can redistribute it and/or modify it under        *
 * the terms of the GNU General Public License as published by the Free Software        *
 * Foundation; either version 2 of the License, or (at your option) any later           *
 * version.                                                                             *
 *                                                                                      *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY      *
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A      *
 * PARTICULAR PURPOSE. See the GNU General Public License for more details.             *
 *                                                                                      *
 * You should have received a copy of the GNU General Public License along with         *
 * this program.  If not, see <http://www.gnu.org/licenses/>.                           *
 ****************************************************************************************/

#ifndef COLLECTIONS_MOCKQUERYMAKER
#define COLLECTIONS_MOCKQUERYMAKER

#include "core/collections/QueryMaker.h"

using namespace Collections;

/**
 * Ad-hoc mock to test the QueryMaker class
 */
class MockQueryMaker : public QueryMaker
{
    Q_OBJECT

    public:
        /**
         * For the vtable generated by the compiler
         */
        ~MockQueryMaker() override;

        /**
         * To prevent QueryMaker::addMatch( const Meta::LabelPtr& ) from being hidden
         */
        using QueryMaker::addMatch;

        /**
         * Mock implementations of pure virtual methods of class Collections::QueryMaker
         * to enable creation of an instance of this mock class
         *
         * NOT TO BE USED ANYWHERE IN THE TEST
         */
        void run() override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
        }

        void abortQuery() override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
        }

        QueryMaker *setQueryType( QueryType ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addReturnValue( qint64 ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addReturnFunction( ReturnFunction, qint64 ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *orderBy( qint64, bool ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addMatch( const Meta::TrackPtr& ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addMatch( const Meta::ArtistPtr& , ArtistMatchBehaviour ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addMatch( const Meta::AlbumPtr& ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addMatch( const Meta::ComposerPtr& ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addMatch( const Meta::GenrePtr& ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addMatch( const Meta::YearPtr& ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addFilter( qint64, const QString&, bool, bool ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *excludeFilter( qint64, const QString&, bool, bool ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *addNumberFilter( qint64, qint64, NumberComparison ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *excludeNumberFilter( qint64, qint64, NumberComparison ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *limitMaxResultSize( int ) override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *beginAnd() override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *beginOr() override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        QueryMaker *endAndOr() override
        {
            Q_ASSERT_X( false, __PRETTY_FUNCTION__, "should not be called");
            return 0;
        }

        /**
         * This method helps to determine if queryDone() has been connected/disconnected
         * with slot deleteLater()
         */
        virtual void emitQueryDone()
        {
             Q_EMIT queryDone();
        }

    public Q_SLOTS:
        /**
         * Overrides the default deleteLater() slot provided by QObject since the default
         * slot implements a deferred delete of the object and is not easily testable
         * We only need to test if the slot is triggered or not
         */
        virtual void deleteLater()
        {
            Q_EMIT destroyed();
        }
};

#endif // COLLECTIONS_MOCKQUERYMAKER_H
