/***************************************************************************
 * copyright            : (C) 2008 Shane King <kde@dontletsstart.com>      *
 **************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#define DEBUG_PREFIX "lastfm"

#include "LastFmServiceCollection.h"
#include "meta/LastFmMeta.h"

#include "support/MemoryQueryMaker.h"

#include <KLocale>


LastFmServiceCollection::LastFmServiceCollection()
    : ServiceDynamicCollection( "last.fm", "last.fm" ) 
{
}


LastFmServiceCollection::~LastFmServiceCollection()
{
}


bool 
LastFmServiceCollection::possiblyContainsTrack( const KUrl &url ) const
{
    return url.protocol() == "lastfm";
}


Meta::TrackPtr 
LastFmServiceCollection::trackForUrl( const KUrl &url )
{
    return Meta::TrackPtr( new LastFm::Track( url.url() ) );
}


QString 
LastFmServiceCollection::collectionId() const
{
    return "last.fm";
}


QString 
LastFmServiceCollection::prettyName() const
{
    return i18n( "last.fm" );
}


QueryMaker*
LastFmServiceCollection::queryMaker()
{
    // TODO
    return new MemoryQueryMaker( this, collectionId() );
}
